/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.client.console.rest.ExecutionRestClient;
import org.apache.syncope.client.lib.batch.BatchRequest;
import org.apache.syncope.client.ui.commons.DateOps;
import org.apache.syncope.common.lib.form.SyncopeForm;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.NotificationTaskTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.to.TaskTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.rest.api.batch.BatchRequestItem;
import org.apache.syncope.common.rest.api.batch.BatchResponseItem;
import org.apache.syncope.common.rest.api.beans.ExecQuery;
import org.apache.syncope.common.rest.api.beans.ExecSpecs;
import org.apache.syncope.common.rest.api.beans.TaskQuery;
import org.apache.syncope.common.rest.api.service.TaskService;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;

public class TaskRestClient
extends BaseRestClient
implements ExecutionRestClient {
    private static final long serialVersionUID = 6284485820911028843L;

    public JobTO getJob(String key) {
        return this.getService(TaskService.class).getJob(key);
    }

    public List<JobTO> listJobs() {
        return this.getService(TaskService.class).listJobs();
    }

    public void actionJob(String refKey, JobAction jobAction) {
        this.getService(TaskService.class).actionJob(refKey, jobAction);
    }

    public int count(TaskType kind) {
        return this.getService(TaskService.class).search((TaskQuery)((TaskQuery.Builder)((TaskQuery.Builder)new TaskQuery.Builder(kind).page(Integer.valueOf(1))).size(Integer.valueOf(0))).build()).getTotalCount();
    }

    public int count(String resource, TaskType kind) {
        return this.getService(TaskService.class).search((TaskQuery)((TaskQuery.Builder)((TaskQuery.Builder)new TaskQuery.Builder(kind).resource(resource).page(Integer.valueOf(1))).size(Integer.valueOf(0))).build()).getTotalCount();
    }

    public int count(AnyTypeKind anyTypeKind, String entityKey, TaskType kind) {
        return this.getService(TaskService.class).search((TaskQuery)((TaskQuery.Builder)((TaskQuery.Builder)new TaskQuery.Builder(kind).anyTypeKind(anyTypeKind).entityKey(entityKey).page(Integer.valueOf(1))).size(Integer.valueOf(0))).build()).getTotalCount();
    }

    public int count(AnyTypeKind anyTypeKind, String entityKey, String notification) {
        return this.getService(TaskService.class).search((TaskQuery)((TaskQuery.Builder)((TaskQuery.Builder)new TaskQuery.Builder(TaskType.NOTIFICATION).notification(notification).anyTypeKind(anyTypeKind).entityKey(entityKey).page(Integer.valueOf(1))).size(Integer.valueOf(0))).build()).getTotalCount();
    }

    @Override
    public int countExecutions(String taskKey) {
        return this.getService(TaskService.class).listExecutions((ExecQuery)((ExecQuery.Builder)((ExecQuery.Builder)new ExecQuery.Builder().key(taskKey).page(Integer.valueOf(1))).size(Integer.valueOf(0))).build()).getTotalCount();
    }

    public List<PropagationTaskTO> listPropagationTasks(String resource, int page, int size, SortParam<String> sort) {
        return this.getService(TaskService.class).search((TaskQuery)((TaskQuery.Builder)((TaskQuery.Builder)((TaskQuery.Builder)new TaskQuery.Builder(TaskType.PROPAGATION).resource(resource).page(Integer.valueOf(page))).size(Integer.valueOf(size))).orderBy(TaskRestClient.toOrderBy(sort))).build()).getResult();
    }

    public List<PropagationTaskTO> listPropagationTasks(AnyTypeKind anyTypeKind, String entityKey, int page, int size, SortParam<String> sort) {
        return this.getService(TaskService.class).search((TaskQuery)((TaskQuery.Builder)((TaskQuery.Builder)((TaskQuery.Builder)new TaskQuery.Builder(TaskType.PROPAGATION).anyTypeKind(anyTypeKind).entityKey(entityKey).page(Integer.valueOf(page))).size(Integer.valueOf(size))).orderBy(TaskRestClient.toOrderBy(sort))).build()).getResult();
    }

    public List<NotificationTaskTO> listNotificationTasks(String notification, AnyTypeKind anyTypeKind, String entityKey, int page, int size, SortParam<String> sort) {
        TaskQuery.Builder builder = new TaskQuery.Builder(TaskType.NOTIFICATION);
        if (notification != null) {
            builder.notification(notification);
        }
        if (anyTypeKind != null) {
            builder.anyTypeKind(anyTypeKind);
        }
        if (entityKey != null) {
            builder.entityKey(entityKey);
        }
        PagedResult list = this.getService(TaskService.class).search((TaskQuery)((TaskQuery.Builder)((TaskQuery.Builder)((TaskQuery.Builder)builder.page(Integer.valueOf(page))).size(Integer.valueOf(size))).orderBy(TaskRestClient.toOrderBy(sort))).build());
        return list.getResult();
    }

    public <T extends TaskTO> List<T> list(TaskType taskType, int page, int size, SortParam<String> sort) {
        return this.getService(TaskService.class).search((TaskQuery)((TaskQuery.Builder)((TaskQuery.Builder)((TaskQuery.Builder)new TaskQuery.Builder(taskType).page(Integer.valueOf(page))).size(Integer.valueOf(size))).orderBy(TaskRestClient.toOrderBy(sort))).build()).getResult();
    }

    public <T extends TaskTO> List<T> list(String resource, TaskType taskType, int page, int size, SortParam<String> sort) {
        return this.getService(TaskService.class).search((TaskQuery)((TaskQuery.Builder)((TaskQuery.Builder)((TaskQuery.Builder)new TaskQuery.Builder(taskType).page(Integer.valueOf(page))).size(Integer.valueOf(size))).resource(resource).orderBy(TaskRestClient.toOrderBy(sort))).build()).getResult();
    }

    @Override
    public List<ExecTO> listExecutions(String taskKey, int page, int size, SortParam<String> sort) {
        return this.getService(TaskService.class).listExecutions((ExecQuery)((ExecQuery.Builder)((ExecQuery.Builder)((ExecQuery.Builder)new ExecQuery.Builder().key(taskKey).page(Integer.valueOf(page))).size(Integer.valueOf(size))).orderBy(TaskRestClient.toOrderBy(sort))).build()).getResult();
    }

    public PropagationTaskTO readPropagationTask(String taskKey) {
        return (PropagationTaskTO)this.getService(TaskService.class).read(TaskType.PROPAGATION, taskKey, false);
    }

    public NotificationTaskTO readNotificationTask(String taskKey) {
        return (NotificationTaskTO)this.getService(TaskService.class).read(TaskType.NOTIFICATION, taskKey, false);
    }

    public <T extends TaskTO> T readTask(TaskType type, String taskKey) {
        return (T)this.getService(TaskService.class).read(type, taskKey, false);
    }

    public SyncopeForm getMacroTaskForm(String taskKey) {
        return this.getService(TaskService.class).getMacroTaskForm(taskKey);
    }

    public void delete(TaskType type, String taskKey) {
        this.getService(TaskService.class).delete(type, taskKey);
    }

    @Override
    public void startExecution(String taskKey, Date startAt) {
        this.startExecution(taskKey, startAt, false);
    }

    public void startExecution(String taskKey, Date startAt, boolean dryRun) {
        this.getService(TaskService.class).execute(new ExecSpecs.Builder().key(taskKey).startAt(DateOps.toOffsetDateTime((Date)startAt)).dryRun(dryRun).build());
    }

    public void startExecution(String taskKey, Date startAt, boolean dryRun, SyncopeForm macroTaskForm) {
        this.getService(TaskService.class).execute(new ExecSpecs.Builder().key(taskKey).startAt(DateOps.toOffsetDateTime((Date)startAt)).dryRun(dryRun).build(), macroTaskForm);
    }

    @Override
    public void deleteExecution(String taskExecKey) {
        this.getService(TaskService.class).deleteExecution(taskExecKey);
    }

    @Override
    public List<ExecTO> listRecentExecutions(int max) {
        return this.getService(TaskService.class).listRecentExecutions(max);
    }

    public void create(TaskType type, SchedTaskTO taskTO) {
        this.getService(TaskService.class).create(type, taskTO);
    }

    public void update(TaskType type, SchedTaskTO taskTO) {
        this.getService(TaskService.class).update(type, taskTO);
    }

    @Override
    public Map<String, String> batch(BatchRequest batchRequest) {
        ArrayList batchRequestItems = new ArrayList(batchRequest.getItems());
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        try {
            List batchResponseItems = batchRequest.commit().getItems();
            for (int i = 0; i < batchResponseItems.size(); ++i) {
                String status = this.getStatus(((BatchResponseItem)batchResponseItems.get(i)).getStatus());
                if (((BatchRequestItem)batchRequestItems.get(i)).getRequestURI().contains("/execute")) {
                    result.put(StringUtils.substringAfterLast((String)StringUtils.substringBefore((String)((BatchRequestItem)batchRequestItems.get(i)).getRequestURI(), (String)"/execute"), (String)"/"), status);
                    continue;
                }
                result.put(StringUtils.substringAfterLast((String)((BatchRequestItem)batchRequestItems.get(i)).getRequestURI(), (String)"/"), status);
            }
        }
        catch (IOException e) {
            LOG.error("While processing Batch response", (Throwable)e);
        }
        return result;
    }
}

