/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull.stream;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.Mapping;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.MappingPurpose;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.policy.PullCorrelationRuleEntity;
import org.apache.syncope.core.persistence.api.entity.policy.PullPolicy;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.GroupPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.apache.syncope.core.provisioning.api.pushpull.stream.SyncopeStreamPullExecutor;
import org.apache.syncope.core.provisioning.java.pushpull.PullJobDelegate;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class StreamPullJobDelegate
extends PullJobDelegate
implements SyncopeStreamPullExecutor {
    @Autowired
    private ImplementationDAO implementationDAO;
    @Autowired
    private RealmDAO realmDAO;

    private PullPolicy pullPolicy(AnyType anyType, ConflictResolutionAction conflictResolutionAction, String pullCorrelationRule) {
        PullCorrelationRuleEntity pullCorrelationRuleEntity = null;
        if (pullCorrelationRule != null) {
            Implementation impl = this.implementationDAO.find(pullCorrelationRule);
            if (impl == null || !"PULL_CORRELATION_RULE".equals(impl.getType())) {
                LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", (Object)pullCorrelationRule);
            } else {
                pullCorrelationRuleEntity = (PullCorrelationRuleEntity)this.entityFactory.newEntity(PullCorrelationRuleEntity.class);
                pullCorrelationRuleEntity.setAnyType(anyType);
                pullCorrelationRuleEntity.setImplementation(impl);
            }
        }
        PullPolicy pullPolicy = (PullPolicy)this.entityFactory.newEntity(PullPolicy.class);
        pullPolicy.setConflictResolutionAction(conflictResolutionAction);
        if (pullCorrelationRuleEntity != null) {
            pullPolicy.add(pullCorrelationRuleEntity);
            pullCorrelationRuleEntity.setPullPolicy(pullPolicy);
        }
        return pullPolicy;
    }

    private Provision provision(AnyType anyType, String keyColumn, List<String> columns) throws JobExecutionException {
        PlainSchema keyColumnSchema;
        Provision provision = new Provision();
        provision.setAnyType(anyType.getKey());
        provision.setObjectClass(anyType.getKey());
        Mapping mapping = new Mapping();
        provision.setMapping(mapping);
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(anyType.getKind());
        if (anyUtils.getField(keyColumn) == null && (keyColumnSchema = (PlainSchema)this.plainSchemaDAO.find(keyColumn)) == null) {
            throw new JobExecutionException("Plain Schema for key column not found: " + keyColumn);
        }
        Item connObjectKeyItem = new Item();
        connObjectKeyItem.setExtAttrName(keyColumn);
        connObjectKeyItem.setIntAttrName(keyColumn);
        connObjectKeyItem.setPurpose(MappingPurpose.PULL);
        mapping.setConnObjectKeyItem(connObjectKeyItem);
        columns.stream().filter(column -> anyUtils.getField(column) != null || this.plainSchemaDAO.find(column) != null || this.virSchemaDAO.find(column) != null).map(column -> {
            Item item = new Item();
            item.setExtAttrName(column);
            item.setIntAttrName(column);
            item.setPurpose(MappingPurpose.PULL);
            mapping.add(item);
            return item;
        }).forEach(arg_0 -> ((Mapping)mapping).add(arg_0));
        return provision;
    }

    private ExternalResource externalResource(AnyType anyType, String keyColumn, List<String> columns, ConflictResolutionAction conflictResolutionAction, String pullCorrelationRule) throws JobExecutionException {
        Provision provision = this.provision(anyType, keyColumn, columns);
        ExternalResource resource = (ExternalResource)this.entityFactory.newEntity(ExternalResource.class);
        resource.setKey("StreamPull_" + SecureRandomUtils.generateRandomUUID().toString());
        resource.getProvisions().add(provision);
        resource.setPullPolicy(this.pullPolicy(anyType, conflictResolutionAction, pullCorrelationRule));
        return resource;
    }

    public List<ProvisioningReport> pull(AnyType anyType, String keyColumn, List<String> columns, ConflictResolutionAction conflictResolutionAction, String pullCorrelationRule, Connector connector, PullTaskTO pullTaskTO, String executor) throws JobExecutionException {
        LOG.debug("Executing stream pull");
        this.taskType = TaskType.PULL;
        try {
            GroupPullResultHandler handler;
            ExternalResource resource = this.externalResource(anyType, keyColumn, columns, conflictResolutionAction, pullCorrelationRule);
            Provision provision = (Provision)resource.getProvisions().get(0);
            this.task = (SchedTask)this.entityFactory.newEntity(PullTask.class);
            ((PullTask)this.task).setResource(resource);
            ((PullTask)this.task).setMatchingRule(pullTaskTO.getMatchingRule());
            ((PullTask)this.task).setUnmatchingRule(pullTaskTO.getUnmatchingRule());
            ((PullTask)this.task).setPullMode(PullMode.FULL_RECONCILIATION);
            ((PullTask)this.task).setPerformCreate(true);
            ((PullTask)this.task).setPerformUpdate(true);
            ((PullTask)this.task).setPerformDelete(false);
            ((PullTask)this.task).setSyncStatus(false);
            ((PullTask)this.task).setDestinationRealm(this.realmDAO.findByFullPath(pullTaskTO.getDestinationRealm()));
            ((PullTask)this.task).setRemediation(pullTaskTO.isRemediation());
            this.profile = new ProvisioningProfile(connector, (ProvisioningTask)((PullTask)this.task));
            this.profile.setDryRun(false);
            this.profile.setConflictResolutionAction(conflictResolutionAction);
            this.profile.getActions().addAll(this.getPullActions(pullTaskTO.getActions().stream().map(arg_0 -> ((ImplementationDAO)this.implementationDAO).find(arg_0)).filter(Objects::nonNull).collect(Collectors.toList())));
            this.profile.setExecutor(executor);
            for (PullActions action : this.profile.getActions()) {
                action.beforeAll(this.profile);
            }
            GroupPullResultHandler ghandler = this.buildGroupHandler();
            switch (anyType.getKind()) {
                case USER: {
                    handler = this.buildUserHandler();
                    break;
                }
                case GROUP: {
                    handler = ghandler;
                    break;
                }
                default: {
                    handler = this.buildAnyObjectHandler();
                }
            }
            handler.setProfile(this.profile);
            HashSet moreAttrsToGet = new HashSet();
            this.profile.getActions().forEach(a -> moreAttrsToGet.addAll(a.moreAttrsToGet(this.profile, provision)));
            Stream<Item> mapItems = Stream.concat(MappingUtils.getPullItems(provision.getMapping().getItems().stream()), this.virSchemaDAO.find(resource.getKey(), anyType.getKey()).stream().map(VirSchema::asLinkingMappingItem));
            connector.fullReconciliation(new ObjectClass(provision.getObjectClass()), (SyncResultsHandler)handler, MappingUtils.buildOperationOptions(mapItems, (String[])moreAttrsToGet.toArray(String[]::new)));
            try {
                this.setGroupOwners(ghandler);
            }
            catch (Exception e) {
                LOG.error("While setting group owners", (Throwable)e);
            }
            for (PullActions action : this.profile.getActions()) {
                action.afterAll(this.profile);
            }
            List list = this.profile.getResults();
            return list;
        }
        catch (Exception e) {
            throw e instanceof JobExecutionException ? (JobExecutionException)((Object)e) : new JobExecutionException("While stream pulling", (Throwable)e);
        }
        finally {
            this.setStatus(null);
        }
    }
}

