/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.request.AbstractPatchItem;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.OrgUnit;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.task.PropagationData;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.UserWorkflowResult;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.provisioning.java.propagation.DeletingLinkedAccount;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeDeltaBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Transactional(rollbackFor={Throwable.class})
public class DefaultPropagationManager
implements PropagationManager {
    protected static final Logger LOG = LoggerFactory.getLogger(PropagationManager.class);
    protected final VirSchemaDAO virSchemaDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final EntityFactory entityFactory;
    protected final ConnObjectUtils connObjectUtils;
    protected final MappingManager mappingManager;
    protected final DerAttrHandler derAttrHandler;
    protected final AnyUtilsFactory anyUtilsFactory;

    public DefaultPropagationManager(VirSchemaDAO virSchemaDAO, ExternalResourceDAO resourceDAO, EntityFactory entityFactory, ConnObjectUtils connObjectUtils, MappingManager mappingManager, DerAttrHandler derAttrHandler, AnyUtilsFactory anyUtilsFactory) {
        this.virSchemaDAO = virSchemaDAO;
        this.resourceDAO = resourceDAO;
        this.entityFactory = entityFactory;
        this.connObjectUtils = connObjectUtils;
        this.mappingManager = mappingManager;
        this.derAttrHandler = derAttrHandler;
        this.anyUtilsFactory = anyUtilsFactory;
    }

    public List<PropagationTaskInfo> getCreateTasks(AnyTypeKind kind, String key, Boolean enable, PropagationByResource<String> propByRes, Collection<Attr> vAttrs, Collection<String> excludedResources) {
        return this.getCreateTasks(this.anyUtilsFactory.getInstance(kind).dao().authFind(key), null, enable, propByRes, null, vAttrs, excludedResources);
    }

    public List<PropagationTaskInfo> getUserCreateTasks(String key, String password, Boolean enable, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount, Collection<Attr> vAttrs, Collection<String> excludedResources) {
        return this.getCreateTasks(this.anyUtilsFactory.getInstance(AnyTypeKind.USER).dao().authFind(key), password, enable, propByRes, propByLinkedAccount, vAttrs, excludedResources);
    }

    protected List<PropagationTaskInfo> getCreateTasks(Any<?> any, String password, Boolean enable, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount, Collection<Attr> vAttrs, Collection<String> excludedResources) {
        if ((propByRes == null || propByRes.isEmpty()) && (propByLinkedAccount == null || propByLinkedAccount.isEmpty())) {
            return List.of();
        }
        if (excludedResources != null) {
            if (propByRes != null) {
                propByRes.get(ResourceOperation.CREATE).removeAll(excludedResources);
            }
            if (propByLinkedAccount != null) {
                propByLinkedAccount.get(ResourceOperation.CREATE).removeIf(account -> excludedResources.contains(account.getLeft()));
            }
        }
        return this.createTasks(any, password, true, enable, propByRes, propByLinkedAccount, vAttrs);
    }

    public List<PropagationTaskInfo> getUpdateTasks(AnyUR anyUR, AnyTypeKind kind, String key, boolean changePwd, Boolean enable, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount, Collection<Attr> vAttrs, Collection<String> excludedResources) {
        return this.getUpdateTasks(anyUR, this.anyUtilsFactory.getInstance(kind).dao().authFind(key), null, changePwd, enable, propByRes, propByLinkedAccount, vAttrs, excludedResources);
    }

    public List<PropagationTaskInfo> getUserUpdateTasks(UserWorkflowResult<Pair<UserUR, Boolean>> wfResult, boolean changePwd, Collection<String> excludedResources) {
        return this.getUpdateTasks((AnyUR)((Pair)wfResult.getResult()).getLeft(), this.anyUtilsFactory.getInstance(AnyTypeKind.USER).dao().authFind(((UserUR)((Pair)wfResult.getResult()).getLeft()).getKey()), (String)Optional.ofNullable(((UserUR)((Pair)wfResult.getResult()).getLeft()).getPassword()).map(AbstractPatchItem::getValue).orElse(null), changePwd, (Boolean)((Pair)wfResult.getResult()).getRight(), (PropagationByResource<String>)wfResult.getPropByRes(), (PropagationByResource<Pair<String, String>>)wfResult.getPropByLinkedAccount(), (Collection<Attr>)((UserUR)((Pair)wfResult.getResult()).getLeft()).getVirAttrs(), excludedResources);
    }

    public List<PropagationTaskInfo> getUserUpdateTasks(UserWorkflowResult<Pair<UserUR, Boolean>> wfResult) {
        List<Object> tasks;
        UserUR userUR = (UserUR)((Pair)wfResult.getResult()).getLeft();
        if (userUR.getPassword() == null) {
            tasks = this.getUserUpdateTasks(wfResult, false, null);
        } else {
            tasks = new ArrayList();
            UserWorkflowResult pwdWFResult = new UserWorkflowResult((Object)((Pair)wfResult.getResult()), new PropagationByResource(), wfResult.getPropByLinkedAccount(), wfResult.getPerformedTasks());
            HashSet<String> pwdResourceNames = new HashSet<String>(userUR.getPassword().getResources());
            Collection allResourceNames = this.anyUtilsFactory.getInstance(AnyTypeKind.USER).dao().findAllResourceKeys(userUR.getKey());
            pwdResourceNames.retainAll(allResourceNames);
            if (wfResult.getPropByRes() == null || wfResult.getPropByRes().isEmpty()) {
                pwdWFResult.getPropByRes().addAll(ResourceOperation.UPDATE, pwdResourceNames);
            } else {
                Map wfPropByResMap = wfResult.getPropByRes().asMap();
                pwdResourceNames.forEach(r -> pwdWFResult.getPropByRes().add(wfPropByResMap.getOrDefault(r, ResourceOperation.UPDATE), (Serializable)((Object)r)));
            }
            if (!pwdWFResult.getPropByRes().isEmpty()) {
                HashSet<String> toBeExcluded = new HashSet<String>(allResourceNames);
                toBeExcluded.addAll(userUR.getResources().stream().map(AbstractPatchItem::getValue).collect(Collectors.toList()));
                toBeExcluded.removeAll(pwdResourceNames);
                tasks.addAll(this.getUserUpdateTasks((UserWorkflowResult<Pair<UserUR, Boolean>>)pwdWFResult, true, toBeExcluded));
            }
            UserWorkflowResult noPwdWFResult = new UserWorkflowResult((Object)((Pair)wfResult.getResult()), new PropagationByResource(), new PropagationByResource(), wfResult.getPerformedTasks());
            noPwdWFResult.getPropByRes().merge(wfResult.getPropByRes());
            noPwdWFResult.getPropByRes().removeAll(pwdResourceNames);
            noPwdWFResult.getPropByRes().purge();
            if (!noPwdWFResult.getPropByRes().isEmpty()) {
                tasks.addAll(this.getUserUpdateTasks((UserWorkflowResult<Pair<UserUR, Boolean>>)noPwdWFResult, false, pwdResourceNames));
            }
            tasks = tasks.stream().distinct().collect(Collectors.toList());
            tasks.forEach(task -> task.setUpdateRequest((AnyUR)((Pair)wfResult.getResult()).getLeft()));
        }
        return tasks;
    }

    protected List<PropagationTaskInfo> getUpdateTasks(AnyUR anyUR, Any<?> any, String password, boolean changePwd, Boolean enable, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount, Collection<Attr> vAttrs, Collection<String> excludedResources) {
        if (excludedResources != null) {
            if (propByRes != null) {
                propByRes.removeAll(excludedResources);
            }
            if (propByLinkedAccount != null) {
                propByLinkedAccount.get(ResourceOperation.CREATE).removeIf(account -> excludedResources.contains(account.getLeft()));
                propByLinkedAccount.get(ResourceOperation.UPDATE).removeIf(account -> excludedResources.contains(account.getLeft()));
                propByLinkedAccount.get(ResourceOperation.DELETE).removeIf(account -> excludedResources.contains(account.getLeft()));
            }
        }
        List<PropagationTaskInfo> tasks = this.createTasks(any, password, changePwd, enable, (PropagationByResource<String>)Optional.ofNullable(propByRes).orElseGet(PropagationByResource::new), propByLinkedAccount, vAttrs);
        tasks.forEach(task -> task.setUpdateRequest(anyUR));
        return tasks;
    }

    public List<PropagationTaskInfo> getDeleteTasks(AnyTypeKind kind, String key, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount, Collection<String> excludedResources) {
        return this.getDeleteTasks(this.anyUtilsFactory.getInstance(kind).dao().authFind(key), propByRes, propByLinkedAccount, excludedResources);
    }

    protected List<PropagationTaskInfo> getDeleteTasks(Any<?> any, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount, Collection<String> excludedResources) {
        PropagationByResource localPropByRes = new PropagationByResource();
        if (propByRes == null || propByRes.isEmpty()) {
            localPropByRes.addAll(ResourceOperation.DELETE, this.anyUtilsFactory.getInstance(any).dao().findAllResourceKeys(any.getKey()));
        } else {
            localPropByRes.merge(propByRes);
        }
        if (excludedResources != null) {
            localPropByRes.removeAll(excludedResources);
            if (propByLinkedAccount != null) {
                propByLinkedAccount.get(ResourceOperation.CREATE).removeIf(account -> excludedResources.contains(account.getLeft()));
                propByLinkedAccount.get(ResourceOperation.UPDATE).removeIf(account -> excludedResources.contains(account.getLeft()));
                propByLinkedAccount.get(ResourceOperation.DELETE).removeIf(account -> excludedResources.contains(account.getLeft()));
            }
        }
        return this.createTasks(any, null, false, false, (PropagationByResource<String>)localPropByRes, propByLinkedAccount, null);
    }

    public PropagationTaskInfo newTask(DerAttrHandler derAttrHandler, Any<?> any, ExternalResource resource, ResourceOperation operation, Provision provision, Stream<Item> mappingItems, Pair<String, Set<Attribute>> preparedAttrs) {
        ArrayList mandatoryMissing = new ArrayList();
        ArrayList mandatoryNullOrEmpty = new ArrayList();
        mappingItems.filter(item -> !item.isConnObjectKey() && JexlUtils.evaluateMandatoryCondition((String)item.getMandatoryCondition(), (Any)any, (DerAttrHandler)derAttrHandler)).forEach(item -> {
            Attribute attr = AttributeUtil.find((String)item.getExtAttrName(), (Set)((Set)preparedAttrs.getRight()));
            if (attr == null) {
                mandatoryMissing.add(item.getExtAttrName());
            } else if (CollectionUtils.isEmpty((Collection)attr.getValue())) {
                mandatoryNullOrEmpty.add(item.getExtAttrName());
            }
        });
        if (!mandatoryMissing.isEmpty()) {
            ((Set)preparedAttrs.getRight()).add(AttributeBuilder.build((String)"__MANDATORY_MISSING__", mandatoryMissing));
        }
        if (!mandatoryNullOrEmpty.isEmpty()) {
            ((Set)preparedAttrs.getRight()).add(AttributeBuilder.build((String)"__MANDATORY_NULL_OR_EMPTY__", mandatoryNullOrEmpty));
        }
        return new PropagationTaskInfo(resource, operation, new ObjectClass(provision.getObjectClass()), any.getType().getKind(), any.getType().getKey(), any.getKey(), (String)preparedAttrs.getLeft(), new PropagationData((Set)preparedAttrs.getRight()));
    }

    protected List<PropagationTaskInfo> createTasks(Any<?> any, String password, boolean changePwd, Boolean enable, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount, Collection<Attr> vAttrs) {
        LOG.debug("Provisioning {}:\n{}", any, propByRes);
        propByRes.purge();
        LOG.debug("After purge {}:\n{}", any, propByRes);
        HashSet virtualResources = new HashSet();
        virtualResources.addAll(propByRes.get(ResourceOperation.CREATE));
        virtualResources.addAll(propByRes.get(ResourceOperation.UPDATE));
        virtualResources.addAll(this.anyUtilsFactory.getInstance(any).dao().findAllResourceKeys(any.getKey()));
        HashMap vAttrMap = new HashMap();
        if (vAttrs != null) {
            vAttrs.forEach(vAttr -> {
                VirSchema schema = (VirSchema)this.virSchemaDAO.find(vAttr.getSchema());
                if (schema == null) {
                    LOG.warn("Ignoring invalid {} {}", (Object)VirSchema.class.getSimpleName(), (Object)vAttr.getSchema());
                } else if (schema.isReadonly()) {
                    LOG.warn("Ignoring read-only {} {}", (Object)VirSchema.class.getSimpleName(), (Object)vAttr.getSchema());
                } else if (this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, VirSchema.class).contains((Schema)schema) && virtualResources.contains(schema.getResource().getKey())) {
                    HashSet<Attribute> values = (HashSet<Attribute>)vAttrMap.get(schema.getResource().getKey());
                    if (values == null) {
                        values = new HashSet<Attribute>();
                        vAttrMap.put(schema.getResource().getKey(), values);
                    }
                    values.add(AttributeBuilder.build((String)schema.getExtAttrName(), (Collection)vAttr.getValues()));
                    if (!propByRes.contains(ResourceOperation.CREATE, (Serializable)((Object)schema.getResource().getKey()))) {
                        propByRes.add(ResourceOperation.UPDATE, (Serializable)((Object)schema.getResource().getKey()));
                    }
                } else {
                    LOG.warn("{} not owned by or {} not allowed for {}", new Object[]{schema.getResource(), schema, any});
                }
            });
        }
        LOG.debug("With virtual attributes {}:\n{}\n{}", new Object[]{any, propByRes, vAttrMap});
        ArrayList<PropagationTaskInfo> tasks = new ArrayList<PropagationTaskInfo>();
        propByRes.asMap().forEach((resourceKey, operation) -> {
            Stream<Item> mappingItems;
            ExternalResource resource = this.resourceDAO.find(resourceKey);
            Provision provision = Optional.ofNullable(resource).flatMap(r -> r.getProvisionByAnyType(any.getType().getKey())).orElse(null);
            Stream<Item> stream = mappingItems = provision == null ? Stream.empty() : MappingUtils.getPropagationItems(provision.getMapping().getItems().stream());
            if (resource == null) {
                LOG.error("Invalid resource name specified: {}, ignoring...", resourceKey);
            } else if (provision == null) {
                LOG.error("No provision specified on resource {} for type {}, ignoring...", (Object)resource, (Object)any.getType());
            } else if (provision.getMapping() == null || provision.getMapping().getItems().isEmpty()) {
                LOG.warn("Requesting propagation for {} but no propagation mapping provided for {}", (Object)any.getType(), (Object)resource);
            } else {
                Pair preparedAttrs = this.mappingManager.prepareAttrsFromAny(any, password, changePwd, enable, resource, provision);
                if (vAttrMap.containsKey(resourceKey)) {
                    ((Set)preparedAttrs.getRight()).addAll((Collection)vAttrMap.get(resourceKey));
                }
                PropagationTaskInfo task = this.newTask(this.derAttrHandler, any, resource, (ResourceOperation)operation, provision, mappingItems, (Pair<String, Set<Attribute>>)preparedAttrs);
                task.setOldConnObjectKey(propByRes.getOldConnObjectKey(resourceKey));
                tasks.add(task);
                LOG.debug("PropagationTask created: {}", (Object)task);
            }
        });
        if (any instanceof User && propByLinkedAccount != null) {
            User user = (User)any;
            propByLinkedAccount.asMap().forEach((accountInfo, operation) -> {
                Stream<Item> mappingItems;
                LinkedAccount account = user.getLinkedAccount((String)accountInfo.getLeft(), (String)accountInfo.getRight()).orElse(null);
                if (account == null && operation == ResourceOperation.DELETE) {
                    account = new DeletingLinkedAccount(user, this.resourceDAO.find((String)accountInfo.getLeft()), (String)accountInfo.getRight());
                }
                Provision provision = account == null || account.getResource() == null ? null : (Provision)account.getResource().getProvisionByAnyType(AnyTypeKind.USER.name()).orElse(null);
                Stream<Item> stream = mappingItems = provision == null ? Stream.empty() : MappingUtils.getPropagationItems(provision.getMapping().getItems().stream());
                if (account == null) {
                    LOG.error("Invalid operation {} on deleted account {} on resource {}, ignoring...", new Object[]{operation, accountInfo.getRight(), accountInfo.getLeft()});
                } else if (account.getResource() == null) {
                    LOG.error("Invalid resource name specified: {}, ignoring...", accountInfo.getLeft());
                } else if (provision == null) {
                    LOG.error("No provision specified on resource {} for type {}, ignoring...", (Object)account.getResource(), (Object)AnyTypeKind.USER.name());
                } else if (provision.getMapping() == null || provision.getMapping().getItems().isEmpty()) {
                    LOG.warn("Requesting propagation for {} but no propagation mapping provided for {}", (Object)AnyTypeKind.USER.name(), (Object)account.getResource());
                } else {
                    PropagationTaskInfo accountTask = this.newTask(this.derAttrHandler, (Any<?>)user, account.getResource(), (ResourceOperation)operation, provision, mappingItems, (Pair<String, Set<Attribute>>)Pair.of((Object)account.getConnObjectKeyValue(), (Object)this.mappingManager.prepareAttrsFromLinkedAccount(user, account, password, true, provision)));
                    tasks.add(accountTask);
                    LOG.debug("PropagationTask created for Linked Account {}: {}", (Object)account.getConnObjectKeyValue(), (Object)accountTask);
                }
            });
        }
        return tasks;
    }

    public List<PropagationTaskInfo> createTasks(Realm realm, PropagationByResource<String> propByRes, Collection<String> excludedResources) {
        if (excludedResources != null) {
            propByRes.removeAll(excludedResources);
        }
        LOG.debug("Provisioning {}:\n{}", (Object)realm, propByRes);
        propByRes.purge();
        LOG.debug("After purge {}:\n{}", (Object)realm, propByRes);
        ArrayList<PropagationTaskInfo> tasks = new ArrayList<PropagationTaskInfo>();
        propByRes.asMap().forEach((resourceKey, operation) -> {
            ExternalResource resource = this.resourceDAO.find(resourceKey);
            OrgUnit orgUnit = Optional.ofNullable(resource).map(ExternalResource::getOrgUnit).orElse(null);
            if (resource == null) {
                LOG.error("Invalid resource name specified: {}, ignoring...", resourceKey);
            } else if (orgUnit == null) {
                LOG.error("No orgUnit specified on resource {}, ignoring...", (Object)resource);
            } else if (StringUtils.isBlank((CharSequence)orgUnit.getConnObjectLink())) {
                LOG.warn("Requesting propagation for {} but no ConnObjectLink provided for {}", (Object)realm.getFullPath(), (Object)resource);
            } else {
                Pair preparedAttrs = this.mappingManager.prepareAttrsFromRealm(realm, orgUnit);
                PropagationTaskInfo task = new PropagationTaskInfo(resource, operation, new ObjectClass(orgUnit.getObjectClass()), null, null, realm.getKey(), (String)preparedAttrs.getLeft(), new PropagationData((Set)preparedAttrs.getRight()));
                task.setOldConnObjectKey(propByRes.getOldConnObjectKey(resource.getKey()));
                tasks.add(task);
                LOG.debug("PropagationTask created: {}", (Object)task);
            }
        });
        return tasks;
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
    public Map<Pair<String, String>, Set<Attribute>> prepareAttrs(AnyTypeKind kind, String key, String password, boolean changePwd, Boolean enable, Collection<String> excludedResources) {
        HashMap<Pair<String, String>, Set<Attribute>> attrs = new HashMap<Pair<String, String>, Set<Attribute>>();
        Any any = this.anyUtilsFactory.getInstance(kind).dao().authFind(key);
        this.anyUtilsFactory.getInstance(kind).dao().findAllResourceKeys(key).stream().map(arg_0 -> ((ExternalResourceDAO)this.resourceDAO).find(arg_0)).filter(resource -> !excludedResources.contains(resource.getKey()) && resource.getProvisionByAnyType(any.getType().getKey()).isPresent() && resource.getPropagationPolicy() != null && resource.getPropagationPolicy().isUpdateDelta()).forEach(resource -> {
            Pair preparedAttrs = this.mappingManager.prepareAttrsFromAny(any, password, changePwd, enable, resource, (Provision)resource.getProvisionByAnyType(any.getType().getKey()).get());
            attrs.put(Pair.of((Object)resource.getKey(), (Object)((String)preparedAttrs.getLeft())), (Set)preparedAttrs.getRight());
        });
        if (any instanceof User) {
            ((User)any).getLinkedAccounts().stream().filter(account -> !excludedResources.contains(account.getResource().getKey()) && account.getResource().getProvisionByAnyType(any.getType().getKey()).isPresent() && account.getResource().getPropagationPolicy() != null && account.getResource().getPropagationPolicy().isUpdateDelta()).forEach(account -> {
                Set preparedAttrs = this.mappingManager.prepareAttrsFromLinkedAccount((User)any, account, password, true, (Provision)account.getResource().getProvisionByAnyType(any.getType().getKey()).get());
                attrs.put(Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue()), preparedAttrs);
            });
        }
        LOG.debug("Prepared attrs for {} {}: {}", new Object[]{kind, key, attrs});
        return attrs;
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
    public Map<Pair<String, String>, Set<Attribute>> prepareAttrs(Realm realm) {
        HashMap<Pair<String, String>, Set<Attribute>> attrs = new HashMap<Pair<String, String>, Set<Attribute>>();
        realm.getResources().stream().filter(resource -> resource.getOrgUnit() != null && resource.getPropagationPolicy() != null && resource.getPropagationPolicy().isUpdateDelta()).forEach(resource -> {
            Pair preparedAttrs = this.mappingManager.prepareAttrsFromRealm(realm, resource.getOrgUnit());
            attrs.put(Pair.of((Object)resource.getKey(), (Object)((String)preparedAttrs.getLeft())), (Set)preparedAttrs.getRight());
        });
        return attrs;
    }

    protected boolean isOrdinaryForAttrForDelta(Attribute attr) {
        return !attr.is(Name.NAME) && !OperationalAttributes.isOperationalAttribute((Attribute)attr);
    }

    public List<PropagationTaskInfo> setAttributeDeltas(List<PropagationTaskInfo> tasks, Map<Pair<String, String>, Set<Attribute>> beforeAttrs) {
        if (beforeAttrs.isEmpty()) {
            return tasks;
        }
        for (PropagationTaskInfo task : tasks) {
            Pair key;
            if (task.getOldConnObjectKey() != null && !task.getConnObjectKey().equals(task.getOldConnObjectKey()) || !beforeAttrs.containsKey(key = Pair.of((Object)task.getResource().getKey(), (Object)task.getConnObjectKey()))) continue;
            HashSet<Attribute> attrs = new HashSet<Attribute>((Collection)beforeAttrs.get(key));
            attrs.removeIf(attr -> "__MANDATORY_MISSING__".equals(attr.getName()) || "__MANDATORY_NULL_OR_EMPTY__".equals(attr.getName()));
            PropagationData propagationData = task.getPropagationData();
            HashSet attributeDeltas = new HashSet();
            propagationData.getAttributes().forEach(next -> {
                HashSet valuesToAdd = new HashSet();
                HashSet valuesToRemove = new HashSet();
                Optional.ofNullable(AttributeUtil.find((String)next.getName(), (Set)attrs)).ifPresent(prev -> {
                    if (next.is(OperationalAttributes.PASSWORD_NAME)) {
                        valuesToAdd.addAll(next.getValue());
                    } else if (next.getValue() == null && prev.getValue() != null) {
                        valuesToRemove.addAll(prev.getValue());
                    } else if (next.getValue() != null && prev.getValue() == null) {
                        valuesToAdd.addAll(next.getValue());
                    } else if (next.getValue() != null && prev.getValue() != null) {
                        next.getValue().stream().filter(value -> !prev.getValue().contains(value)).forEach(valuesToAdd::add);
                        prev.getValue().stream().filter(value -> !next.getValue().contains(value)).forEach(valuesToRemove::add);
                    }
                });
                if (this.isOrdinaryForAttrForDelta((Attribute)next)) {
                    if (!valuesToAdd.isEmpty() || !valuesToRemove.isEmpty()) {
                        attributeDeltas.add(AttributeDeltaBuilder.build((String)next.getName(), valuesToAdd, valuesToRemove));
                    }
                } else if (!valuesToAdd.isEmpty()) {
                    attributeDeltas.add(AttributeDeltaBuilder.build((String)next.getName(), valuesToAdd));
                }
            });
            Set nextNames = propagationData.getAttributes().stream().filter(this::isOrdinaryForAttrForDelta).map(Attribute::getName).collect(Collectors.toSet());
            Set prevNames = attrs.stream().filter(this::isOrdinaryForAttrForDelta).map(Attribute::getName).collect(Collectors.toSet());
            nextNames.stream().filter(name -> !prevNames.contains(name)).forEach(toAdd -> Optional.ofNullable(AttributeUtil.find((String)toAdd, (Set)propagationData.getAttributes())).ifPresent(attr -> attributeDeltas.add(AttributeDeltaBuilder.build((String)attr.getName(), (Collection)attr.getValue(), Set.of()))));
            prevNames.stream().filter(name -> !nextNames.contains(name)).forEach(toRemove -> Optional.ofNullable(AttributeUtil.find((String)toRemove, (Set)attrs)).ifPresent(attr -> attributeDeltas.add(AttributeDeltaBuilder.build((String)attr.getName(), Set.of(), (Collection)attr.getValue()))));
            if (attributeDeltas.isEmpty()) continue;
            propagationData.setAttributeDeltas(attributeDeltas);
        }
        return tasks;
    }
}

