/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.panels.captcha;

import java.security.SecureRandom;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.RandomStringGenerator;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.extensions.markup.html.captcha.CaptchaImageResource;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.IResource;

public class CaptchaPanel<T>
extends Panel {
    private static final long serialVersionUID = -450657681453274465L;
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final RandomStringGenerator RANDOM_LETTERS = new RandomStringGenerator.Builder().usingRandom(RANDOM::nextInt).withinRange(97, 122).build();
    private final Model<String> captchaText = new Model();
    private final CaptchaImageResource captchaImageResource = new CaptchaImageResource(){
        private static final long serialVersionUID = 2436829189992948005L;

        protected byte[] render() {
            this.getChallengeIdModel().setObject((Object)RANDOM_LETTERS.generate(6));
            return super.render();
        }
    };

    public CaptchaPanel(String id) {
        super(id);
        final Image captchaImage = new Image("image", (IResource)this.captchaImageResource, new IResource[0]);
        captchaImage.setOutputMarkupId(true);
        this.add(new Component[]{captchaImage});
        this.add(new Component[]{new AjaxButton("reloadButton"){
            private static final long serialVersionUID = -957948639666058749L;

            protected void onSubmit(AjaxRequestTarget target) {
                CaptchaPanel.this.captchaImageResource.invalidate();
                target.add(new Component[]{captchaImage});
            }
        }.setDefaultFormProcessing(false)});
        this.add(new Component[]{new AjaxTextFieldPanel("captcha", "captcha", this.captchaText).hideLabel().setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true)});
    }

    public boolean check() {
        boolean check = StringUtils.isBlank((CharSequence)((CharSequence)((Object)this.captchaText.getObject()))) || StringUtils.isBlank((CharSequence)this.captchaImageResource.getChallengeId()) ? false : ((String)((Object)this.captchaText.getObject())).equals(this.captchaImageResource.getChallengeId());
        this.captchaImageResource.invalidate();
        return check;
    }
}

