/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.pages;

import java.io.Serializable;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.SyncopeWebApplication;
import org.apache.syncope.client.enduser.pages.BasePage;
import org.apache.syncope.client.enduser.pages.Login;
import org.apache.syncope.client.enduser.pages.SelfResult;
import org.apache.syncope.client.enduser.panels.captcha.CaptchaPanel;
import org.apache.syncope.client.enduser.rest.SecurityQuestionRestClient;
import org.apache.syncope.client.enduser.rest.UserSelfRestClient;
import org.apache.syncope.client.ui.commons.panels.CardPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.SecurityQuestionTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class SelfPasswordReset
extends BasePage {
    private static final long serialVersionUID = 164651008547631054L;
    protected static final String SELF_PWD_RESET = "page.selfPwdReset";
    @SpringBean
    protected UserSelfRestClient userSelfRestClient;
    @SpringBean
    protected SecurityQuestionRestClient securityQuestionRestClient;
    protected String usernameValue;
    protected String securityAnswerValue;
    protected final CaptchaPanel<Void> captcha;
    protected final SelfPwdResetPanel pwdResetPanel;

    public SelfPasswordReset(PageParameters parameters) {
        super(parameters, SELF_PWD_RESET);
        this.setDomain(parameters);
        this.disableSidebar();
        this.captcha = new CaptchaPanel("captchaPanel");
        this.captcha.setOutputMarkupPlaceholderTag(true);
        this.captcha.setVisible(SyncopeWebApplication.get().isCaptchaEnabled());
        WebMarkupContainer content = new WebMarkupContainer("content");
        content.setOutputMarkupId(true);
        this.contentWrapper.add(new Component[]{content});
        Form form = new Form("selfPwdResetForm");
        content.add(new Component[]{form});
        this.pwdResetPanel = new SelfPwdResetPanel("contentPanel", this.captcha, this.getPageReference());
        this.pwdResetPanel.setOutputMarkupId(true);
        form.add(new Component[]{new CardPanel.Builder().setName("selfPasswordResetPanel").setComponent((Component)this.pwdResetPanel).isVisible(true).build("selfPasswordResetPanelCard")});
        AjaxButton submitButton = new AjaxButton("submit"){
            private static final long serialVersionUID = 4284361595033427185L;

            protected void onSubmit(AjaxRequestTarget target) {
                if (SyncopeWebApplication.get().isCaptchaEnabled() && !SelfPasswordReset.this.captcha.check()) {
                    SyncopeEnduserSession.get().error((Serializable)((Object)this.getString("captcha_error")));
                    SelfPasswordReset.this.getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                } else {
                    PageParameters parameters = new PageParameters();
                    try {
                        SelfPasswordReset.this.userSelfRestClient.requestPasswordReset(SelfPasswordReset.this.usernameValue, SelfPasswordReset.this.securityAnswerValue);
                        parameters.add("status", (Object)"operation_succeeded");
                        parameters.add("notificationTitle", (Object)this.getString("self.pwd.reset.success"));
                        parameters.add("notificationMessage", (Object)this.getString("self.pwd.reset.success.msg"));
                        parameters.add("landingPage", (Object)Login.class.getName());
                        this.setResponsePage(SelfResult.class, parameters);
                    }
                    catch (SyncopeClientException sce) {
                        LOG.error("Unable to reset password of [{}]", (Object)SelfPasswordReset.this.usernameValue, (Object)sce);
                        SyncopeEnduserSession.get().onException((Exception)((Object)sce));
                        SelfPasswordReset.this.getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                }
            }
        };
        submitButton.setOutputMarkupId(true);
        submitButton.setDefaultFormProcessing(false);
        form.add(new Component[]{submitButton});
        Button cancel = new Button("cancel"){
            private static final long serialVersionUID = 3669569969172391336L;

            public void onSubmit() {
                this.setResponsePage(this.getApplication().getHomePage());
            }
        };
        cancel.setOutputMarkupId(true);
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
    }

    public class SelfPwdResetPanel
    extends Panel {
        private static final long serialVersionUID = -2841210052053545578L;
        private final TextField<String> securityQuestion;

        SelfPwdResetPanel(String id, CaptchaPanel<Void> captcha, final PageReference pageRef) {
            super(id);
            final boolean isSecurityQuestionEnabled = SyncopeEnduserSession.get().getPlatformInfo().isPwdResetRequiringSecurityQuestions();
            TextField username = new TextField("username", (IModel)new PropertyModel((Object)SelfPasswordReset.this, "usernameValue"), String.class);
            username.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("blur"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    if (isSecurityQuestionEnabled) {
                        SelfPwdResetPanel.this.loadSecurityQuestion(pageRef, target);
                    }
                }
            }});
            username.setRequired(true);
            this.add(new Component[]{username});
            Label sqLabel = new Label("securityQuestionLabel", (IModel)new ResourceModel("securityQuestion", "securityQuestion"));
            sqLabel.setOutputMarkupPlaceholderTag(true);
            sqLabel.setVisible(isSecurityQuestionEnabled);
            this.add(new Component[]{sqLabel});
            this.securityQuestion = new TextField("securityQuestion", (IModel)new PropertyModel((Object)Model.of(), "content"), String.class);
            this.securityQuestion.setOutputMarkupId(true);
            this.securityQuestion.setEnabled(false);
            this.securityQuestion.setOutputMarkupPlaceholderTag(true);
            this.securityQuestion.setVisible(isSecurityQuestionEnabled);
            this.add(new Component[]{this.securityQuestion});
            Label notLoading = new Label("not.loading", (IModel)new ResourceModel("not.loading", "not.loading"));
            notLoading.setOutputMarkupPlaceholderTag(true);
            notLoading.setVisible(isSecurityQuestionEnabled);
            this.add(new Component[]{notLoading});
            AjaxLink<Void> reloadLink = new AjaxLink<Void>("reloadLink"){
                private static final long serialVersionUID = -817438685948164787L;

                public void onClick(AjaxRequestTarget target) {
                    SelfPwdResetPanel.this.loadSecurityQuestion(pageRef, target);
                }
            };
            reloadLink.setOutputMarkupPlaceholderTag(true);
            reloadLink.setVisible(isSecurityQuestionEnabled);
            this.add(new Component[]{reloadLink});
            Label saLabel = new Label("securityAnswerLabel", (IModel)new ResourceModel("securityAnswer", "securityAnswer"));
            saLabel.setOutputMarkupPlaceholderTag(true);
            saLabel.setVisible(isSecurityQuestionEnabled);
            this.add(new Component[]{saLabel});
            TextField securityAnswer = new TextField("securityAnswer", (IModel)new PropertyModel((Object)SelfPasswordReset.this, "securityAnswerValue"), String.class);
            securityAnswer.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                }
            }});
            securityAnswer.setRequired(isSecurityQuestionEnabled);
            securityAnswer.setOutputMarkupPlaceholderTag(true);
            securityAnswer.setVisible(isSecurityQuestionEnabled);
            this.add(new Component[]{securityAnswer});
            this.add(new Component[]{captcha});
        }

        protected void loadSecurityQuestion(PageReference pageRef, AjaxRequestTarget target) {
            try {
                SecurityQuestionTO securityQuestionTO = SelfPasswordReset.this.securityQuestionRestClient.readByUser(SelfPasswordReset.this.usernameValue);
                this.securityQuestion.setModel((IModel)Model.of((Serializable)((Object)securityQuestionTO.getContent())));
                target.add(new Component[]{this.securityQuestion});
            }
            catch (Exception e) {
                LOG.error("Unable to get security question for [{}]", (Object)SelfPasswordReset.this.usernameValue, (Object)e);
                SyncopeEnduserSession.get().onException(e);
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }
    }
}

