/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Supplier;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningActions;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopeResultHandler;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.SyncopeAuthenticationDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ExecutorConfigurationSupport;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;

public abstract class SyncopeResultHandlerDispatcher<T extends ProvisioningTask<?>, A extends ProvisioningActions, RA extends SyncopeResultHandler<T, A>> {
    protected static final Logger LOG = LoggerFactory.getLogger(SyncopeResultHandlerDispatcher.class);
    private static final String PLACEHOLDER_PWD = "PLACEHOLDER_PWD";
    protected final Optional<ThreadPoolTaskExecutor> tpte;
    protected final Optional<ExecutorCompletionService<Void>> ecs;
    protected final Map<String, Supplier<RA>> suppliers = new ConcurrentHashMap<String, Supplier<RA>>();
    protected final Map<String, RA> handlers = new ConcurrentHashMap<String, RA>();
    protected final List<Future<Void>> futures = new ArrayList<Future<Void>>();

    protected SyncopeResultHandlerDispatcher(ProvisioningProfile<T, A> profile) {
        if (profile.getTask().getConcurrentSettings() == null) {
            this.tpte = Optional.empty();
            this.ecs = Optional.empty();
        } else {
            ThreadPoolTaskExecutor t = new ThreadPoolTaskExecutor();
            t.setCorePoolSize(profile.getTask().getConcurrentSettings().getCorePoolSize());
            t.setMaxPoolSize(profile.getTask().getConcurrentSettings().getMaxPoolSize());
            t.setQueueCapacity(profile.getTask().getConcurrentSettings().getQueueCapacity());
            t.setWaitForTasksToCompleteOnShutdown(true);
            t.setThreadNamePrefix("provisioningTask-" + profile.getTask().getKey() + "-");
            t.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
            String domain = AuthContextUtils.getDomain();
            String delegatedBy = AuthContextUtils.getDelegatedBy().orElse(null);
            Set authorities = AuthContextUtils.getAuthorities();
            t.setTaskDecorator(d -> () -> {
                UsernamePasswordAuthenticationToken placeHolderAuth = new UsernamePasswordAuthenticationToken((Object)new User(profile.getExecutor(), PLACEHOLDER_PWD, (Collection)authorities), (Object)PLACEHOLDER_PWD, (Collection)authorities);
                placeHolderAuth.setDetails((Object)new SyncopeAuthenticationDetails(domain, delegatedBy));
                SecurityContextHolder.getContext().setAuthentication((Authentication)placeHolderAuth);
                d.run();
            });
            t.initialize();
            this.tpte = Optional.of(t);
            this.ecs = Optional.of(new ExecutorCompletionService(t.getThreadPoolExecutor()));
        }
    }

    public void addHandlerSupplier(String key, Supplier<RA> supplier) {
        this.suppliers.put(key, supplier);
    }

    protected RA nonConcurrentHandler(String key) {
        return (RA)Optional.ofNullable((SyncopeResultHandler)this.handlers.get(key)).orElseGet(() -> {
            SyncopeResultHandler h = (SyncopeResultHandler)this.suppliers.get(key).get();
            this.handlers.put(key, h);
            return h;
        });
    }

    protected void submit(Runnable runnable) {
        if (this.ecs.isPresent()) {
            this.futures.add(this.ecs.get().submit(runnable, null));
        }
    }

    protected void shutdown() {
        for (Future<Void> f : this.futures) {
            try {
                f.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Unexpected error when waiting for completion", (Throwable)e);
            }
        }
        this.tpte.ifPresent(ExecutorConfigurationSupport::shutdown);
    }
}

