/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.lang.reflect.Modifier;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.policy.RuleConf;
import org.apache.syncope.common.lib.report.ReportConf;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.syncope.common.lib.types.ImplementationTypesHolder;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.provisioning.api.data.ImplementationDataBinder;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplementationDataBinderImpl
implements ImplementationDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(ImplementationDataBinder.class);
    protected final EntityFactory entityFactory;

    public ImplementationDataBinderImpl(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
    }

    public Implementation create(ImplementationTO implementationTO) {
        Implementation implementation = (Implementation)this.entityFactory.newEntity(Implementation.class);
        this.update(implementation, implementationTO);
        return implementation;
    }

    public void update(Implementation implementation, ImplementationTO implementationTO) {
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidImplementation);
        if (implementation.getType() != null && !implementation.getType().equals(implementationTO.getType())) {
            sce.getElements().add("ImplementationType cannot be changed");
            throw sce;
        }
        if (StringUtils.isBlank((CharSequence)implementationTO.getBody())) {
            sce.getElements().add("No actual implementation provided");
            throw sce;
        }
        implementation.setKey(implementationTO.getKey());
        implementation.setEngine(implementationTO.getEngine());
        implementation.setType(implementationTO.getType());
        implementation.setBody(implementationTO.getBody());
        if (implementation.getEngine() == ImplementationEngine.JAVA) {
            Class baseClazz = Optional.ofNullable((String)ImplementationTypesHolder.getInstance().getValues().get(implementation.getType())).map(intf -> {
                try {
                    return Class.forName(intf);
                }
                catch (ClassNotFoundException e) {
                    LOG.error("While resolving interface {} for implementation type {}", intf, (Object)implementation.getType());
                    return null;
                }
            }).orElse(null);
            if (baseClazz == null) {
                sce.getElements().add("No Java interface found for " + implementation.getType());
                throw sce;
            }
            switch (implementation.getType()) {
                case "REPORT_DELEGATE": {
                    ReportConf conf = (ReportConf)POJOHelper.deserialize((String)implementation.getBody(), ReportConf.class);
                    if (conf != null) break;
                    sce.getElements().add("Could not deserialize as " + ReportConf.class.getName());
                    throw sce;
                }
                case "ACCOUNT_RULE": 
                case "PASSWORD_RULE": 
                case "PULL_CORRELATION_RULE": 
                case "PUSH_CORRELATION_RULE": {
                    RuleConf rule = (RuleConf)POJOHelper.deserialize((String)implementation.getBody(), RuleConf.class);
                    if (rule != null) break;
                    sce.getElements().add("Could not deserialize as neither Account, Password, Pull nor Push Correlation RuleConf");
                    throw sce;
                }
                default: {
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(implementation.getBody());
                    }
                    catch (Exception e) {
                        LOG.error("Class '{}' not found", (Object)implementation.getBody(), (Object)e);
                        sce.getElements().add("No Java class found: " + implementation.getBody());
                        throw sce;
                    }
                    if (!baseClazz.isAssignableFrom(clazz)) {
                        sce.getElements().add("Java class " + implementation.getBody() + " must comply with " + baseClazz.getName());
                        throw sce;
                    }
                    if (!Modifier.isAbstract(clazz.getModifiers())) break;
                    sce.getElements().add("Java class " + implementation.getBody() + " is abstract");
                    throw sce;
                }
            }
        }
    }

    public ImplementationTO getImplementationTO(Implementation implementation) {
        ImplementationTO implementationTO = new ImplementationTO();
        implementationTO.setKey(implementation.getKey());
        implementationTO.setEngine(implementation.getEngine());
        implementationTO.setType(implementation.getType());
        implementationTO.setBody(implementation.getBody());
        return implementationTO;
    }
}

