/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.configuration.model.support.captcha.GoogleRecaptchaProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.CaptchaValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public abstract class BaseCaptchaValidator
implements CaptchaValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseCaptchaValidator.class);
    private static final ObjectReader READER = new ObjectMapper().findAndRegisterModules().reader();
    private final GoogleRecaptchaProperties recaptchaProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validate(String recaptchaResponse, String userAgent) {
        HttpResponse response = null;
        try {
            HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().method(HttpMethod.POST).url(this.recaptchaProperties.getVerifyUrl()).headers(CollectionUtils.wrap((String)"User-Agent", (Object)userAgent, (String)"Accept-Language", (Object)"en-US,en;q=0.5")).parameters(CollectionUtils.wrap((String)"secret", (Object)this.recaptchaProperties.getSecret(), (String)"response", (Object)recaptchaResponse)).build();
            response = HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
            if (response != null && response.getStatusLine().getStatusCode() == HttpStatus.OK.value()) {
                String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                if (StringUtils.isBlank((CharSequence)result)) {
                    throw new IllegalArgumentException("Unable to parse empty entity response from " + this.recaptchaProperties.getVerifyUrl());
                }
                LOGGER.debug("Recaptcha verification response received: [{}]", (Object)result);
                JsonNode node = READER.readTree(result);
                if (node.has("score") && node.get("score").doubleValue() <= this.recaptchaProperties.getScore()) {
                    LOGGER.warn("Recaptcha score received is less than the threshold score defined for CAS");
                    boolean bl = false;
                    HttpUtils.close((HttpResponse)response);
                    return bl;
                }
                if (node.has("success") && node.get("success").booleanValue()) {
                    LOGGER.trace("Recaptcha has successfully verified the request");
                    boolean bl = true;
                    HttpUtils.close((HttpResponse)response);
                    return bl;
                }
            }
            HttpUtils.close((HttpResponse)response);
            return false;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return false;
        }
        finally {
            HttpUtils.close(response);
        }
    }

    @Generated
    public BaseCaptchaValidator(GoogleRecaptchaProperties recaptchaProperties) {
        this.recaptchaProperties = recaptchaProperties;
    }

    @Override
    @Generated
    public GoogleRecaptchaProperties getRecaptchaProperties() {
        return this.recaptchaProperties;
    }
}

