/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.response;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGeneratedResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.inspektr.audit.annotation.Audit;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public class OAuth20DefaultAccessTokenResponseGenerator
implements OAuth20AccessTokenResponseGenerator {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    protected final JwtBuilder accessTokenJwtBuilder;
    private final CasConfigurationProperties casProperties;

    private static boolean shouldGenerateDeviceFlowResponse(OAuth20AccessTokenResponseResult result) {
        OAuth20TokenGeneratedResult generatedToken = result.getGeneratedToken();
        return OAuth20ResponseTypes.DEVICE_CODE == result.getResponseType() && generatedToken.getDeviceCode().isPresent() && generatedToken.getUserCode().isPresent() && generatedToken.getAccessToken().isEmpty();
    }

    @Audit(action="OAUTH2_ACCESS_TOKEN_RESPONSE", actionResolverName="OAUTH2_ACCESS_TOKEN_RESPONSE_ACTION_RESOLVER", resourceResolverName="OAUTH2_ACCESS_TOKEN_RESPONSE_RESOURCE_RESOLVER")
    public ModelAndView generate(OAuth20AccessTokenResponseResult result) {
        if (OAuth20DefaultAccessTokenResponseGenerator.shouldGenerateDeviceFlowResponse(result)) {
            return this.generateResponseForDeviceToken(result);
        }
        return this.generateResponseForAccessToken(result);
    }

    protected ModelAndView generateResponseForDeviceToken(OAuth20AccessTokenResponseResult result) {
        Map model = this.getDeviceTokenResponseModel(result);
        return new ModelAndView((View)new MappingJackson2JsonView(MAPPER), model);
    }

    protected Map getDeviceTokenResponseModel(OAuth20AccessTokenResponseResult result) {
        LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
        String uri = result.getCasProperties().getServer().getPrefix().concat("/oauth2.0").concat("/").concat("device");
        model.put("verification_uri", uri);
        model.put("expires_in", result.getDeviceTokenTimeout());
        OAuth20TokenGeneratedResult generatedToken = result.getGeneratedToken();
        generatedToken.getUserCode().ifPresent(c -> model.put("user_code", c));
        generatedToken.getDeviceCode().ifPresent(c -> model.put("device_code", c));
        model.put("interval", result.getDeviceRefreshInterval());
        return model;
    }

    protected ModelAndView generateResponseForAccessToken(OAuth20AccessTokenResponseResult result) {
        Map<String, Object> model = this.getAccessTokenResponseModel(result);
        ModelAndView mv = new ModelAndView((View)new MappingJackson2JsonView(MAPPER), model);
        mv.setStatus(HttpStatus.OK);
        return mv;
    }

    protected Map<String, Object> getAccessTokenResponseModel(OAuth20AccessTokenResponseResult result) {
        LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
        OAuth20TokenGeneratedResult generatedToken = result.getGeneratedToken();
        generatedToken.getAccessToken().ifPresent(token -> {
            model.put("access_token", this.encodeAccessToken((OAuth20AccessToken)token, result));
            model.put("scope", String.join((CharSequence)" ", token.getScopes()));
            model.put("expires_in", token.getExpiresIn());
        });
        generatedToken.getRefreshToken().ifPresent(t -> model.put("refresh_token", t.getId()));
        model.put("token_type", "Bearer");
        generatedToken.getAccessToken().ifPresent(token -> {
            if (token.getAuthentication().containsAttribute("DPoPConfirmation")) {
                model.put("token_type", "DPoP");
            }
        });
        return model;
    }

    protected String encodeAccessToken(OAuth20AccessToken accessToken, OAuth20AccessTokenResponseResult result) {
        return ((OAuth20JwtAccessTokenEncoder)this.getAccessTokenBuilder(accessToken, result).build()).encode(accessToken.getIdToken(), new Object[]{accessToken, result});
    }

    protected OAuth20JwtAccessTokenEncoder.OAuth20JwtAccessTokenEncoderBuilder getAccessTokenBuilder(OAuth20AccessToken accessToken, OAuth20AccessTokenResponseResult result) {
        return ((OAuth20JwtAccessTokenEncoder.OAuth20JwtAccessTokenEncoderBuilder)((OAuth20JwtAccessTokenEncoder.OAuth20JwtAccessTokenEncoderBuilder)((OAuth20JwtAccessTokenEncoder.OAuth20JwtAccessTokenEncoderBuilder)((OAuth20JwtAccessTokenEncoder.OAuth20JwtAccessTokenEncoderBuilder)OAuth20JwtAccessTokenEncoder.builder().accessToken(accessToken)).registeredService(result.getRegisteredService())).service(result.getService())).accessTokenJwtBuilder(this.accessTokenJwtBuilder)).casProperties(this.casProperties);
    }

    @Generated
    public OAuth20DefaultAccessTokenResponseGenerator(JwtBuilder accessTokenJwtBuilder, CasConfigurationProperties casProperties) {
        this.accessTokenJwtBuilder = accessTokenJwtBuilder;
        this.casProperties = casProperties;
    }
}

