/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.configurator.deployer;

import java.util.Map;
import org.flowable.common.engine.api.repository.EngineDeployment;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.common.engine.impl.EngineDeployer;
import org.flowable.eventregistry.api.EventDeploymentBuilder;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDeployer
implements EngineDeployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventDeployer.class);

    public void deploy(EngineDeployment deployment, Map<String, Object> deploymentSettings) {
        if (!deployment.isNew()) {
            return;
        }
        LOGGER.debug("EventDeployer: processing deployment {}", (Object)deployment.getName());
        EventDeploymentBuilder eventDeploymentBuilder = null;
        Map resources = deployment.getResources();
        for (String resourceName : resources.keySet()) {
            EventRepositoryService eventRepositoryService;
            if (resourceName.endsWith(".event")) {
                LOGGER.info("EventDeployer: processing resource {}", (Object)resourceName);
                if (eventDeploymentBuilder == null) {
                    eventRepositoryService = CommandContextUtil.getEventRepositoryService();
                    eventDeploymentBuilder = eventRepositoryService.createDeployment().name(deployment.getName());
                }
                eventDeploymentBuilder.addEventDefinitionBytes(resourceName, ((EngineResource)resources.get(resourceName)).getBytes());
                continue;
            }
            if (!resourceName.endsWith(".channel")) continue;
            LOGGER.info("EventDeployer: processing resource {}", (Object)resourceName);
            if (eventDeploymentBuilder == null) {
                eventRepositoryService = CommandContextUtil.getEventRepositoryService();
                eventDeploymentBuilder = eventRepositoryService.createDeployment().name(deployment.getName());
            }
            eventDeploymentBuilder.addChannelDefinitionBytes(resourceName, ((EngineResource)resources.get(resourceName)).getBytes());
        }
        if (eventDeploymentBuilder != null) {
            eventDeploymentBuilder.parentDeploymentId(deployment.getId());
            if (deployment.getTenantId() != null && deployment.getTenantId().length() > 0) {
                eventDeploymentBuilder.tenantId(deployment.getTenantId());
            }
            eventDeploymentBuilder.deploy();
        }
    }
}

