/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.mapping;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.common.lib.to.OIDCRPClientAppTO;
import org.apache.syncope.common.lib.types.OIDCResponseType;
import org.apache.syncope.common.lib.types.OIDCScope;
import org.apache.syncope.common.lib.wa.WAClientApp;
import org.apache.syncope.wa.starter.mapping.AbstractClientAppMapper;
import org.apereo.cas.oidc.claims.OidcAddressScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcCustomScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcEmailScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcOpenIdScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcPhoneScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcProfileScopeAttributeReleasePolicy;
import org.apereo.cas.services.BaseMappedAttributeReleasePolicy;
import org.apereo.cas.services.BaseWebBasedRegisteredService;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAuthenticationPolicy;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.RegisteredServiceProxyGrantingTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceProxyTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceServiceTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceTicketGrantingTicketExpirationPolicy;
import org.apereo.cas.services.ReturnAllowedAttributeReleasePolicy;

public class OIDCRPClientAppTOMapper
extends AbstractClientAppMapper {
    private static final String CUSTOM_SCOPE = "syncope";

    @Override
    public boolean supports(ClientAppTO clientApp) {
        return OIDCRPClientAppTO.class.equals(clientApp.getClass());
    }

    @Override
    public RegisteredService map(WAClientApp clientApp, RegisteredServiceAuthenticationPolicy authPolicy, RegisteredServiceMultifactorPolicy mfaPolicy, RegisteredServiceAccessStrategy accessStrategy, RegisteredServiceAttributeReleasePolicy attributeReleasePolicy, RegisteredServiceTicketGrantingTicketExpirationPolicy tgtExpirationPolicy, RegisteredServiceServiceTicketExpirationPolicy stExpirationPolicy, RegisteredServiceProxyGrantingTicketExpirationPolicy tgtProxyExpirationPolicy, RegisteredServiceProxyTicketExpirationPolicy stProxyExpirationPolicy) {
        ChainingAttributeReleasePolicy chain;
        OIDCRPClientAppTO rp = (OIDCRPClientAppTO)OIDCRPClientAppTO.class.cast(clientApp.getClientAppTO());
        OidcRegisteredService service = new OidcRegisteredService();
        this.setCommon((BaseWebBasedRegisteredService)service, (ClientAppTO)rp);
        service.setServiceId(rp.getRedirectUris().stream().filter(Objects::nonNull).collect(Collectors.joining("|")));
        service.setClientId(rp.getClientId());
        service.setClientSecret(rp.getClientSecret());
        service.setSignIdToken(rp.isSignIdToken());
        if (!service.isSignIdToken()) {
            service.setIdTokenSigningAlg("none");
        }
        service.setJwtAccessToken(rp.isJwtAccessToken());
        service.setBypassApprovalPrompt(rp.isBypassApprovalPrompt());
        service.setSupportedGrantTypes(rp.getSupportedGrantTypes().stream().map(Enum::name).collect(Collectors.toSet()));
        service.setSupportedResponseTypes(rp.getSupportedResponseTypes().stream().map(OIDCResponseType::getExternalForm).collect(Collectors.toSet()));
        Optional.ofNullable(rp.getSubjectType()).ifPresent(st -> service.setSubjectType(st.name()));
        service.setLogoutUrl(rp.getLogoutUri());
        service.setScopes(rp.getScopes().stream().map(Enum::name).collect(Collectors.toSet()));
        if (attributeReleasePolicy instanceof ChainingAttributeReleasePolicy) {
            chain = (ChainingAttributeReleasePolicy)attributeReleasePolicy;
        } else {
            chain = new ChainingAttributeReleasePolicy();
            Optional.ofNullable(attributeReleasePolicy).ifPresent(xva$0 -> chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{xva$0}));
        }
        if (rp.getScopes().contains(OIDCScope.openid)) {
            chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{new OidcOpenIdScopeAttributeReleasePolicy()});
        }
        if (rp.getScopes().contains(OIDCScope.profile)) {
            chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{new OidcProfileScopeAttributeReleasePolicy()});
        }
        if (rp.getScopes().contains(OIDCScope.address)) {
            chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{new OidcAddressScopeAttributeReleasePolicy()});
        }
        if (rp.getScopes().contains(OIDCScope.email)) {
            chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{new OidcEmailScopeAttributeReleasePolicy()});
        }
        if (rp.getScopes().contains(OIDCScope.phone)) {
            chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{new OidcPhoneScopeAttributeReleasePolicy()});
        }
        HashSet customClaims = new HashSet();
        if (attributeReleasePolicy instanceof BaseMappedAttributeReleasePolicy) {
            customClaims.addAll(((BaseMappedAttributeReleasePolicy)attributeReleasePolicy).getAllowedAttributes().values().stream().map(Objects::toString).collect(Collectors.toSet()));
        } else if (attributeReleasePolicy instanceof ReturnAllowedAttributeReleasePolicy) {
            customClaims.addAll(((ReturnAllowedAttributeReleasePolicy)attributeReleasePolicy).getAllowedAttributes().stream().collect(Collectors.toSet()));
        } else if (attributeReleasePolicy instanceof ChainingAttributeReleasePolicy) {
            ((ChainingAttributeReleasePolicy)attributeReleasePolicy).getPolicies().stream().filter(ReturnAllowedAttributeReleasePolicy.class::isInstance).findFirst().map(ReturnAllowedAttributeReleasePolicy.class::cast).map(p -> p.getAllowedAttributes().stream().collect(Collectors.toSet())).ifPresent(customClaims::addAll);
        }
        if (rp.getScopes().contains(OIDCScope.profile)) {
            customClaims.removeAll(OidcProfileScopeAttributeReleasePolicy.ALLOWED_CLAIMS);
        }
        if (rp.getScopes().contains(OIDCScope.address)) {
            customClaims.removeAll(OidcAddressScopeAttributeReleasePolicy.ALLOWED_CLAIMS);
        }
        if (rp.getScopes().contains(OIDCScope.email)) {
            customClaims.removeAll(OidcEmailScopeAttributeReleasePolicy.ALLOWED_CLAIMS);
        }
        if (rp.getScopes().contains(OIDCScope.phone)) {
            customClaims.removeAll(OidcPhoneScopeAttributeReleasePolicy.ALLOWED_CLAIMS);
        }
        if (!customClaims.isEmpty()) {
            service.getScopes().add(CUSTOM_SCOPE);
            chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{new OidcCustomScopeAttributeReleasePolicy(CUSTOM_SCOPE, customClaims.stream().collect(Collectors.toList()))});
        }
        this.setPolicies((BaseWebBasedRegisteredService)service, authPolicy, mfaPolicy, accessStrategy, (RegisteredServiceAttributeReleasePolicy)chain, tgtExpirationPolicy, stExpirationPolicy, tgtProxyExpirationPolicy, stProxyExpirationPolicy);
        return service;
    }
}

