/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.tasks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AjaxDataTablePanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.ExecutionRestClient;
import org.apache.syncope.client.console.tasks.ExecMessage;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.DirectoryDataProvider;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public abstract class ExecutionsDirectoryPanel
extends DirectoryPanel<ExecTO, ExecTO, ExecProvider, ExecutionRestClient> {
    private static final long serialVersionUID = 2039393934721149162L;
    protected final MultilevelPanel multiLevelPanelRef;
    protected final String key;

    public ExecutionsDirectoryPanel(MultilevelPanel multiLevelPanelRef, String key, ExecutionRestClient executionRestClient, PageReference pageRef) {
        super("first", executionRestClient, pageRef, false);
        this.multiLevelPanelRef = multiLevelPanelRef;
        this.setOutputMarkupId(true);
        this.key = key;
        this.initResultTable();
    }

    @Override
    protected void resultTableCustomChanges(AjaxDataTablePanel.Builder<ExecTO, String> resultTableBuilder) {
        resultTableBuilder.setMultiLevelPanel(this.multiLevelPanelRef);
    }

    protected abstract void next(String var1, MultilevelPanel.SecondLevel var2, AjaxRequestTarget var3);

    @Override
    protected List<IColumn<ExecTO, String>> getColumns() {
        ArrayList<IColumn<ExecTO, String>> columns = new ArrayList<IColumn<ExecTO, String>>();
        columns.add((IColumn<ExecTO, String>)new KeyPropertyColumn((IModel<String>)new StringResourceModel("key", (Component)this), "key", "key"));
        columns.add((IColumn<ExecTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("start", (Component)this), "start", "start"));
        columns.add((IColumn<ExecTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("end", (Component)this), "end", "end"));
        columns.add((IColumn<ExecTO, String>)new PropertyColumn((IModel)new StringResourceModel("status", (Component)this), (Object)"status", "status"));
        columns.add((IColumn<ExecTO, String>)new PropertyColumn((IModel)new StringResourceModel("executor", (Component)this), (Object)"executor", "executor"));
        return columns;
    }

    @Override
    public ActionsPanel<ExecTO> getActions(final IModel<ExecTO> model) {
        ActionsPanel<ExecTO> panel = super.getActions(model);
        panel.add(new ActionLink<ExecTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, ExecTO ignore) {
                ExecutionsDirectoryPanel.this.getTogglePanel().close(target);
                ExecutionsDirectoryPanel.this.next((String)new StringResourceModel("execution.view", (Component)ExecutionsDirectoryPanel.this, model).getObject(), new ExecMessage(((ExecTO)model.getObject()).getMessage()), target);
            }
        }, ActionLink.ActionType.VIEW, "TASK_READ");
        panel.add(new ActionLink<ExecTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, ExecTO ignore) {
                ExecutionsDirectoryPanel.this.getTogglePanel().close(target);
                try {
                    ((ExecutionRestClient)ExecutionsDirectoryPanel.this.restClient).deleteExecution(((ExecTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)ExecutionsDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{ExecutionsDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)ExecutionsDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "TASK_DELETE", true);
        this.addFurtherActions(panel, model);
        return panel;
    }

    protected void addFurtherActions(ActionsPanel<ExecTO> panel, IModel<ExecTO> model) {
    }

    @Override
    protected ExecProvider dataProvider() {
        return new ExecProvider(this.key, this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "task.execs.paginator.rows";
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        ArrayList<ActionLink.ActionType> batches = new ArrayList<ActionLink.ActionType>();
        batches.add(ActionLink.ActionType.DELETE);
        return batches;
    }

    protected class ExecProvider
    extends DirectoryDataProvider<ExecTO> {
        private static final long serialVersionUID = 8943636537120648961L;
        private final String taskKey;

        public ExecProvider(String taskKey, int paginatorRows) {
            super(paginatorRows);
            this.taskKey = taskKey;
            this.setSort("end", SortOrder.DESCENDING);
        }

        public Iterator<ExecTO> iterator(long first, long count) {
            int page = (int)first / this.paginatorRows;
            return ((ExecutionRestClient)ExecutionsDirectoryPanel.this.restClient).listExecutions(this.taskKey, (page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)this.getSort()).iterator();
        }

        public long size() {
            return ((ExecutionRestClient)ExecutionsDirectoryPanel.this.restClient).countExecutions(this.taskKey);
        }

        public IModel<ExecTO> model(final ExecTO taskExecution) {
            return new IModel<ExecTO>(){
                private static final long serialVersionUID = 7485475149862342421L;

                public ExecTO getObject() {
                    return taskExecution;
                }
            };
        }
    }
}

