/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.tasks;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.panels.BeanPanel;
import org.apache.syncope.client.console.rest.CommandRestClient;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.rest.TaskRestClient;
import org.apache.syncope.client.console.tasks.CommandWrapper;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.common.lib.command.CommandTO;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.to.MacroTaskTO;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;

public class CommandComposeWizardBuilder
extends BaseAjaxWizardBuilder<CommandWrapper> {
    private static final long serialVersionUID = -2300926041782845851L;
    protected final LoadableDetachableModel<List<ImplementationTO>> commands = new LoadableDetachableModel<List<ImplementationTO>>(){
        private static final long serialVersionUID = 4659376149825914247L;

        protected List<ImplementationTO> load() {
            return CommandComposeWizardBuilder.this.implementationRestClient.list("COMMAND");
        }
    };
    protected final String task;
    protected final ImplementationRestClient implementationRestClient;
    protected final TaskRestClient taskRestClient;
    protected final CommandRestClient commandRestClient;

    public CommandComposeWizardBuilder(String task, CommandWrapper defaultItem, ImplementationRestClient implementationRestClient, TaskRestClient taskRestClient, CommandRestClient commandRestClient, PageReference pageRef) {
        super(defaultItem, pageRef);
        this.task = task;
        this.implementationRestClient = implementationRestClient;
        this.taskRestClient = taskRestClient;
        this.commandRestClient = commandRestClient;
    }

    protected Serializable onApplyInternal(CommandWrapper modelObject) {
        MacroTaskTO taskTO = (MacroTaskTO)this.taskRestClient.readTask(TaskType.MACRO, this.task);
        if (modelObject.isNew()) {
            taskTO.getCommands().add(modelObject.getCommand());
        } else {
            taskTO.getCommands().stream().filter(cmd -> cmd.getKey().equals(modelObject.getCommand().getKey())).findFirst().ifPresent(cmd -> cmd.setArgs(modelObject.getCommand().getArgs()));
        }
        this.taskRestClient.update(TaskType.MACRO, (SchedTaskTO)taskTO);
        return modelObject;
    }

    protected WizardModel buildModelSteps(CommandWrapper modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Profile(modelObject));
        wizardModel.add((IWizardStep)new CommandArgs(modelObject));
        return wizardModel;
    }

    public class CommandArgs
    extends WizardStep {
        private static final long serialVersionUID = -785981096328637758L;

        public CommandArgs(final CommandWrapper command) {
            LoadableDetachableModel<Serializable> bean = new LoadableDetachableModel<Serializable>(){
                private static final long serialVersionUID = 2092144708018739371L;

                protected Serializable load() {
                    return command.getCommand().getArgs();
                }
            };
            this.add(new Component[]{new BeanPanel("bean", bean, CommandComposeWizardBuilder.this.pageRef, new String[0]).setRenderBodyOnly(true)});
        }
    }

    public class Profile
    extends WizardStep {
        private static final long serialVersionUID = -3043839139187792810L;
        private final CommandWrapper command;

        public Profile(final CommandWrapper command) {
            this.command = command;
            final MacroTaskTO taskTO = (MacroTaskTO)CommandComposeWizardBuilder.this.taskRestClient.readTask(TaskType.MACRO, CommandComposeWizardBuilder.this.task);
            AutoCompleteSettings settings = new AutoCompleteSettings();
            settings.setShowCompleteListOnFocusGain(false);
            settings.setShowListOnEmptyInput(false);
            AutoCompleteTextField<String> args = new AutoCompleteTextField<String>("command", (IModel)new PropertyModel((Object)command, "command.key"), settings){
                private static final long serialVersionUID = -6556576139048844857L;

                protected Iterator<String> getChoices(String input) {
                    return ((List)CommandComposeWizardBuilder.this.commands.getObject()).stream().map(ImplementationTO::getKey).filter(cmd -> cmd.contains(input) && taskTO.getCommands().stream().noneMatch(c -> c.getKey().equals(cmd))).sorted().iterator();
                }
            };
            args.setRequired(true);
            args.setEnabled(command.isNew());
            args.add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -6139318907146065915L;

                protected void onUpdate(AjaxRequestTarget target) {
                    CommandTO cmd = CommandComposeWizardBuilder.this.commandRestClient.read(command.getCommand().getKey());
                    command.getCommand().setArgs(cmd.getArgs());
                }
            }});
            this.add(new Component[]{args});
        }

        public void applyState() {
            ((List)CommandComposeWizardBuilder.this.commands.getObject()).stream().filter(cmd -> cmd.getKey().equals(this.command.getCommand().getKey()) && cmd.getEngine() == ImplementationEngine.GROOVY).findFirst().ifPresent(cmd -> this.getWizardModel().finish());
        }
    }
}

