/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.tasks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.CommandRestClient;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.rest.TaskRestClient;
import org.apache.syncope.client.console.tasks.CommandComposeWizardBuilder;
import org.apache.syncope.client.console.tasks.CommandWrapper;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.ui.commons.DirectoryDataProvider;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.command.CommandTO;
import org.apache.syncope.common.lib.to.MacroTaskTO;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class CommandComposeDirectoryPanel
extends DirectoryPanel<CommandWrapper, CommandWrapper, DirectoryDataProvider<CommandWrapper>, CommandRestClient>
implements ModalPanel {
    private static final long serialVersionUID = 8899580817658145305L;
    @SpringBean
    protected ImplementationRestClient implementationRestClient;
    @SpringBean
    protected TaskRestClient taskRestClient;
    @SpringBean
    protected CommandRestClient commandRestClient;
    protected final BaseModal<MacroTaskTO> baseModal;
    protected final String task;

    public CommandComposeDirectoryPanel(CommandRestClient restClient, BaseModal<MacroTaskTO> baseModal, String task, PageReference pageRef) {
        super("content", restClient, pageRef, false);
        this.disableCheckBoxes();
        this.baseModal = baseModal;
        this.task = task;
        this.enableUtilityButton();
        this.addNewItemPanelBuilder(new CommandComposeWizardBuilder(task, new CommandWrapper(true), this.implementationRestClient, this.taskRestClient, this.commandRestClient, pageRef), true);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"TASK_UPDATE");
        this.initResultTable();
    }

    @Override
    protected List<IColumn<CommandWrapper, String>> getColumns() {
        ArrayList<IColumn<CommandWrapper, String>> columns = new ArrayList<IColumn<CommandWrapper, String>>();
        columns.add((IColumn<CommandWrapper, String>)new AbstractColumn<CommandWrapper, String>((IModel)new ResourceModel("key"), "key"){
            private static final long serialVersionUID = -4008579357070833846L;

            public void populateItem(Item<ICellPopulator<CommandWrapper>> cellItem, String componentId, IModel<CommandWrapper> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)((CommandWrapper)rowModel.getObject()).getCommand().getKey()))});
            }
        });
        columns.add((IColumn<CommandWrapper, String>)new AbstractColumn<CommandWrapper, String>((IModel)new ResourceModel("arguments"), "arguments"){
            private static final long serialVersionUID = -4008579357070833846L;

            public void populateItem(Item<ICellPopulator<CommandWrapper>> cellItem, String componentId, IModel<CommandWrapper> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)((CommandWrapper)rowModel.getObject()).getCommand().getArgs().getClass().getName()))});
            }
        });
        return columns;
    }

    @Override
    public ActionsPanel<CommandWrapper> getActions(final IModel<CommandWrapper> model) {
        ActionsPanel<CommandWrapper> panel = super.getActions(model);
        panel.add(new ActionLink<CommandWrapper>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, CommandWrapper ignore) {
                CommandComposeDirectoryPanel.this.getTogglePanel().close(target);
                CommandComposeDirectoryPanel.this.send((IEventSink)CommandComposeDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)((CommandWrapper)model.getObject()), target));
            }
        }, ActionLink.ActionType.EDIT, "TASK_UPDATE");
        panel.add(new ActionLink<CommandWrapper>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, CommandWrapper ignore) {
                try {
                    MacroTaskTO actual = (MacroTaskTO)CommandComposeDirectoryPanel.this.taskRestClient.readTask(TaskType.MACRO, CommandComposeDirectoryPanel.this.task);
                    actual.getCommands().remove(((CommandWrapper)model.getObject()).getCommand());
                    CommandComposeDirectoryPanel.this.taskRestClient.update(TaskType.MACRO, (SchedTaskTO)actual);
                    SyncopeConsoleSession.get().success((Serializable)((Object)CommandComposeDirectoryPanel.this.getString("operation_succeeded")));
                    CommandComposeDirectoryPanel.this.customActionOnFinishCallback(target);
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting {}", model.getObject(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BaseWebPage)CommandComposeDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "TASK_UPDATE");
        return panel;
    }

    @Override
    public ActionsPanel<Serializable> getHeader(String componentId) {
        ActionsPanel<Serializable> panel = new ActionsPanel<Serializable>(componentId, null);
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                if (target != null) {
                    CommandComposeDirectoryPanel.this.customActionOnFinishCallback(target);
                }
            }
        }, ActionLink.ActionType.RELOAD, "TASK_READ").hideLabel();
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    @Override
    protected CommandComposeDataProvider dataProvider() {
        return new CommandComposeDataProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "command.paginator.rows";
    }

    @Override
    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof WizardMgtPanel.ExitEvent) {
            AjaxRequestTarget target = ((WizardMgtPanel.ExitEvent)WizardMgtPanel.ExitEvent.class.cast(event.getPayload())).getTarget();
            this.baseModal.show(false);
            this.baseModal.close((IPartialPageRequestHandler)target);
        }
    }

    protected class CommandComposeDataProvider
    extends DirectoryDataProvider<CommandWrapper> {
        private static final long serialVersionUID = 4725679400450513556L;

        public CommandComposeDataProvider(int paginatorRows) {
            super(paginatorRows);
        }

        public Iterator<CommandWrapper> iterator(long first, long count) {
            MacroTaskTO actual = (MacroTaskTO)CommandComposeDirectoryPanel.this.taskRestClient.readTask(TaskType.MACRO, CommandComposeDirectoryPanel.this.task);
            List commands = actual.getCommands();
            return commands.subList((int)first, (int)(first + count)).stream().map(command -> new CommandWrapper(false).setCommand((CommandTO)command)).iterator();
        }

        public long size() {
            MacroTaskTO actual = (MacroTaskTO)CommandComposeDirectoryPanel.this.taskRestClient.readTask(TaskType.MACRO, CommandComposeDirectoryPanel.this.task);
            return actual.getCommands().size();
        }

        public IModel<CommandWrapper> model(CommandWrapper object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

