/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.search.AbstractSearchPanel;
import org.apache.syncope.client.console.panels.search.FIQLQueries;
import org.apache.syncope.client.console.rest.FIQLQueryRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.DirectoryDataProvider;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.FIQLQueryTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;

public class FIQLQueryDirectoryPanel
extends DirectoryPanel<FIQLQueryTO, FIQLQueryTO, DirectoryDataProvider<FIQLQueryTO>, FIQLQueryRestClient> {
    private static final long serialVersionUID = -913956855318099854L;
    private final AbstractSearchPanel searchPanel;
    private final String target;
    private final FIQLQueries parent;

    public FIQLQueryDirectoryPanel(String id, FIQLQueryRestClient restClient, AbstractSearchPanel searchPanel, String target, FIQLQueries parent, PageReference pageRef) {
        super(id, restClient, pageRef, false);
        this.target = target;
        this.searchPanel = searchPanel;
        this.parent = parent;
        this.disableCheckBoxes();
        this.initResultTable();
    }

    @Override
    protected List<IColumn<FIQLQueryTO, String>> getColumns() {
        ArrayList<IColumn<FIQLQueryTO, String>> columns = new ArrayList<IColumn<FIQLQueryTO, String>>();
        columns.add((IColumn<FIQLQueryTO, String>)new KeyPropertyColumn((IModel<String>)new StringResourceModel("key", (Component)this), "key"));
        columns.add((IColumn<FIQLQueryTO, String>)new PropertyColumn((IModel)new StringResourceModel("name", (Component)this), (Object)"name", "name"));
        columns.add((IColumn<FIQLQueryTO, String>)new PropertyColumn((IModel)Model.of((Serializable)((Object)"FIQL")), "fiql"));
        return columns;
    }

    @Override
    protected ActionsPanel<FIQLQueryTO> getActions(final IModel<FIQLQueryTO> model) {
        ActionsPanel<FIQLQueryTO> panel = super.getActions(model);
        panel.add(new ActionLink<FIQLQueryTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, FIQLQueryTO ignore) {
                FIQLQueryDirectoryPanel.this.searchPanel.updateFIQL(target, ((FIQLQueryTO)model.getObject()).getFiql());
                FIQLQueryDirectoryPanel.this.parent.close(target);
            }
        }, ActionLink.ActionType.SELECT, "");
        panel.add(new ActionLink<FIQLQueryTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, FIQLQueryTO ignore) {
                try {
                    ((FIQLQueryRestClient)FIQLQueryDirectoryPanel.this.restClient).delete(((FIQLQueryTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)FIQLQueryDirectoryPanel.this.getString("operation_succeeded")));
                    FIQLQueryDirectoryPanel.this.customActionOnFinishCallback(target);
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting {}", (Object)((FIQLQueryTO)model.getObject()).getName(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BaseWebPage)FIQLQueryDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "");
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return Set.of();
    }

    @Override
    protected DirectoryDataProvider<FIQLQueryTO> dataProvider() {
        return new FIQLQueryDataProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "fiql.queries.paginator.rows";
    }

    protected class FIQLQueryDataProvider
    extends DirectoryDataProvider<FIQLQueryTO> {
        private static final long serialVersionUID = 4725679400450513556L;
        protected final SortableDataProviderComparator<FIQLQueryTO> comparator;

        public FIQLQueryDataProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("name", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator(this);
        }

        public Iterator<FIQLQueryTO> iterator(long first, long count) {
            List<FIQLQueryTO> list = ((FIQLQueryRestClient)FIQLQueryDirectoryPanel.this.restClient).list(FIQLQueryDirectoryPanel.this.target);
            list.sort(this.comparator);
            return list.subList((int)first, (int)(first + count)).iterator();
        }

        public long size() {
            return ((FIQLQueryRestClient)FIQLQueryDirectoryPanel.this.restClient).list(FIQLQueryDirectoryPanel.this.target).size();
        }

        public IModel<FIQLQueryTO> model(FIQLQueryTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

