/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonList;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown.DropDownAlignmentBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown.DropDownButton;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome5IconType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.commons.RealmsUtils;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.wicket.markup.html.WebMarkupContainerNoVeil;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.common.lib.to.DynRealmTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.rest.api.beans.RealmQuery;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AbstractAutoCompleteRenderer;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteBehavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.Response;

public class RealmChoicePanel
extends Panel {
    private static final long serialVersionUID = -1100228004207271270L;
    protected static final String SEARCH_REALMS = "searchRealms";
    protected final RealmRestClient realmRestClient;
    protected final PageReference pageRef;
    protected final LoadableDetachableModel<List<Pair<String, RealmTO>>> realmTree;
    protected final LoadableDetachableModel<List<DynRealmTO>> dynRealmTree;
    protected final WebMarkupContainerNoVeil container;
    protected Model<RealmTO> model;
    protected final Map<String, Pair<RealmTO, List<RealmTO>>> tree;
    protected final List<AbstractLink> links = new ArrayList<AbstractLink>();
    protected String searchQuery;
    protected List<RealmTO> realmsChoices;
    protected final boolean fullRealmsTree;
    protected final ListView<String> breadcrumb;

    public RealmChoicePanel(String id, String base, final RealmRestClient realmRestClient, PageReference pageRef) {
        super(id);
        this.realmRestClient = realmRestClient;
        this.pageRef = pageRef;
        this.tree = new HashMap<String, Pair<RealmTO, List<RealmTO>>>();
        this.fullRealmsTree = SyncopeWebApplication.get().fullRealmsTree(realmRestClient);
        this.realmTree = new LoadableDetachableModel<List<Pair<String, RealmTO>>>(){
            private static final long serialVersionUID = -7688359318035249200L;

            protected List<Pair<String, RealmTO>> load() {
                Map<String, Pair<RealmTO, List<RealmTO>>> map = RealmChoicePanel.this.reloadRealmParentMap();
                Stream<Pair> full = RealmChoicePanel.this.fullRealmsTree ? map.entrySet().stream().map(el -> Pair.of((Object)((RealmTO)((Pair)el.getValue()).getLeft()).getFullPath(), (Object)((RealmTO)((Pair)el.getValue()).getKey()))).sorted(Comparator.comparing(Pair::getLeft)) : map.entrySet().stream().map(el -> Pair.of((Object)((String)el.getKey()), (Object)((RealmTO)((Pair)el.getValue()).getLeft())));
                return full.filter(realm -> SyncopeConsoleSession.get().getSearchableRealms().stream().anyMatch(r -> ((RealmTO)realm.getValue()).getFullPath().startsWith((String)r))).collect(Collectors.toList());
            }
        };
        this.dynRealmTree = new LoadableDetachableModel<List<DynRealmTO>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<DynRealmTO> load() {
                List<DynRealmTO> dynRealms = realmRestClient.listDynRealms();
                dynRealms.sort((left, right) -> {
                    if (left == null) {
                        return -1;
                    }
                    if (right == null) {
                        return 1;
                    }
                    return left.getKey().compareTo(right.getKey());
                });
                return dynRealms.stream().filter(dynRealm -> SyncopeConsoleSession.get().getSearchableRealms().stream().anyMatch(availableRealm -> "/".equals(availableRealm) || dynRealm.getKey().equals(availableRealm))).collect(Collectors.toList());
            }
        };
        RealmTO realm = SyncopeConsoleSession.get().getRootRealm(base).map(rootRealm -> {
            String rootRealmName = StringUtils.substringAfterLast((String)rootRealm, (String)"/");
            List realmTOs = realmRestClient.search(RealmsUtils.buildKeywordQuery("/".equals(rootRealm) ? "/" : rootRealmName)).getResult();
            return realmTOs.stream().filter(r -> rootRealm.equals(r.getFullPath())).findFirst().orElseGet(() -> {
                RealmTO placeholder = new RealmTO();
                placeholder.setName(rootRealmName);
                placeholder.setFullPath(rootRealm);
                return placeholder;
            });
        }).orElseGet(() -> {
            RealmTO root = new RealmTO();
            root.setName("/");
            root.setFullPath("/");
            return root;
        });
        this.model = Model.of((Serializable)realm);
        this.searchQuery = realm.getName();
        this.container = new WebMarkupContainerNoVeil("container", (IModel<?>)this.realmTree);
        this.add(new Component[]{this.container.setOutputMarkupId(true)});
        this.breadcrumb = new ListView<String>("breadcrumb"){
            private static final long serialVersionUID = -8746795666847966508L;

            protected void populateItem(final ListItem<String> item) {
                AjaxLink<Void> bcitem = new AjaxLink<Void>("bcitem"){
                    private static final long serialVersionUID = -817438685948164787L;

                    public void onClick(AjaxRequestTarget target) {
                        realmRestClient.search((RealmQuery)new RealmQuery.Builder().base((String)item.getModelObject()).build()).getResult().stream().findFirst().ifPresent(t -> RealmChoicePanel.this.chooseRealm((RealmTO)t, target));
                    }
                };
                bcitem.setBody((IModel)Model.of((Serializable)((Object)("/".equals(item.getModelObject()) ? "/" : StringUtils.substringAfterLast((String)((String)item.getModelObject()), (String)"/")))));
                bcitem.setEnabled(!((RealmTO)RealmChoicePanel.this.model.getObject()).getFullPath().equals(item.getModelObject()));
                item.add(new Component[]{bcitem});
            }
        };
        this.container.addOrReplace(new Component[]{this.breadcrumb.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true)});
        this.setBreadcrumb((RealmTO)this.model.getObject());
        this.reloadRealmsTree();
    }

    protected void setBreadcrumb(RealmTO realm) {
        if ("/".equals(realm.getFullPath())) {
            this.breadcrumb.setList(List.of(realm.getFullPath()));
        } else {
            HashSet<String> bcitems = new HashSet<String>();
            bcitems.add("/");
            String[] split = realm.getFullPath().split("/");
            for (int i = 1; i < split.length; ++i) {
                StringBuilder bcitem = new StringBuilder();
                for (int j = 1; j <= i; ++j) {
                    bcitem.append('/').append(split[j]);
                }
                bcitems.add(bcitem.toString());
            }
            this.breadcrumb.setList(bcitems.stream().sorted().collect(Collectors.toList()));
        }
    }

    protected void chooseRealm(RealmTO realm, AjaxRequestTarget target) {
        this.model.setObject((Serializable)realm);
        this.setBreadcrumb(realm);
        target.add(new Component[]{this.container});
        this.send((IEventSink)this.pageRef.getPage(), Broadcast.EXACT, new ChosenRealm<RealmTO>(realm, target));
    }

    public void reloadRealmsTree() {
        if (this.fullRealmsTree) {
            DropDownButton realms = new DropDownButton("realms", (IModel)new ResourceModel("select", ""), (IModel)new Model((Serializable)FontAwesome5IconType.folder_open_r)){
                private static final long serialVersionUID = -5560086780455361131L;

                protected List<AbstractLink> newSubMenuButtons(String buttonMarkupId) {
                    RealmChoicePanel.this.buildRealmLinks();
                    return RealmChoicePanel.this.links;
                }
            };
            realms.setOutputMarkupId(true);
            realms.setAlignment(DropDownAlignmentBehavior.Alignment.RIGHT);
            realms.setType(Buttons.Type.Menu);
            MetaDataRoleAuthorizationStrategy.authorize((Component)realms, (Action)ENABLE, (String)"REALM_SEARCH");
            Fragment fragment = new Fragment("realmsFragment", "realmsListFragment", (MarkupContainer)this.container);
            fragment.addOrReplace(new Component[]{realms});
            this.container.addOrReplace(new Component[]{fragment});
        } else {
            this.realmsChoices = this.buildRealmChoices();
            AutoCompleteSettings settings = new AutoCompleteSettings();
            settings.setShowCompleteListOnFocusGain(false);
            settings.setShowListOnEmptyInput(false);
            AutoCompleteTextField<String> searchRealms = new AutoCompleteTextField<String>(SEARCH_REALMS, (IModel)new Model(), settings){
                private static final long serialVersionUID = -6635259975264955783L;

                protected Iterator<String> getChoices(String input) {
                    RealmChoicePanel.this.searchQuery = input;
                    RealmChoicePanel.this.realmsChoices = RealmsUtils.checkInput(input) ? RealmChoicePanel.this.buildRealmChoices() : List.of();
                    return RealmChoicePanel.this.realmsChoices.stream().map(RealmTO::getFullPath).sorted().iterator();
                }

                protected AutoCompleteBehavior<String> newAutoCompleteBehavior(IAutoCompleteRenderer<String> renderer, AutoCompleteSettings settings) {
                    return super.newAutoCompleteBehavior((IAutoCompleteRenderer)new AbstractAutoCompleteRenderer<String>(){
                        private static final long serialVersionUID = -4789925973199139157L;

                        protected void renderChoice(String object, Response response, String criteria) {
                            response.write((CharSequence)object);
                        }

                        protected String getTextValue(String object) {
                            return object;
                        }
                    }, settings);
                }
            };
            searchRealms.add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change", (AutoCompleteTextField)searchRealms){
                private static final long serialVersionUID = -6139318907146065915L;
                final /* synthetic */ AutoCompleteTextField val$searchRealms;
                {
                    this.val$searchRealms = autoCompleteTextField;
                    super(event);
                }

                protected void onUpdate(AjaxRequestTarget target) {
                    RealmChoicePanel.this.realmsChoices.stream().filter(item -> item.getFullPath().equals(this.val$searchRealms.getModelObject())).findFirst().ifPresent(realm -> RealmChoicePanel.this.chooseRealm((RealmTO)realm, target));
                }
            }});
            Fragment fragment = new Fragment("realmsFragment", "realmsSearchFragment", (MarkupContainer)this.container);
            fragment.addOrReplace(new Component[]{searchRealms});
            this.container.addOrReplace(new Component[]{fragment});
        }
    }

    protected void buildRealmLinks() {
        this.links.clear();
        this.links.add((AbstractLink)new BootstrapAjaxLink<Serializable>(ButtonList.getButtonMarkupId(), (IModel)new Model(), Buttons.Type.Link, (IModel)new ResourceModel("realms", "Realms")){
            private static final long serialVersionUID = -7978723352517770744L;

            public void onClick(AjaxRequestTarget target) {
            }

            public boolean isEnabled() {
                return false;
            }

            protected void onComponentTag(ComponentTag tag) {
                tag.put("class", (CharSequence)"dropdown-header disabled");
            }
        });
        ((List)this.realmTree.getObject()).forEach(link -> this.links.add((AbstractLink)new BootstrapAjaxLink<RealmTO>(ButtonList.getButtonMarkupId(), (IModel)Model.of((Serializable)((RealmTO)link.getRight())), Buttons.Type.Link, (IModel)new Model((Serializable)((Object)((String)link.getLeft())))){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                RealmChoicePanel.this.chooseRealm((RealmTO)link.getRight(), target);
            }
        }));
        if (!((List)this.dynRealmTree.getObject()).isEmpty()) {
            this.links.add((AbstractLink)new BootstrapAjaxLink<Serializable>(ButtonList.getButtonMarkupId(), (IModel)new Model(), Buttons.Type.Link, (IModel)new ResourceModel("dynrealms", "Dynamic Realms")){
                private static final long serialVersionUID = -7978723352517770744L;

                public void onClick(AjaxRequestTarget target) {
                }

                public boolean isEnabled() {
                    return false;
                }

                protected void onComponentTag(ComponentTag tag) {
                    tag.put("class", (CharSequence)"dropdown-header disabled");
                }
            });
            ((List)this.dynRealmTree.getObject()).forEach(dynRealmTO -> {
                final RealmTO realm = new RealmTO();
                realm.setKey(dynRealmTO.getKey());
                realm.setName(dynRealmTO.getKey());
                realm.setFullPath(dynRealmTO.getKey());
                this.links.add((AbstractLink)new BootstrapAjaxLink<Serializable>(ButtonList.getButtonMarkupId(), (IModel)new Model(), Buttons.Type.Link, (IModel)new Model((Serializable)((Object)realm.getKey()))){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        RealmChoicePanel.this.chooseRealm(realm, target);
                    }
                });
            });
        }
    }

    protected List<RealmTO> buildRealmChoices() {
        return Stream.of(((List)this.realmTree.getObject()).stream().map(Pair::getValue).collect(Collectors.toList()), ((List)this.dynRealmTree.getObject()).stream().map(item -> {
            RealmTO realm = new RealmTO();
            realm.setKey(item.getKey());
            realm.setName(item.getKey());
            realm.setFullPath(item.getKey());
            return realm;
        }).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public final RealmChoicePanel reloadRealmTree(AjaxRequestTarget target) {
        this.reloadRealmsTree();
        this.chooseRealm((RealmTO)this.model.getObject(), target);
        target.add(new Component[]{this.container});
        return this;
    }

    public final RealmChoicePanel reloadRealmTree(AjaxRequestTarget target, Model<RealmTO> newModel) {
        this.model = newModel;
        this.reloadRealmTree(target);
        return this;
    }

    protected Map<String, Pair<RealmTO, List<RealmTO>>> reloadRealmParentMap() {
        List realmsToList = this.realmRestClient.search(this.fullRealmsTree ? RealmsUtils.buildRootQuery() : RealmsUtils.buildKeywordQuery(this.searchQuery)).getResult();
        return this.reloadRealmParentMap(realmsToList.stream().sorted(Comparator.comparing(RealmTO::getName)).collect(Collectors.toList()));
    }

    protected Map<String, Pair<RealmTO, List<RealmTO>>> reloadRealmParentMap(List<RealmTO> realms) {
        this.tree.clear();
        HashMap cache = new HashMap();
        realms.forEach(realm -> {
            ArrayList children = new ArrayList();
            this.tree.put(realm.getKey(), (Pair<RealmTO, List<RealmTO>>)Pair.of((Object)realm, children));
            if (cache.containsKey(realm.getKey())) {
                children.addAll((Collection)cache.get(realm.getKey()));
                cache.remove(realm.getKey());
            }
            if (this.tree.containsKey(realm.getParent())) {
                ((List)this.tree.get(realm.getParent()).getRight()).add(realm);
            } else if (cache.containsKey(realm.getParent())) {
                ((List)cache.get(realm.getParent())).add(realm);
            } else {
                cache.put(realm.getParent(), Stream.of(realm).collect(Collectors.toList()));
            }
        });
        return this.tree;
    }

    public RealmTO getCurrentRealm() {
        return (RealmTO)this.model.getObject();
    }

    public void setCurrentRealm(RealmTO realmTO) {
        this.model.setObject((Serializable)realmTO);
    }

    public RealmTO moveToParentRealm(String key) {
        for (Pair<RealmTO, List<RealmTO>> subtree : this.tree.values()) {
            for (RealmTO child : (List)subtree.getRight()) {
                if (child.getKey() == null || !child.getKey().equals(key)) continue;
                this.model.setObject((Serializable)((RealmTO)subtree.getLeft()));
                return (RealmTO)subtree.getLeft();
            }
        }
        return null;
    }

    public List<AbstractLink> getLinks() {
        return this.links;
    }

    public static class ChosenRealm<T> {
        protected final AjaxRequestTarget target;
        protected final T obj;

        public ChosenRealm(T obj, AjaxRequestTarget target) {
            this.obj = obj;
            this.target = target;
        }

        public T getObj() {
            return this.obj;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }
    }
}

