/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.events;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.events.EventSelectionPanel;
import org.apache.syncope.client.console.events.SelectedEventsPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.audit.EventCategory;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;

public abstract class EventCategoryPanel
extends Panel {
    private static final long serialVersionUID = 6429053774964787734L;
    private final List<EventCategory> eventCategoryTOs;
    private final EventCategory eventCategoryTO = new EventCategory();
    private final WebMarkupContainer categoryContainer;
    private final WebMarkupContainer eventsContainer;
    private final SelectedEventsPanel selectedEventsPanel;
    private final AjaxDropDownChoicePanel<AuditElements.EventCategoryType> type;
    private final AjaxDropDownChoicePanel<String> category;
    private final AjaxDropDownChoicePanel<String> subcategory;
    private final AjaxTextFieldPanel custom;
    private final ActionsPanel<EventCategory> actionsPanel;
    private final IModel<List<String>> model;

    public EventCategoryPanel(String id, List<EventCategory> eventCategoryTOs, IModel<List<String>> model) {
        super(id);
        this.model = model;
        this.selectedEventsPanel = new SelectedEventsPanel("selectedEventsPanel", model);
        this.add(new Component[]{this.selectedEventsPanel});
        this.eventCategoryTOs = eventCategoryTOs;
        this.categoryContainer = new WebMarkupContainer("categoryContainer");
        this.categoryContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.categoryContainer});
        this.eventsContainer = new WebMarkupContainer("eventsContainer");
        this.eventsContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.eventsContainer});
        this.authorizeList();
        this.authorizeChanges();
        this.type = new AjaxDropDownChoicePanel("type", "type", (IModel)new PropertyModel((Object)this.eventCategoryTO, "type"), false);
        this.type.setChoices(List.of(AuditElements.EventCategoryType.values()));
        this.type.setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<AuditElements.EventCategoryType>(){
            private static final long serialVersionUID = 2317134950949778735L;

            public String getDisplayValue(AuditElements.EventCategoryType eventCategoryType) {
                return eventCategoryType.name();
            }

            public String getIdValue(AuditElements.EventCategoryType eventCategoryType, int i) {
                return eventCategoryType.name();
            }

            public AuditElements.EventCategoryType getObject(String id, IModel<? extends List<? extends AuditElements.EventCategoryType>> choices) {
                return ((List)choices.getObject()).stream().filter(object -> object.name().equals(id)).findAny().orElse(null);
            }
        });
        this.categoryContainer.add(new Component[]{this.type});
        this.type.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                EventCategoryPanel.this.send((IEventSink)EventCategoryPanel.this, Broadcast.EXACT, new ChangeCategoryEvent(target, (Panel)EventCategoryPanel.this.type));
            }
        }});
        this.category = new AjaxDropDownChoicePanel("category", "category", (IModel)new PropertyModel((Object)this.eventCategoryTO, "category"), false);
        this.category.setChoices(EventCategoryPanel.filter(eventCategoryTOs, (AuditElements.EventCategoryType)this.type.getModelObject()));
        this.categoryContainer.add(new Component[]{this.category});
        this.category.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306811L;

            protected void onUpdate(AjaxRequestTarget target) {
                EventCategoryPanel.this.send((IEventSink)EventCategoryPanel.this, Broadcast.EXACT, new ChangeCategoryEvent(target, (Panel)EventCategoryPanel.this.category));
            }
        }});
        this.subcategory = new AjaxDropDownChoicePanel("subcategory", "subcategory", (IModel)new PropertyModel((Object)this.eventCategoryTO, "subcategory"), false);
        this.subcategory.setChoices(EventCategoryPanel.filter(eventCategoryTOs, (AuditElements.EventCategoryType)this.type.getModelObject(), (String)((Object)this.category.getModelObject())));
        this.categoryContainer.add(new Component[]{this.subcategory});
        this.subcategory.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306812L;

            protected void onUpdate(AjaxRequestTarget target) {
                EventCategoryPanel.this.send((IEventSink)EventCategoryPanel.this, Broadcast.EXACT, new ChangeCategoryEvent(target, (Panel)EventCategoryPanel.this.subcategory));
            }
        }});
        this.categoryContainer.add(new Component[]{new Label("customLabel", (IModel)new ResourceModel("custom", "custom")).setVisible(false)});
        this.custom = new AjaxTextFieldPanel("custom", "custom", (IModel)new Model(null));
        this.custom.setVisible(false);
        this.custom.setEnabled(false);
        this.categoryContainer.add(new Component[]{this.custom.hideLabel()});
        this.actionsPanel = new ActionsPanel("customActions", null);
        this.actionsPanel.add(new ActionLink<EventCategory>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, EventCategory ignore) {
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)((Object)EventCategoryPanel.this.custom.getModelObject())))) {
                    Pair parsed = AuditLoggerName.parseEventCategory((String)((String)((Object)EventCategoryPanel.this.custom.getModelObject())));
                    String eventString = AuditLoggerName.buildEvent((AuditElements.EventCategoryType)((EventCategory)parsed.getKey()).getType(), null, null, (String)(((EventCategory)parsed.getKey()).getEvents().isEmpty() ? "" : (String)((EventCategory)parsed.getKey()).getEvents().iterator().next()), (AuditElements.Result)((AuditElements.Result)parsed.getValue()));
                    EventCategoryPanel.this.custom.setModelObject((Serializable)((Object)""));
                    EventCategoryPanel.this.send((IEventSink)EventCategoryPanel.this.getPage(), Broadcast.BREADTH, new SelectedEventsPanel.EventSelectionChanged(target, Set.of(eventString), Set.of()));
                    target.add(new Component[]{EventCategoryPanel.this.categoryContainer});
                }
            }
        }, ActionLink.ActionType.CREATE, "").hideLabel();
        this.actionsPanel.add(new ActionLink<EventCategory>(){
            private static final long serialVersionUID = -3722207913631435521L;

            @Override
            public void onClick(AjaxRequestTarget target, EventCategory ignore) {
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)((Object)EventCategoryPanel.this.custom.getModelObject())))) {
                    Pair parsed = AuditLoggerName.parseEventCategory((String)((String)((Object)EventCategoryPanel.this.custom.getModelObject())));
                    String eventString = AuditLoggerName.buildEvent((AuditElements.EventCategoryType)((EventCategory)parsed.getKey()).getType(), null, null, (String)(((EventCategory)parsed.getKey()).getEvents().isEmpty() ? "" : (String)((EventCategory)parsed.getKey()).getEvents().iterator().next()), (AuditElements.Result)((AuditElements.Result)parsed.getValue()));
                    EventCategoryPanel.this.custom.setModelObject((Serializable)((Object)""));
                    EventCategoryPanel.this.send((IEventSink)EventCategoryPanel.this.getPage(), Broadcast.BREADTH, new SelectedEventsPanel.EventSelectionChanged(target, Set.of(), Set.of(eventString)));
                    target.add(new Component[]{EventCategoryPanel.this.categoryContainer});
                }
            }
        }, ActionLink.ActionType.DELETE, "", true).hideLabel();
        this.categoryContainer.add(new Component[]{this.actionsPanel});
        this.actionsPanel.setVisible(false);
        this.actionsPanel.setEnabled(false);
        this.actionsPanel.setMarkupId("inline-actions");
        this.eventsContainer.add(new Component[]{new EventSelectionPanel("eventsPanel", this.eventCategoryTO, model){
            private static final long serialVersionUID = 3513194801190026082L;

            @Override
            protected void onEventAction(IEvent<?> event) {
                EventCategoryPanel.this.onEventAction(event);
            }
        }});
    }

    private static List<String> filter(List<EventCategory> eventCategoryTOs, AuditElements.EventCategoryType type) {
        HashSet res = new HashSet();
        eventCategoryTOs.stream().filter(eventCategory -> type == eventCategory.getType() && StringUtils.isNotEmpty((CharSequence)eventCategory.getCategory())).forEachOrdered(eventCategory -> res.add(eventCategory.getCategory()));
        return res.stream().sorted().collect(Collectors.toList());
    }

    private static List<String> filter(List<EventCategory> eventCategoryTOs, AuditElements.EventCategoryType type, String category) {
        HashSet res = new HashSet();
        eventCategoryTOs.stream().filter(eventCategory -> type == eventCategory.getType() && StringUtils.equals((CharSequence)category, (CharSequence)eventCategory.getCategory()) && StringUtils.isNotEmpty((CharSequence)eventCategory.getSubcategory())).forEachOrdered(eventCategory -> res.add(eventCategory.getSubcategory()));
        return res.stream().sorted().collect(Collectors.toList());
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof ChangeCategoryEvent) {
            this.eventCategoryTO.getEvents().clear();
            ChangeCategoryEvent change = (ChangeCategoryEvent)event.getPayload();
            Panel changedPanel = change.getChangedPanel();
            if (null != changedPanel.getId()) {
                switch (changedPanel.getId()) {
                    case "type": {
                        this.eventCategoryTO.setType((AuditElements.EventCategoryType)this.type.getModelObject());
                        this.eventCategoryTO.setCategory(null);
                        this.eventCategoryTO.setSubcategory(null);
                        if (this.type.getModelObject() == AuditElements.EventCategoryType.CUSTOM) {
                            this.category.setChoices(List.of());
                            this.subcategory.setChoices(List.of());
                            this.category.setEnabled(false);
                            this.subcategory.setEnabled(false);
                            this.custom.setVisible(true);
                            this.custom.setEnabled(true);
                            this.actionsPanel.setVisible(true);
                            this.actionsPanel.setEnabled(true);
                        } else {
                            this.category.setChoices(EventCategoryPanel.filter(this.eventCategoryTOs, (AuditElements.EventCategoryType)this.type.getModelObject()));
                            this.subcategory.setChoices(List.of());
                            this.category.setEnabled(true);
                            this.subcategory.setEnabled(true);
                            this.custom.setVisible(false);
                            this.custom.setEnabled(false);
                            this.actionsPanel.setVisible(false);
                            this.actionsPanel.setEnabled(false);
                        }
                        change.getTarget().add(new Component[]{this.categoryContainer});
                        break;
                    }
                    case "category": {
                        this.subcategory.setChoices(EventCategoryPanel.filter(this.eventCategoryTOs, (AuditElements.EventCategoryType)this.type.getModelObject(), (String)((Object)this.category.getModelObject())));
                        this.eventCategoryTO.setCategory((String)((Object)this.category.getModelObject()));
                        this.eventCategoryTO.setSubcategory(null);
                        change.getTarget().add(new Component[]{this.categoryContainer});
                        break;
                    }
                    default: {
                        this.eventCategoryTO.setSubcategory((String)((Object)this.subcategory.getModelObject()));
                    }
                }
            }
            this.updateEventsContainer(change.getTarget());
        } else if (event.getPayload() instanceof SelectedEventsPanel.InspectSelectedEvent) {
            this.eventCategoryTO.getEvents().clear();
            SelectedEventsPanel.InspectSelectedEvent inspectSelectedEvent = (SelectedEventsPanel.InspectSelectedEvent)event.getPayload();
            Pair categoryEvent = AuditLoggerName.parseEventCategory((String)inspectSelectedEvent.getEvent());
            this.eventCategoryTO.setType(((EventCategory)categoryEvent.getKey()).getType());
            this.category.setChoices(EventCategoryPanel.filter(this.eventCategoryTOs, (AuditElements.EventCategoryType)this.type.getModelObject()));
            this.eventCategoryTO.setCategory(((EventCategory)categoryEvent.getKey()).getCategory());
            this.subcategory.setChoices(EventCategoryPanel.filter(this.eventCategoryTOs, (AuditElements.EventCategoryType)this.type.getModelObject(), (String)((Object)this.category.getModelObject())));
            this.eventCategoryTO.setSubcategory(((EventCategory)categoryEvent.getKey()).getSubcategory());
            if (((EventCategory)categoryEvent.getKey()).getType() == AuditElements.EventCategoryType.CUSTOM) {
                this.custom.setModelObject((Serializable)((Object)AuditLoggerName.buildEvent((AuditElements.EventCategoryType)((EventCategory)categoryEvent.getKey()).getType(), (String)((EventCategory)categoryEvent.getKey()).getCategory(), (String)((EventCategory)categoryEvent.getKey()).getSubcategory(), (String)(((EventCategory)categoryEvent.getKey()).getEvents().isEmpty() ? "" : (String)((EventCategory)categoryEvent.getKey()).getEvents().iterator().next()), (AuditElements.Result)((AuditElements.Result)categoryEvent.getValue()))));
                this.category.setEnabled(false);
                this.subcategory.setEnabled(false);
                this.custom.setVisible(true);
                this.custom.setEnabled(true);
                this.actionsPanel.setVisible(true);
                this.actionsPanel.setEnabled(true);
            } else {
                this.category.setEnabled(true);
                this.subcategory.setEnabled(true);
                this.custom.setVisible(false);
                this.custom.setEnabled(false);
                this.actionsPanel.setVisible(false);
                this.actionsPanel.setEnabled(false);
            }
            inspectSelectedEvent.getTarget().add(new Component[]{this.categoryContainer});
            this.updateEventsContainer(inspectSelectedEvent.getTarget());
        }
    }

    private void setEvents() {
        Iterator<EventCategory> itor = this.eventCategoryTOs.iterator();
        while (itor.hasNext() && this.eventCategoryTO.getEvents().isEmpty()) {
            EventCategory eventCategory = itor.next();
            if (eventCategory.getType() != this.eventCategoryTO.getType() || !StringUtils.equals((CharSequence)eventCategory.getCategory(), (CharSequence)this.eventCategoryTO.getCategory()) || !StringUtils.equals((CharSequence)eventCategory.getSubcategory(), (CharSequence)this.eventCategoryTO.getSubcategory())) continue;
            this.eventCategoryTO.getEvents().addAll(eventCategory.getEvents());
        }
    }

    protected void onEventAction(IEvent<?> event) {
    }

    private void authorizeList() {
        this.getListAuthRoles().forEach(role -> MetaDataRoleAuthorizationStrategy.authorize((Component)this.selectedEventsPanel, (Action)RENDER, (String)role));
    }

    private void authorizeChanges() {
        this.getChangeAuthRoles().forEach(role -> {
            MetaDataRoleAuthorizationStrategy.authorize((Component)this.categoryContainer, (Action)RENDER, (String)role);
            MetaDataRoleAuthorizationStrategy.authorize((Component)this.eventsContainer, (Action)RENDER, (String)role);
        });
    }

    private void updateEventsContainer(AjaxRequestTarget target) {
        this.setEvents();
        this.eventsContainer.addOrReplace(new Component[]{new EventSelectionPanel("eventsPanel", this.eventCategoryTO, this.model){
            private static final long serialVersionUID = 3513194801190026082L;

            @Override
            public void onEventAction(IEvent<?> event) {
                EventCategoryPanel.this.onEventAction(event);
            }
        }});
        target.add(new Component[]{this.eventsContainer});
    }

    protected abstract List<String> getListAuthRoles();

    protected abstract List<String> getChangeAuthRoles();

    private static class ChangeCategoryEvent {
        private final AjaxRequestTarget target;
        private final Panel changedPanel;

        ChangeCategoryEvent(AjaxRequestTarget target, Panel changedPanel) {
            this.target = target;
            this.changedPanel = changedPanel;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }

        public Panel getChangedPanel() {
            return this.changedPanel;
        }
    }
}

