/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.task.service.impl;

import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.identitylink.api.IdentityLinkInfo;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskBuilder;

public abstract class BaseTaskBuilderImpl
implements TaskBuilder {
    protected CommandExecutor commandExecutor;
    protected String id;
    protected String name;
    protected String description;
    protected int priority = 50;
    protected String ownerId;
    protected String assigneeId;
    protected Date dueDate;
    protected String category;
    protected String parentTaskId;
    protected String tenantId;
    protected String formKey;
    protected String taskDefinitionId;
    protected String taskDefinitionKey;
    protected String scopeId;
    protected String scopeType;
    protected Set<? extends IdentityLinkInfo> identityLinks = Collections.EMPTY_SET;

    public BaseTaskBuilderImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public abstract Task create();

    public TaskBuilder id(String id) {
        this.id = id;
        return this;
    }

    public TaskBuilder name(String name) {
        this.name = name;
        return this;
    }

    public TaskBuilder description(String description) {
        this.description = description;
        return this;
    }

    public TaskBuilder priority(int priority) {
        this.priority = priority;
        return this;
    }

    public TaskBuilder owner(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public TaskBuilder assignee(String assigneId) {
        this.assigneeId = assigneId;
        return this;
    }

    public TaskBuilder dueDate(Date dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    public TaskBuilder category(String category) {
        this.category = category;
        return this;
    }

    public TaskBuilder parentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
        return this;
    }

    public TaskBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public TaskBuilder formKey(String formKey) {
        this.formKey = formKey;
        return this;
    }

    public TaskBuilder taskDefinitionId(String taskDefinitionId) {
        this.taskDefinitionId = taskDefinitionId;
        return this;
    }

    public TaskBuilder taskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
        return this;
    }

    public TaskBuilder identityLinks(Set<? extends IdentityLinkInfo> identityLinks) {
        this.identityLinks = identityLinks;
        return this;
    }

    public TaskBuilder scopeId(String scopeId) {
        this.scopeId = scopeId;
        return this;
    }

    public TaskBuilder scopeType(String scopeType) {
        this.scopeType = scopeType;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getOwner() {
        return this.ownerId;
    }

    public String getAssignee() {
        return this.assigneeId;
    }

    public String getTaskDefinitionId() {
        return this.taskDefinitionId;
    }

    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public String getCategory() {
        return this.category;
    }

    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public Set<? extends IdentityLinkInfo> getIdentityLinks() {
        return this.identityLinks;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public String getScopeType() {
        return this.scopeType;
    }
}

