/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.mfa.simple.validation;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Optional;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.support.mfa.simple.RestfulCasSimpleMultifactorAuthenticationTokenProperties;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorTokenCredential;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicket;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicketFactory;
import org.apereo.cas.mfa.simple.validation.CasSimpleMultifactorAuthenticationService;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.hjson.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class RestfulCasSimpleMultifactorAuthenticationService
implements CasSimpleMultifactorAuthenticationService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestfulCasSimpleMultifactorAuthenticationService.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().singleValueAsArray(true).defaultTypingEnabled(true).build().toObjectMapper();
    private final RestfulCasSimpleMultifactorAuthenticationTokenProperties properties;
    private final TicketFactory ticketFactory;

    /*
     * Loose catch block
     */
    @Override
    public CasSimpleMultifactorAuthenticationTicket generate(Principal principal, Service service) throws Exception {
        int statusCode;
        StringWriter writer;
        HttpResponse response;
        block8: {
            response = null;
            writer = new StringWriter();
            MAPPER.writer((PrettyPrinter)new MinimalPrettyPrinter()).writeValue((Writer)writer, (Object)principal);
            LinkedHashMap parameters = new LinkedHashMap();
            Optional.ofNullable(service).ifPresent(s -> parameters.put("service", s.getId()));
            HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().method(HttpMethod.GET).headers(this.properties.getHeaders()).url(StringUtils.appendIfMissing((String)this.properties.getUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat("new")).entity(writer.toString()).basicAuthPassword(this.properties.getBasicAuthPassword()).basicAuthUsername(this.properties.getBasicAuthUsername()).parameters(parameters).headers(CollectionUtils.wrap((String)"Content-Type", (Object)"application/json")).build();
            response = HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
            statusCode = response.getStatusLine().getStatusCode();
            if (!HttpStatus.valueOf((int)statusCode).is2xxSuccessful()) break block8;
            String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            CasSimpleMultifactorAuthenticationTicketFactory mfaFactory = (CasSimpleMultifactorAuthenticationTicketFactory)this.ticketFactory.get(CasSimpleMultifactorAuthenticationTicket.class);
            LOGGER.debug("Multifactor authentication token received is [{}]", (Object)result);
            CasSimpleMultifactorAuthenticationTicket token = mfaFactory.create(result, service, CollectionUtils.wrap((String)"principal", (Object)principal));
            LOGGER.debug("Created multifactor authentication token [{}] for service [{}]", (Object)token.getId(), (Object)service);
            CasSimpleMultifactorAuthenticationTicket casSimpleMultifactorAuthenticationTicket = token;
            writer.close();
            HttpUtils.close((HttpResponse)response);
            return casSimpleMultifactorAuthenticationTicket;
        }
        try {
            throw new FailedLoginException("Unable to validate multifactor credential with status " + statusCode);
            {
                catch (Throwable throwable) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable) {
            HttpUtils.close(response);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(CasSimpleMultifactorAuthenticationTicket token) throws Exception {
        HttpResponse response = null;
        try (StringWriter writer = new StringWriter();){
            MAPPER.writer((PrettyPrinter)new MinimalPrettyPrinter()).writeValue((Writer)writer, (Object)token);
            HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().method(HttpMethod.POST).headers(this.properties.getHeaders()).url(this.properties.getUrl()).entity(writer.toString()).basicAuthPassword(this.properties.getBasicAuthPassword()).basicAuthUsername(this.properties.getBasicAuthUsername()).headers(CollectionUtils.wrap((String)"Content-Type", (Object)"application/json")).build();
            response = HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
            int statusCode = response.getStatusLine().getStatusCode();
            if (HttpStatus.valueOf((int)statusCode).isError()) {
                throw new FailedLoginException("Unable to validate multifactor credential with status " + statusCode);
            }
        }
        catch (Throwable throwable) {
            HttpUtils.close(response);
            throw throwable;
        }
        HttpUtils.close((HttpResponse)response);
    }

    /*
     * Loose catch block
     */
    @Override
    public Principal validate(Authentication authentication, CasSimpleMultifactorTokenCredential credential) throws Exception {
        int statusCode;
        StringWriter writer;
        HttpResponse response;
        block8: {
            response = null;
            writer = new StringWriter();
            MAPPER.writer((PrettyPrinter)new MinimalPrettyPrinter()).writeValue((Writer)writer, (Object)authentication);
            HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().method(HttpMethod.GET).headers(this.properties.getHeaders()).url(StringUtils.appendIfMissing((String)this.properties.getUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat(credential.getToken())).entity(writer.toString()).basicAuthPassword(this.properties.getBasicAuthPassword()).basicAuthUsername(this.properties.getBasicAuthUsername()).headers(CollectionUtils.wrap((String)"Content-Type", (Object)"application/json")).build();
            response = HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
            statusCode = response.getStatusLine().getStatusCode();
            if (!HttpStatus.valueOf((int)statusCode).is2xxSuccessful()) break block8;
            String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            Principal principal = (Principal)MAPPER.readValue(JsonValue.readHjson((String)result).toString(), Principal.class);
            writer.close();
            HttpUtils.close((HttpResponse)response);
            return principal;
        }
        try {
            throw new FailedLoginException("Unable to validate multifactor credential with status " + statusCode);
            {
                catch (Throwable throwable) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable) {
            HttpUtils.close(response);
            throw throwable;
        }
    }

    @Generated
    public RestfulCasSimpleMultifactorAuthenticationService(RestfulCasSimpleMultifactorAuthenticationTokenProperties properties, TicketFactory ticketFactory) {
        this.properties = properties;
        this.ticketFactory = ticketFactory;
    }
}

