/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.net.URI;
import java.time.OffsetDateTime;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.to.TaskTO;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.rest.api.beans.TaskQuery;
import org.apache.syncope.common.rest.api.service.TaskService;
import org.apache.syncope.core.logic.AbstractExecutableLogic;
import org.apache.syncope.core.logic.TaskLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractExecutableService;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TaskServiceImpl
extends AbstractExecutableService
implements TaskService {
    protected final TaskLogic logic;

    public TaskServiceImpl(TaskLogic logic) {
        this.logic = logic;
    }

    @Override
    protected AbstractExecutableLogic<?> getExecutableLogic() {
        return this.logic;
    }

    public Response create(TaskType type, SchedTaskTO taskTO) {
        if (taskTO == null) {
            throw new BadRequestException();
        }
        SchedTaskTO createdTask = this.logic.createSchedTask(type, taskTO);
        URI location = this.uriInfo.getAbsolutePathBuilder().path(createdTask.getKey()).build(new Object[0]);
        return Response.created((URI)location).header("X-Syncope-Key", (Object)createdTask.getKey()).build();
    }

    public void delete(TaskType type, String key) {
        this.logic.delete(type, key);
    }

    public <T extends TaskTO> PagedResult<T> search(TaskQuery query) {
        Pair result = this.logic.search(query.getType(), query.getResource(), query.getNotification(), query.getAnyTypeKind(), query.getEntityKey(), query.getPage().intValue(), query.getSize().intValue(), this.getOrderByClauses(query.getOrderBy()), query.getDetails().booleanValue());
        return this.buildPagedResult((List)result.getRight(), query.getPage(), query.getSize(), (Integer)result.getLeft());
    }

    public <T extends TaskTO> T read(TaskType type, String key, boolean details) {
        return (T)this.logic.read(type, key, details);
    }

    public void update(TaskType type, SchedTaskTO taskTO) {
        this.logic.updateSchedTask(type, taskTO);
    }

    public Response purgePropagations(OffsetDateTime since, List<ExecStatus> statuses, List<String> resources) {
        if (since == null && CollectionUtils.isEmpty(statuses) && CollectionUtils.isEmpty(resources)) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        return Response.ok((Object)this.logic.purgePropagations(since, statuses, resources)).build();
    }
}

