/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.starter;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.spring.JAXRSServerFactoryBeanDefinitionParser;
import org.apache.cxf.jaxrs.validation.JAXRSBeanValidationInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.keymaster.client.api.DomainOps;
import org.apache.syncope.common.keymaster.client.api.DomainWatcher;
import org.apache.syncope.common.keymaster.client.api.KeymasterProperties;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.rest.api.service.ConfParamService;
import org.apache.syncope.common.keymaster.rest.api.service.DomainService;
import org.apache.syncope.common.keymaster.rest.api.service.NetworkServiceService;
import org.apache.syncope.core.keymaster.internal.InternalConfParamHelper;
import org.apache.syncope.core.keymaster.internal.SelfKeymasterInternalConfParamOps;
import org.apache.syncope.core.keymaster.internal.SelfKeymasterInternalDomainOps;
import org.apache.syncope.core.keymaster.internal.SelfKeymasterInternalServiceOps;
import org.apache.syncope.core.keymaster.rest.cxf.service.ConfParamServiceImpl;
import org.apache.syncope.core.keymaster.rest.cxf.service.DomainServiceImpl;
import org.apache.syncope.core.keymaster.rest.cxf.service.NetworkServiceServiceImpl;
import org.apache.syncope.core.keymaster.rest.security.SelfKeymasterUsernamePasswordAuthenticationProvider;
import org.apache.syncope.core.logic.ConfParamLogic;
import org.apache.syncope.core.logic.DomainLogic;
import org.apache.syncope.core.logic.NetworkServiceLogic;
import org.apache.syncope.core.persistence.api.dao.ConfParamDAO;
import org.apache.syncope.core.persistence.api.dao.DomainDAO;
import org.apache.syncope.core.persistence.api.dao.NetworkServiceDAO;
import org.apache.syncope.core.persistence.api.entity.SelfKeymasterEntityFactory;
import org.apache.syncope.core.persistence.jpa.dao.JPAConfParamDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPADomainDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPANetworkServiceDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPASelfKeymasterEntityFactory;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.rest.cxf.RestServiceExceptionMapper;
import org.apache.syncope.core.spring.security.AuthDataAccessor;
import org.apache.syncope.core.spring.security.DefaultCredentialChecker;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.apache.syncope.core.spring.security.UsernamePasswordAuthenticationProvider;
import org.apache.syncope.core.spring.security.WebSecurityContext;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;

@EnableConfigurationProperties(value={KeymasterProperties.class})
@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={WebSecurityContext.class})
@Conditional(value={SelfKeymasterCondition.class})
public class SelfKeymasterContext {
    private static final Pattern HTTP = Pattern.compile("^http.+");

    @Bean
    public Server selfKeymasterContainer(ConfParamService confParamService, NetworkServiceService networkServiceService, DomainService domainService, JacksonJsonProvider jsonProvider, GZIPInInterceptor gzipInInterceptor, GZIPOutInterceptor gzipOutInterceptor, JAXRSBeanValidationInInterceptor validationInInterceptor, RestServiceExceptionMapper restServiceExceptionMapper, Bus bus) {
        JAXRSServerFactoryBeanDefinitionParser.SpringJAXRSServerFactoryBean selfKeymasterContainer = new JAXRSServerFactoryBeanDefinitionParser.SpringJAXRSServerFactoryBean();
        selfKeymasterContainer.setBus(bus);
        selfKeymasterContainer.setAddress("/keymaster");
        selfKeymasterContainer.setStaticSubresourceResolution(true);
        selfKeymasterContainer.setProperties(Map.of("convert.wadl.resources.to.dom", "false"));
        selfKeymasterContainer.setServiceBeans(List.of(confParamService, networkServiceService, domainService));
        selfKeymasterContainer.setInInterceptors(List.of(gzipInInterceptor, validationInInterceptor));
        selfKeymasterContainer.setOutInterceptors(List.of(gzipOutInterceptor));
        selfKeymasterContainer.setProviders(List.of(restServiceExceptionMapper, jsonProvider));
        return selfKeymasterContainer.create();
    }

    @Bean
    public UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider(DomainOps domainOps, AuthDataAccessor dataAccessor, UserProvisioningManager provisioningManager, DefaultCredentialChecker credentialChecker, SecurityProperties securityProperties, KeymasterProperties keymasterProperties) {
        return new SelfKeymasterUsernamePasswordAuthenticationProvider(domainOps, dataAccessor, provisioningManager, credentialChecker, securityProperties, keymasterProperties);
    }

    @Bean
    public InternalConfParamHelper internalConfParamHelper(ConfParamDAO confParamDAO, SelfKeymasterEntityFactory entityFactory) {
        return new InternalConfParamHelper(confParamDAO, entityFactory);
    }

    @Bean
    public ConfParamOps internalConfParamOps(InternalConfParamHelper helper) {
        return new SelfKeymasterInternalConfParamOps(helper);
    }

    @Bean
    public ServiceOps internalServiceOps(NetworkServiceLogic networkServiceLogic, KeymasterProperties props) {
        return new SelfKeymasterInternalServiceOps(networkServiceLogic, props);
    }

    @Bean
    public DomainOps domainOps(DomainLogic domainLogic, KeymasterProperties props) {
        return new SelfKeymasterInternalDomainOps(domainLogic, props);
    }

    @Bean
    public ConfParamLogic confParamLogic(InternalConfParamHelper helper) {
        return new ConfParamLogic(helper);
    }

    @Bean
    public DomainLogic domainLogic(DomainDAO domainDAO, SelfKeymasterEntityFactory selfKeymasterEntityFactory, DomainWatcher domainWatcher) {
        return new DomainLogic(domainDAO, selfKeymasterEntityFactory, domainWatcher);
    }

    @Bean
    public NetworkServiceLogic networkServiceLogic(NetworkServiceDAO serviceDAO, SelfKeymasterEntityFactory selfKeymasterEntityFactory) {
        return new NetworkServiceLogic(serviceDAO, selfKeymasterEntityFactory);
    }

    @Bean
    public SelfKeymasterEntityFactory selfKeymasterEntityFactory() {
        return new JPASelfKeymasterEntityFactory();
    }

    @Bean
    public ConfParamDAO confParamDAO() {
        return new JPAConfParamDAO();
    }

    @Bean
    public DomainDAO domainDAO() {
        return new JPADomainDAO();
    }

    @Bean
    public NetworkServiceDAO networkServiceDAO() {
        return new JPANetworkServiceDAO();
    }

    @Bean
    public ConfParamService confParamService(ConfParamLogic confParamLogic) {
        return new ConfParamServiceImpl(confParamLogic);
    }

    @Bean
    public DomainService domainService(DomainLogic domainLogic) {
        return new DomainServiceImpl(domainLogic);
    }

    @Bean
    public NetworkServiceService networkServiceService(NetworkServiceLogic networkServiceLogic) {
        return new NetworkServiceServiceImpl(networkServiceLogic);
    }

    static class SelfKeymasterCondition
    extends SpringBootCondition {
        SelfKeymasterCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String keymasterAddress = context.getEnvironment().getProperty("keymaster.address");
            return new ConditionOutcome(keymasterAddress != null && HTTP.matcher(keymasterAddress).matches(), "Keymaster address not set for Self: " + keymasterAddress);
        }
    }
}

