/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomUtils;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.NetworkServiceDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.NetworkServiceEntity;
import org.apache.syncope.core.persistence.api.entity.SelfKeymasterEntityFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class NetworkServiceLogic
extends AbstractTransactionalLogic<EntityTO> {
    protected final NetworkServiceDAO serviceDAO;
    protected final SelfKeymasterEntityFactory entityFactory;

    public NetworkServiceLogic(NetworkServiceDAO serviceDAO, SelfKeymasterEntityFactory entityFactory) {
        this.serviceDAO = serviceDAO;
        this.entityFactory = entityFactory;
    }

    protected NetworkService toNetworkService(NetworkService.Type serviceType, NetworkServiceEntity service) {
        NetworkService ns = new NetworkService();
        ns.setType(serviceType);
        ns.setAddress(service.getAddress());
        return ns;
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name")
    @Transactional(readOnly=true)
    public List<NetworkService> list(NetworkService.Type serviceType) {
        return this.serviceDAO.findAll(serviceType).stream().map(service -> this.toNetworkService(serviceType, (NetworkServiceEntity)service)).collect(Collectors.toList());
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name")
    @Transactional(readOnly=true)
    public NetworkService get(NetworkService.Type serviceType) {
        List<NetworkService> list = this.list(serviceType);
        if (list.isEmpty()) {
            throw new NotFoundException("No registered services for type " + serviceType);
        }
        return list.size() == 1 ? list.get(0) : list.get(RandomUtils.nextInt((int)0, (int)list.size()));
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name")
    public void register(NetworkService networkService) {
        if (this.serviceDAO.findAll(networkService.getType()).stream().noneMatch(s -> s.getAddress().equals(networkService.getAddress()))) {
            NetworkServiceEntity service = this.entityFactory.newNetworkService();
            service.setType(networkService.getType());
            service.setAddress(networkService.getAddress());
            this.serviceDAO.save(service);
        }
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name")
    public void unregister(NetworkService networkService) {
        this.serviceDAO.deleteAll(networkService);
    }

    protected EntityTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnsupportedOperationException();
    }
}

