/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.markup.html.form;

import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.ui.JQueryUIBehavior;
import com.googlecode.wicket.jquery.ui.form.spinner.AjaxSpinner;
import com.googlecode.wicket.jquery.ui.form.spinner.ISpinnerListener;
import com.googlecode.wicket.jquery.ui.form.spinner.SpinnerAdapter;
import com.googlecode.wicket.jquery.ui.form.spinner.SpinnerBehavior;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.Attributable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

public final class AjaxSpinnerFieldPanel<T extends Number>
extends FieldPanel<T> {
    private static final long serialVersionUID = 6413819574530703577L;
    private final Class<T> reference;
    private final IModel<T> model;
    private final Options options;
    private final boolean convertValuesToString;
    private SpinnerBehavior behavior;

    private AjaxSpinnerFieldPanel(String id, String name, Class<T> reference, IModel<T> model, Options options, boolean enableOnChange, boolean convertValuesToString) {
        super(id, name, model);
        this.field = new AjaxSpinner<T>("spinner", model, options, reference){
            private static final long serialVersionUID = -3624755213720060594L;

            public JQueryUIBehavior newWidgetBehavior(String selector) {
                AjaxSpinnerFieldPanel.this.behavior = new SpinnerBehavior(selector, (ISpinnerListener)new SpinnerAdapter());
                AjaxSpinnerFieldPanel.this.behavior.setOptions(this.options);
                return AjaxSpinnerFieldPanel.this.behavior;
            }
        };
        if (enableOnChange && !this.isReadOnly()) {
            this.field.add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                }
            }});
        }
        this.add(new Component[]{this.field.setLabel((IModel)new ResourceModel(name, name)).setOutputMarkupId(true)});
        this.name = name;
        this.model = model;
        this.reference = reference;
        this.options = options;
        this.convertValuesToString = convertValuesToString;
    }

    @Override
    public AjaxSpinnerFieldPanel<T> setNewModel(final List<Serializable> list) {
        this.setNewModel(new Model<T>(){
            private static final long serialVersionUID = 527651414610325237L;

            public T getObject() {
                Number value = null;
                if (list != null && !list.isEmpty() && list.get(0) != null && StringUtils.isNotBlank((CharSequence)((Serializable)list.get(0)).toString())) {
                    value = AjaxSpinnerFieldPanel.this.reference.equals(Integer.class) ? (Number)((Number)AjaxSpinnerFieldPanel.this.reference.cast(NumberUtils.toInt((String)((Serializable)list.get(0)).toString()))) : (Number)(AjaxSpinnerFieldPanel.this.reference.equals(Long.class) ? (Number)((Number)AjaxSpinnerFieldPanel.this.reference.cast(NumberUtils.toLong((String)((Serializable)list.get(0)).toString()))) : (Number)(AjaxSpinnerFieldPanel.this.reference.equals(Short.class) ? (Number)((Number)AjaxSpinnerFieldPanel.this.reference.cast(NumberUtils.toShort((String)((Serializable)list.get(0)).toString()))) : (Number)(AjaxSpinnerFieldPanel.this.reference.equals(Float.class) ? (Number)((Number)AjaxSpinnerFieldPanel.this.reference.cast(Float.valueOf(NumberUtils.toFloat((String)((Serializable)list.get(0)).toString())))) : (Number)(AjaxSpinnerFieldPanel.this.reference.equals(Byte.TYPE) ? (Number)((Number)AjaxSpinnerFieldPanel.this.reference.cast(NumberUtils.toByte((String)((Serializable)list.get(0)).toString()))) : (Number)((Number)AjaxSpinnerFieldPanel.this.reference.cast(NumberUtils.toDouble((String)((Serializable)list.get(0)).toString())))))));
                }
                return value;
            }

            public void setObject(T object) {
                list.clear();
                Optional.ofNullable(object).ifPresent(v -> list.add(AjaxSpinnerFieldPanel.this.convertValuesToString ? v.toString() : v));
            }
        });
        return this;
    }

    @Override
    public AjaxSpinnerFieldPanel<T> setNewModel(final ListItem item) {
        this.field.setModel((IModel)new Model<T>(){
            private static final long serialVersionUID = 6799404673615637845L;

            public T getObject() {
                Number number = null;
                Object obj = item.getModelObject();
                if (obj != null && !obj.toString().isEmpty()) {
                    if (obj instanceof String) {
                        try {
                            number = AjaxSpinnerFieldPanel.this.reference.equals(Integer.class) ? (Number)((Number)AjaxSpinnerFieldPanel.this.reference.cast(Integer.valueOf((String)obj))) : (Number)(AjaxSpinnerFieldPanel.this.reference.equals(Long.class) ? (Number)((Number)AjaxSpinnerFieldPanel.this.reference.cast(Long.valueOf((String)obj))) : (Number)(AjaxSpinnerFieldPanel.this.reference.equals(Short.class) ? (Number)((Number)AjaxSpinnerFieldPanel.this.reference.cast(Short.valueOf((String)obj))) : (Number)(AjaxSpinnerFieldPanel.this.reference.equals(Float.class) ? (Number)((Number)AjaxSpinnerFieldPanel.this.reference.cast(Float.valueOf((String)obj))) : (Number)(AjaxSpinnerFieldPanel.this.reference.equals(Byte.TYPE) ? (Number)((Number)AjaxSpinnerFieldPanel.this.reference.cast(Byte.valueOf((String)obj))) : (Number)((Number)AjaxSpinnerFieldPanel.this.reference.cast(Double.valueOf((String)obj)))))));
                        }
                        catch (NumberFormatException e) {
                            AbstractFieldPanel.LOG.error("While attempting to parse {}", obj, (Object)e);
                        }
                    } else if (obj instanceof Number) {
                        number = (Number)AjaxSpinnerFieldPanel.this.reference.cast(obj);
                    }
                }
                return number;
            }

            public void setObject(T object) {
                item.setModelObject(Optional.ofNullable(object).map(Object::toString).orElse(null));
            }
        });
        return this;
    }

    @Override
    public FieldPanel<T> setNewModel(final Attributable attributable, final String schema) {
        this.field.setModel((IModel)new Model(){
            private static final long serialVersionUID = -4214654722524358000L;

            public Serializable getObject() {
                return attributable.getPlainAttr(schema).map(Attr::getValues).filter(Predicate.not(List::isEmpty)).map(values -> AjaxSpinnerFieldPanel.this.reference.equals(Integer.class) ? (Number)((Number)AjaxSpinnerFieldPanel.this.reference.cast(NumberUtils.toInt((String)((String)values.get(0))))) : (Number)(AjaxSpinnerFieldPanel.this.reference.equals(Long.class) ? (Number)((Number)AjaxSpinnerFieldPanel.this.reference.cast(NumberUtils.toLong((String)((String)values.get(0))))) : (Number)(AjaxSpinnerFieldPanel.this.reference.equals(Short.class) ? (Number)((Number)AjaxSpinnerFieldPanel.this.reference.cast(NumberUtils.toShort((String)((String)values.get(0))))) : (Number)(AjaxSpinnerFieldPanel.this.reference.equals(Float.class) ? (Number)((Number)AjaxSpinnerFieldPanel.this.reference.cast(Float.valueOf(NumberUtils.toFloat((String)((String)values.get(0)))))) : (Number)(AjaxSpinnerFieldPanel.this.reference.equals(Byte.TYPE) ? (Number)((Number)AjaxSpinnerFieldPanel.this.reference.cast(NumberUtils.toByte((String)((String)values.get(0))))) : (Number)((Number)AjaxSpinnerFieldPanel.this.reference.cast(NumberUtils.toDouble((String)((String)values.get(0)))))))))).orElse(null);
            }

            public void setObject(Serializable object) {
                attributable.getPlainAttr(schema).ifPresent(plainAttr -> {
                    plainAttr.getValues().clear();
                    Optional.ofNullable(object).ifPresent(o -> plainAttr.getValues().add(o.toString()));
                });
            }
        });
        return this;
    }

    @Override
    public AjaxSpinnerFieldPanel<T> clone() {
        AjaxSpinnerFieldPanel<T> panel = new AjaxSpinnerFieldPanel<T>(this.getId(), this.name, this.reference, this.model, this.options, false, this.convertValuesToString);
        panel.setRequired(this.isRequired());
        panel.setReadOnly(this.isReadOnly());
        panel.setTitle(this.title);
        if (this.isRequiredLabelAdded) {
            panel.addRequiredLabel();
        }
        return panel;
    }

    @Override
    public FieldPanel<T> setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        ((AjaxSpinner)AjaxSpinner.class.cast(this.field)).setEnabled(!readOnly);
        this.options.set("disabled", (Object)readOnly);
        if (this.behavior != null) {
            this.behavior.setOptions(this.options);
        }
        return this;
    }

    public static class Builder<T extends Number> {
        private final Options options = new Options();
        private boolean enableOnChange = false;
        private boolean convertValuesToString = true;

        public Builder<T> min(T min) {
            this.options.set("min", min);
            return this;
        }

        public Builder<T> max(T max) {
            this.options.set("max", max);
            return this;
        }

        public Builder<T> step(T step) {
            this.options.set("step", step);
            return this;
        }

        public Builder<T> enableOnChange() {
            this.enableOnChange = true;
            return this;
        }

        public Builder<T> convertValuesToString(boolean convertValuesToString) {
            this.convertValuesToString = convertValuesToString;
            return this;
        }

        public AjaxSpinnerFieldPanel<T> build(String id, String name, Class<T> reference, IModel<T> model) {
            return new AjaxSpinnerFieldPanel<T>(id, name, reference, model, this.options, this.enableOnChange, this.convertValuesToString);
        }
    }
}

