/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons;

import java.security.AccessControlException;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.ui.commons.BaseLogin;
import org.apache.syncope.client.ui.commons.BaseSession;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.core.request.handler.IPageProvider;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.markup.html.pages.ExceptionErrorPage;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SyncopeUIRequestCycleListener
implements IRequestCycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeUIRequestCycleListener.class);

    private static Throwable instanceOf(Exception e, Class<? extends Exception> clazz) {
        return clazz.isAssignableFrom(e.getClass()) ? e : (e.getCause() != null && clazz.isAssignableFrom(e.getCause().getClass()) ? e.getCause() : (e.getCause() != null && e.getCause().getCause() != null && clazz.isAssignableFrom(e.getCause().getCause().getClass()) ? e.getCause().getCause() : null));
    }

    public IRequestHandler onException(RequestCycle cycle, Exception e) {
        IRequestablePage errorPage;
        LOG.error("Exception found", (Throwable)e);
        PageParameters errorParameters = new PageParameters();
        if (SyncopeUIRequestCycleListener.instanceOf(e, UnauthorizedInstantiationException.class) != null) {
            errorParameters.add("errorMessage", (Object)BaseSession.Error.AUTHORIZATION.fallback());
            errorPage = this.getErrorPage(errorParameters);
        } else if (SyncopeUIRequestCycleListener.instanceOf(e, AccessControlException.class) != null) {
            if (StringUtils.containsIgnoreCase((CharSequence)SyncopeUIRequestCycleListener.instanceOf(e, AccessControlException.class).getMessage(), (CharSequence)"expired")) {
                errorParameters.add("errorMessage", (Object)BaseSession.Error.SESSION_EXPIRED.fallback());
            } else {
                errorParameters.add("errorMessage", (Object)BaseSession.Error.AUTHORIZATION.fallback());
            }
            errorPage = this.getErrorPage(errorParameters);
        } else if (SyncopeUIRequestCycleListener.instanceOf(e, PageExpiredException.class) != null || !this.isSignedIn()) {
            errorParameters.add("errorMessage", (Object)BaseSession.Error.SESSION_EXPIRED.fallback());
            errorPage = this.getErrorPage(errorParameters);
        } else if (SyncopeUIRequestCycleListener.instanceOf(e, BadRequestException.class) != null || SyncopeUIRequestCycleListener.instanceOf(e, WebServiceException.class) != null || SyncopeUIRequestCycleListener.instanceOf(e, SyncopeClientException.class) != null) {
            errorParameters.add("errorMessage", (Object)BaseSession.Error.REST.fallback());
            errorPage = this.getErrorPage(errorParameters);
        } else {
            Throwable cause = SyncopeUIRequestCycleListener.instanceOf(e, ForbiddenException.class);
            if (cause == null) {
                errorPage = new ExceptionErrorPage((Throwable)e, null);
            } else {
                errorParameters.add("errorMessage", (Object)cause.getMessage());
                errorPage = this.getErrorPage(errorParameters);
            }
        }
        if (errorPage instanceof BaseLogin) {
            try {
                this.invalidateSession();
            }
            catch (Throwable t) {
                LOG.debug("Unexpected error while forcing logout after error", t);
            }
        }
        return new RenderPageRequestHandler((IPageProvider)new PageProvider(errorPage));
    }

    protected abstract boolean isSignedIn();

    protected abstract void invalidateSession();

    protected abstract IRequestablePage getErrorPage(PageParameters var1);
}

