/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.audit;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.db.ColumnMapping;
import org.apache.logging.log4j.core.appender.db.jdbc.AbstractConnectionSource;
import org.apache.logging.log4j.core.appender.db.jdbc.ConnectionSource;
import org.apache.logging.log4j.core.appender.db.jdbc.JdbcAppender;
import org.apache.syncope.core.logic.audit.DefaultAuditAppender;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class JdbcAuditAppender
extends DefaultAuditAppender {
    public JdbcAuditAppender(String domain, DataSource domainDataSource) {
        super(domain);
        LoggerContext logCtx = (LoggerContext)LogManager.getContext((boolean)false);
        ColumnMapping[] columnMappings = new ColumnMapping[]{ColumnMapping.newBuilder().setConfiguration(logCtx.getConfiguration()).setName("EVENT_DATE").setType(Timestamp.class).build(), ColumnMapping.newBuilder().setConfiguration(logCtx.getConfiguration()).setName("LOGGER_LEVEL").setPattern("%level").build(), ColumnMapping.newBuilder().setConfiguration(logCtx.getConfiguration()).setName("LOGGER").setPattern("%logger").build(), ColumnMapping.newBuilder().setConfiguration(logCtx.getConfiguration()).setName("MESSAGE").setPattern("%message").build(), ColumnMapping.newBuilder().setConfiguration(logCtx.getConfiguration()).setName("THROWABLE").setPattern("%ex{full}").build()};
        this.targetAppender = Optional.ofNullable(logCtx.getConfiguration().getAppender(this.getTargetAppenderName())).orElseGet(() -> {
            JdbcAppender a = ((JdbcAppender.Builder)((JdbcAppender.Builder)JdbcAppender.newBuilder().setName(this.getTargetAppenderName())).setIgnoreExceptions(false)).setConnectionSource((ConnectionSource)new DataSourceConnectionSource(domain, domainDataSource)).setBufferSize(0).setTableName("AuditEntry").setColumnMappings(columnMappings).build();
            a.start();
            logCtx.getConfiguration().addAppender((Appender)a);
            return a;
        });
    }

    @Override
    public String getTargetAppenderName() {
        return "audit_for_" + this.domain;
    }

    protected static class DataSourceConnectionSource
    extends AbstractConnectionSource {
        private final String description;
        private final DataSource dataSource;

        DataSourceConnectionSource(String domain, DataSource dataSource) {
            this.description = "dataSource{ domain=" + domain + ", value=" + dataSource + " }";
            this.dataSource = dataSource;
        }

        public Connection getConnection() throws SQLException {
            return DataSourceUtils.getConnection((DataSource)this.dataSource);
        }

        public String toString() {
            return this.description;
        }
    }
}

