/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.lib.types.JobType;
import org.apache.syncope.common.rest.api.batch.BatchResponseItem;
import org.apache.syncope.core.logic.AbstractExecutableLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.JobStatusDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.ReportDAO;
import org.apache.syncope.core.persistence.api.dao.ReportExecDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.api.entity.ReportExec;
import org.apache.syncope.core.provisioning.api.data.ReportDataBinder;
import org.apache.syncope.core.provisioning.api.job.JobManager;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.apache.syncope.core.provisioning.api.utils.ExceptionUtils2;
import org.apache.syncope.core.provisioning.java.job.report.ReportJob;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class ReportLogic
extends AbstractExecutableLogic<ReportTO> {
    protected final ReportDAO reportDAO;
    protected final ReportExecDAO reportExecDAO;
    protected final ReportDataBinder binder;
    protected final EntityFactory entityFactory;

    public ReportLogic(JobManager jobManager, SchedulerFactoryBean scheduler, JobStatusDAO jobStatusDAO, ReportDAO reportDAO, ReportExecDAO reportExecDAO, ReportDataBinder binder, EntityFactory entityFactory) {
        super(jobManager, scheduler, jobStatusDAO);
        this.reportDAO = reportDAO;
        this.reportExecDAO = reportExecDAO;
        this.binder = binder;
        this.entityFactory = entityFactory;
    }

    @PreAuthorize(value="hasRole('REPORT_CREATE')")
    public ReportTO create(ReportTO reportTO) {
        Report report = (Report)this.entityFactory.newEntity(Report.class);
        this.binder.getReport(report, reportTO);
        report = this.reportDAO.save(report);
        try {
            this.jobManager.register(report, null, AuthContextUtils.getUsername());
        }
        catch (Exception e) {
            LOG.error("While registering quartz job for report " + report.getKey(), (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return this.binder.getReportTO(report);
    }

    @PreAuthorize(value="hasRole('REPORT_UPDATE')")
    public ReportTO update(ReportTO reportTO) {
        Report report = Optional.ofNullable(this.reportDAO.find(reportTO.getKey())).orElseThrow(() -> new NotFoundException("Report " + reportTO.getKey()));
        this.binder.getReport(report, reportTO);
        report = this.reportDAO.save(report);
        try {
            this.jobManager.register(report, null, AuthContextUtils.getUsername());
        }
        catch (Exception e) {
            LOG.error("While registering quartz job for report " + report.getKey(), (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return this.binder.getReportTO(report);
    }

    @PreAuthorize(value="hasRole('REPORT_LIST')")
    @Transactional(readOnly=true)
    public List<ReportTO> list() {
        return this.reportDAO.findAll().stream().map(arg_0 -> ((ReportDataBinder)this.binder).getReportTO(arg_0)).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('REPORT_READ')")
    @Transactional(readOnly=true)
    public ReportTO read(String key) {
        Report report = Optional.ofNullable(this.reportDAO.find(key)).orElseThrow(() -> new NotFoundException("Report " + key));
        return this.binder.getReportTO(report);
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_EXECUTE')")
    public ExecTO execute(String key, OffsetDateTime startAt, boolean dryRun) {
        Report report = Optional.ofNullable(this.reportDAO.find(key)).orElseThrow(() -> new NotFoundException("Report " + key));
        if (!report.isActive()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add("Report " + key + " is not active");
            throw sce;
        }
        try {
            Map jobDataMap = this.jobManager.register(report, startAt, AuthContextUtils.getUsername());
            jobDataMap.put("dryRun", dryRun);
            if (startAt == null) {
                this.scheduler.getScheduler().triggerJob(JobNamer.getJobKey((Report)report));
            }
        }
        catch (Exception e) {
            LOG.error("While executing report {}", (Object)report, (Object)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        ExecTO result = new ExecTO();
        result.setJobType(JobType.REPORT);
        result.setRefKey(report.getKey());
        result.setRefDesc(this.binder.buildRefDesc(report));
        result.setStart(OffsetDateTime.now());
        result.setStatus("JOB_FIRED");
        result.setMessage("Job fired; waiting for results...");
        result.setExecutor(AuthContextUtils.getUsername());
        return result;
    }

    @PreAuthorize(value="hasRole('REPORT_READ')")
    @Transactional(readOnly=true)
    public String getFilename(String executionKey) {
        ReportExec reportExec = Optional.ofNullable(this.reportExecDAO.find(executionKey)).orElseThrow(() -> new NotFoundException("Report execution " + executionKey));
        return reportExec.getReport().getName() + "." + StringUtils.removeStart((String)reportExec.getReport().getFileExt(), (String)".");
    }

    @PreAuthorize(value="hasRole('REPORT_READ')")
    @Transactional(readOnly=true)
    public void exportExecutionResult(OutputStream os, String executionKey) {
        ReportExec reportExec = Optional.ofNullable(this.reportExecDAO.find(executionKey)).orElseThrow(() -> new NotFoundException("Report execution " + executionKey));
        if (reportExec.getExecResult() == null || !ReportJob.Status.SUCCESS.name().equals(reportExec.getStatus())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidReportExec);
            sce.getElements().add(reportExec.getExecResult() == null ? "No report data produced" : "Report did not run successfully");
            throw sce;
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(reportExec.getExecResult());
             ZipInputStream zis = new ZipInputStream(bais);){
            zis.getNextEntry();
            zis.transferTo(os);
        }
        catch (Exception e) {
            LOG.error("While exporting content", (Throwable)e);
        }
    }

    @PreAuthorize(value="hasRole('REPORT_DELETE')")
    public ReportTO delete(String key) {
        Report report = Optional.ofNullable(this.reportDAO.find(key)).orElseThrow(() -> new NotFoundException("Report " + key));
        ReportTO deletedReport = this.binder.getReportTO(report);
        this.jobManager.unregister(report);
        this.reportDAO.delete(report);
        return deletedReport;
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_READ')")
    public Pair<Integer, List<ExecTO>> listExecutions(String key, OffsetDateTime before, OffsetDateTime after, int page, int size, List<OrderByClause> orderByClauses) {
        Report report = Optional.ofNullable(this.reportDAO.find(key)).orElseThrow(() -> new NotFoundException("Report " + key));
        Integer count = this.reportExecDAO.count(report, before, after);
        List result = this.reportExecDAO.findAll(report, before, after, page, size, orderByClauses).stream().map(reportExec -> this.binder.getExecTO(reportExec)).collect(Collectors.toList());
        return Pair.of((Object)count, result);
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_LIST')")
    public List<ExecTO> listRecentExecutions(int max) {
        return this.reportExecDAO.findRecent(max).stream().map(reportExec -> this.binder.getExecTO(reportExec)).collect(Collectors.toList());
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_DELETE')")
    public ExecTO deleteExecution(String executionKey) {
        ReportExec reportExec = Optional.ofNullable(this.reportExecDAO.find(executionKey)).orElseThrow(() -> new NotFoundException("Report execution " + executionKey));
        ExecTO reportExecToDelete = this.binder.getExecTO(reportExec);
        this.reportExecDAO.delete(reportExec);
        return reportExecToDelete;
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_DELETE')")
    public List<BatchResponseItem> deleteExecutions(String key, OffsetDateTime before, OffsetDateTime after) {
        Report report = Optional.ofNullable(this.reportDAO.find(key)).orElseThrow(() -> new NotFoundException("Report " + key));
        ArrayList<BatchResponseItem> batchResponseItems = new ArrayList<BatchResponseItem>();
        this.reportExecDAO.findAll(report, before, after, -1, -1, List.of()).forEach(exec -> {
            BatchResponseItem item = new BatchResponseItem();
            item.getHeaders().put("X-Syncope-Key", List.of(exec.getKey()));
            batchResponseItems.add(item);
            try {
                this.reportExecDAO.delete(exec);
                item.setStatus(Response.Status.OK.getStatusCode());
            }
            catch (Exception e) {
                LOG.error("Error deleting execution {} of report {}", new Object[]{exec.getKey(), key, e});
                item.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
                item.setContent(ExceptionUtils2.getFullStackTrace((Throwable)e));
            }
        });
        return batchResponseItems;
    }

    @Override
    protected Triple<JobType, String, String> getReference(JobKey jobKey) {
        String key = JobNamer.getReportKeyFromJobName((String)jobKey.getName());
        return Optional.ofNullable(this.reportDAO.find(key)).map(f -> Triple.of((Object)JobType.REPORT, (Object)key, (Object)this.binder.buildRefDesc(f))).orElse(null);
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_LIST')")
    public List<JobTO> listJobs() {
        return super.doListJobs(false);
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_READ')")
    public JobTO getJob(String key) {
        Report report = Optional.ofNullable(this.reportDAO.find(key)).orElseThrow(() -> new NotFoundException("Report " + key));
        JobTO jobTO = null;
        try {
            jobTO = this.getJobTO(JobNamer.getJobKey((Report)report), false);
        }
        catch (SchedulerException e) {
            LOG.error("Problems while retrieving scheduled job {}", (Object)JobNamer.getJobKey((Report)report), (Object)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        if (jobTO == null) {
            throw new NotFoundException("Job for report " + key);
        }
        return jobTO;
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_EXECUTE')")
    public void actionJob(String key, JobAction action) {
        Report report = Optional.ofNullable(this.reportDAO.find(key)).orElseThrow(() -> new NotFoundException("Report " + key));
        this.doActionJob(JobNamer.getJobKey((Report)report), action);
    }

    @Override
    protected ReportTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args) && ("create".equals(method.getName()) || "update".equals(method.getName()) || "delete".equals(method.getName()))) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof ReportTO)) continue;
                key = ((ReportTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getReportTO(this.reportDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

