/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.java;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.request.AnyObjectCR;
import org.apache.syncope.common.lib.request.AnyObjectUR;
import org.apache.syncope.common.lib.request.MembershipUR;
import org.apache.syncope.common.lib.types.AnyEntitlement;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.data.AnyObjectDataBinder;
import org.apache.syncope.core.provisioning.api.event.AnyLifecycleEvent;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.workflow.api.AnyObjectWorkflowAdapter;
import org.apache.syncope.core.workflow.java.AbstractWorkflowAdapter;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Throwable.class})
public abstract class AbstractAnyObjectWorkflowAdapter
extends AbstractWorkflowAdapter
implements AnyObjectWorkflowAdapter {
    protected final AnyObjectDataBinder dataBinder;
    protected final AnyObjectDAO anyObjectDAO;

    public AbstractAnyObjectWorkflowAdapter(AnyObjectDataBinder dataBinder, AnyObjectDAO anyObjectDAO, GroupDAO groupDAO, EntityFactory entityFactory, ApplicationEventPublisher publisher) {
        super(groupDAO, entityFactory, publisher);
        this.dataBinder = dataBinder;
        this.anyObjectDAO = anyObjectDAO;
    }

    public String getPrefix() {
        return null;
    }

    protected abstract WorkflowResult<String> doCreate(AnyObjectCR var1, String var2, String var3);

    public WorkflowResult<String> create(AnyObjectCR anyObjectCR, String creator, String context) {
        WorkflowResult<String> result = this.doCreate(anyObjectCR, creator, context);
        AnyObject anyObject = (AnyObject)this.anyObjectDAO.find((String)result.getResult());
        anyObject.getMemberships().stream().forEach(m -> this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Any)((Group)m.getRightEnd()), AuthContextUtils.getDomain())));
        return result;
    }

    protected abstract WorkflowResult<AnyObjectUR> doUpdate(AnyObject var1, AnyObjectUR var2, String var3, String var4);

    public WorkflowResult<AnyObjectUR> update(AnyObjectUR anyObjectUR, String updater, String context) {
        WorkflowResult<AnyObjectUR> result = this.doUpdate((AnyObject)this.anyObjectDAO.authFind(anyObjectUR.getKey()), anyObjectUR, updater, context);
        AnyObject anyObject = (AnyObject)this.anyObjectDAO.find(anyObjectUR.getKey());
        HashSet authRealms = new HashSet();
        authRealms.addAll(AuthContextUtils.getAuthorizations().getOrDefault(AnyEntitlement.READ.getFor(anyObject.getType().getKey()), Collections.emptySet()));
        authRealms.addAll(AuthContextUtils.getAuthorizations().getOrDefault(AnyEntitlement.UPDATE.getFor(anyObject.getType().getKey()), Collections.emptySet()));
        this.anyObjectDAO.securityChecks(authRealms, anyObject.getKey(), anyObject.getRealm().getFullPath(), this.anyObjectDAO.findAllGroupKeys(anyObject));
        ((AnyObjectUR)result.getResult()).getMemberships().stream().map(MembershipUR::getGroup).distinct().map(arg_0 -> ((GroupDAO)this.groupDAO).find(arg_0)).filter(Objects::nonNull).forEach(group -> this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Any)group, AuthContextUtils.getDomain())));
        return result;
    }

    protected abstract void doDelete(AnyObject var1, String var2, String var3);

    public void delete(String anyObjectKey, String eraser, String context) {
        AnyObject anyObject = (AnyObject)this.anyObjectDAO.authFind(anyObjectKey);
        Set<Group> groups = anyObject.getMemberships().stream().map(Relationship::getRightEnd).collect(Collectors.toSet());
        this.doDelete(anyObject, eraser, context);
        groups.forEach(group -> this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Any)group, AuthContextUtils.getDomain())));
    }
}

