/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import org.flowable.job.service.impl.asyncexecutor.AsyncJobExecutorConfiguration;
import org.flowable.job.service.impl.asyncexecutor.DefaultAsyncJobExecutor;
import org.flowable.job.service.impl.asyncexecutor.ResetExpiredJobsRunnable;
import org.flowable.job.service.impl.asyncexecutor.UnacquireAsyncHistoryJobExceptionHandler;

public class DefaultAsyncHistoryJobExecutor
extends DefaultAsyncJobExecutor {
    public DefaultAsyncHistoryJobExecutor() {
        this.setTimerRunnableNeeded(false);
        this.setAcquireRunnableThreadName("flowable-acquire-history-jobs");
        this.setResetExpiredRunnableName("flowable-reset-expired-history-jobs");
        this.setAsyncRunnableExecutionExceptionHandler(new UnacquireAsyncHistoryJobExceptionHandler());
    }

    public DefaultAsyncHistoryJobExecutor(AsyncJobExecutorConfiguration configuration) {
        super(configuration);
        this.setTimerRunnableNeeded(false);
        if (configuration.getAcquireRunnableThreadName() == null) {
            this.setAcquireRunnableThreadName("flowable-acquire-history-jobs");
        }
        if (configuration.getResetExpiredRunnableName() == null) {
            this.setResetExpiredRunnableName("flowable-reset-expired-history-jobs");
        }
        this.setAsyncRunnableExecutionExceptionHandler(new UnacquireAsyncHistoryJobExceptionHandler());
    }

    @Override
    protected void initializeJobEntityManager() {
        if (this.jobEntityManager == null) {
            this.jobEntityManager = this.jobServiceConfiguration.getHistoryJobEntityManager();
        }
    }

    @Override
    protected ResetExpiredJobsRunnable createResetExpiredJobsRunnable(String resetRunnableName) {
        return new ResetExpiredJobsRunnable(resetRunnableName, this, this.jobServiceConfiguration.getHistoryJobEntityManager());
    }
}

