/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.DelegationDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.FIQLQueryDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Privilege;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.SecurityQuestion;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.jpa.dao.AbstractAnyDAO;
import org.apache.syncope.core.persistence.jpa.entity.user.JPALinkedAccount;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUMembership;
import org.apache.syncope.core.provisioning.api.utils.RealmUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class JPAUserDAO
extends AbstractAnyDAO<User>
implements UserDAO {
    protected final RoleDAO roleDAO;
    protected final AccessTokenDAO accessTokenDAO;
    protected final GroupDAO groupDAO;
    protected final DelegationDAO delegationDAO;
    protected final FIQLQueryDAO fiqlQueryDAO;
    protected final SecurityProperties securityProperties;

    public JPAUserDAO(AnyUtilsFactory anyUtilsFactory, PlainSchemaDAO plainSchemaDAO, DerSchemaDAO derSchemaDAO, DynRealmDAO dynRealmDAO, RoleDAO roleDAO, AccessTokenDAO accessTokenDAO, GroupDAO groupDAO, DelegationDAO delegationDAO, FIQLQueryDAO fiqlQueryDAO, SecurityProperties securityProperties) {
        super(anyUtilsFactory, plainSchemaDAO, derSchemaDAO, dynRealmDAO);
        this.roleDAO = roleDAO;
        this.accessTokenDAO = accessTokenDAO;
        this.groupDAO = groupDAO;
        this.delegationDAO = delegationDAO;
        this.fiqlQueryDAO = fiqlQueryDAO;
        this.securityProperties = securityProperties;
    }

    @Override
    protected AnyUtils init() {
        return this.anyUtilsFactory.getInstance(AnyTypeKind.USER);
    }

    @Transactional(readOnly=true)
    public String findKey(String username) {
        Query query = this.entityManager().createNativeQuery("SELECT id FROM SyncopeUser WHERE username=?");
        query.setParameter(1, (Object)username);
        String key = null;
        for (Object resultKey : query.getResultList()) {
            key = resultKey instanceof Object[] ? (String)((Object[])resultKey)[0] : (String)resultKey;
        }
        return key;
    }

    @Transactional(readOnly=true)
    public OffsetDateTime findLastChange(String key) {
        return this.findLastChange(key, "SyncopeUser");
    }

    @Transactional(readOnly=true)
    public Optional<String> findUsername(String key) {
        Query query = this.entityManager().createNativeQuery("SELECT username FROM SyncopeUser WHERE id=?");
        query.setParameter(1, (Object)key);
        String username = null;
        for (Object resultKey : query.getResultList()) {
            username = resultKey instanceof Object[] ? (String)((Object[])resultKey)[0] : (String)resultKey;
        }
        return Optional.ofNullable(username);
    }

    public int count() {
        Query query = this.entityManager().createQuery("SELECT COUNT(e) FROM  " + this.anyUtils().anyClass().getSimpleName() + " e");
        return ((Number)query.getSingleResult()).intValue();
    }

    public Map<String, Integer> countByRealm() {
        Query query = this.entityManager().createQuery("SELECT e.realm, COUNT(e) FROM  " + this.anyUtils().anyClass().getSimpleName() + " e GROUP BY e.realm");
        List results = query.getResultList();
        return results.stream().collect(Collectors.toMap(result -> ((Realm)result[0]).getFullPath(), result -> ((Number)result[1]).intValue()));
    }

    public Map<String, Integer> countByStatus() {
        Query query = this.entityManager().createQuery("SELECT e.status, COUNT(e) FROM  " + this.anyUtils().anyClass().getSimpleName() + " e GROUP BY e.status");
        List results = query.getResultList();
        return results.stream().collect(Collectors.toMap(result -> (String)result[0], result -> ((Number)result[1]).intValue()));
    }

    @Transactional(readOnly=true)
    public void securityChecks(Set<String> authRealms, String key, String realm, Collection<String> groups) {
        boolean authorized = authRealms.stream().map(authRealm -> RealmUtils.parseGroupOwnerRealm((String)authRealm).orElse(null)).filter(Objects::nonNull).anyMatch(pair -> groups.contains(pair.getRight()));
        if (!authorized) {
            authorized = this.findDynRealms(key).stream().anyMatch(authRealms::contains);
        }
        if (!authorized) {
            authorized = authRealms.stream().anyMatch(realm::startsWith);
        }
        if (!authorized) {
            throw new DelegatedAdministrationException(realm, AnyTypeKind.USER.name(), key);
        }
    }

    @Override
    protected void securityChecks(User user) {
        if (!AuthContextUtils.getUsername().equals(this.securityProperties.getAnonymousUser()) && !AuthContextUtils.getUsername().equals(user.getUsername())) {
            Set<String> authRealms = AuthContextUtils.getAuthorizations().getOrDefault("USER_READ", Set.of());
            this.securityChecks(authRealms, user.getKey(), user.getRealm().getFullPath(), this.findAllGroupKeys(user));
        }
    }

    public User findByUsername(String username) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + this.anyUtils().anyClass().getSimpleName() + " e WHERE e.username = :username", User.class);
        query.setParameter("username", (Object)username);
        User result = null;
        try {
            result = (User)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOG.debug("No user found with username {}", (Object)username, (Object)e);
        }
        return result;
    }

    public User findByToken(String token) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + this.anyUtils().anyClass().getSimpleName() + " e WHERE e.token LIKE :token", User.class);
        query.setParameter("token", (Object)token);
        User result = null;
        try {
            result = (User)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOG.debug("No user found with token {}", (Object)token, (Object)e);
        }
        return result;
    }

    public List<User> findBySecurityQuestion(SecurityQuestion securityQuestion) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + this.anyUtils().anyClass().getSimpleName() + " e WHERE e.securityQuestion = :securityQuestion", User.class);
        query.setParameter("securityQuestion", (Object)securityQuestion);
        return query.getResultList();
    }

    public UMembership findMembership(String key) {
        return (UMembership)this.entityManager().find(JPAUMembership.class, (Object)key);
    }

    public List<User> findAll(int page, int itemsPerPage) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM  " + this.anyUtils().anyClass().getSimpleName() + " e ORDER BY e.id", User.class);
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        query.setMaxResults(itemsPerPage);
        return query.getResultList();
    }

    public List<String> findAllKeys(int page, int itemsPerPage) {
        return this.findAllKeys("SyncopeUser", page, itemsPerPage);
    }

    protected Pair<User, Pair<Set<String>, Set<String>>> doSave(User user) {
        User merged = super.save(user);
        this.roleDAO.refreshDynMemberships(merged);
        Pair dynGroupMembs = this.groupDAO.refreshDynMemberships(merged);
        this.dynRealmDAO.refreshDynMemberships((Any)merged);
        return Pair.of((Object)merged, (Object)dynGroupMembs);
    }

    @Override
    public User save(User user) {
        return (User)this.doSave(user).getLeft();
    }

    public Pair<Set<String>, Set<String>> saveAndGetDynGroupMembs(User user) {
        return (Pair)this.doSave(user).getRight();
    }

    public void delete(User user) {
        this.roleDAO.removeDynMemberships(user.getKey());
        this.groupDAO.removeDynMemberships(user);
        this.dynRealmDAO.removeDynMemberships(user.getKey());
        this.delegationDAO.findByDelegating(user).forEach(arg_0 -> ((DelegationDAO)this.delegationDAO).delete(arg_0));
        this.delegationDAO.findByDelegated(user).forEach(arg_0 -> ((DelegationDAO)this.delegationDAO).delete(arg_0));
        this.fiqlQueryDAO.findByOwner(user, null).forEach(arg_0 -> ((FIQLQueryDAO)this.fiqlQueryDAO).delete(arg_0));
        Optional.ofNullable(this.accessTokenDAO.findByOwner(user.getUsername())).ifPresent(arg_0 -> ((AccessTokenDAO)this.accessTokenDAO).delete(arg_0));
        this.entityManager().remove((Object)user);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<Role> findAllRoles(User user) {
        HashSet<Role> result = new HashSet<Role>();
        result.addAll(user.getRoles());
        result.addAll(this.findDynRoles(user.getKey()));
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<Role> findDynRoles(String key) {
        Query query = this.entityManager().createNativeQuery("SELECT role_id FROM DynRoleMembers WHERE any_id=?");
        query.setParameter(1, (Object)key);
        ArrayList<Role> result = new ArrayList<Role>();
        query.getResultList().stream().map(resultKey -> resultKey instanceof Object[] ? (String)((Object[])resultKey)[0] : (String)resultKey).forEach(roleKey -> {
            Role role = this.roleDAO.find(roleKey.toString());
            if (role == null) {
                LOG.error("Could not find role {}, even though returned by the native query", roleKey);
            } else if (!result.contains(role)) {
                result.add(role);
            }
        });
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<Group> findDynGroups(String key) {
        Query query = this.entityManager().createNativeQuery("SELECT group_id FROM UDynGroupMembers WHERE any_id=?");
        query.setParameter(1, (Object)key);
        ArrayList<Group> result = new ArrayList<Group>();
        query.getResultList().stream().map(resultKey -> resultKey instanceof Object[] ? (String)((Object[])resultKey)[0] : (String)resultKey).forEach(groupKey -> {
            Group group = (Group)this.groupDAO.find(groupKey.toString());
            if (group == null) {
                LOG.error("Could not find group {}, even though returned by the native query", groupKey);
            } else if (!result.contains(group)) {
                result.add(group);
            }
        });
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<Group> findAllGroups(User user) {
        HashSet<Group> result = new HashSet<Group>();
        result.addAll(user.getMemberships().stream().map(Relationship::getRightEnd).collect(Collectors.toSet()));
        result.addAll(this.findDynGroups(user.getKey()));
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<String> findAllGroupKeys(User user) {
        return this.findAllGroups(user).stream().map(Entity::getKey).collect(Collectors.toList());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<String> findAllGroupNames(User user) {
        return this.findAllGroups(user).stream().map(Group::getName).collect(Collectors.toList());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<ExternalResource> findAllResources(User user) {
        HashSet<ExternalResource> result = new HashSet<ExternalResource>();
        result.addAll(user.getResources());
        this.findAllGroups(user).forEach(group -> result.addAll(group.getResources()));
        return result;
    }

    @Transactional(readOnly=true)
    public Collection<String> findAllResourceKeys(String key) {
        return this.findAllResources((User)this.authFind(key)).stream().map(Entity::getKey).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public boolean linkedAccountExists(String userKey, String connObjectKeyValue) {
        Query query = this.entityManager().createNativeQuery("SELECT id FROM LinkedAccount WHERE owner_id=? AND connObjectKeyValue=?");
        query.setParameter(1, (Object)userKey);
        query.setParameter(2, (Object)connObjectKeyValue);
        return !query.getResultList().isEmpty();
    }

    public Optional<? extends LinkedAccount> findLinkedAccount(ExternalResource resource, String connObjectKeyValue) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPALinkedAccount.class.getSimpleName() + " e WHERE e.resource=:resource AND e.connObjectKeyValue=:connObjectKeyValue", LinkedAccount.class);
        query.setParameter("resource", (Object)resource);
        query.setParameter("connObjectKeyValue", (Object)connObjectKeyValue);
        List result = query.getResultList();
        return result.isEmpty() ? Optional.empty() : Optional.of((LinkedAccount)result.get(0));
    }

    @Transactional(readOnly=true)
    public List<LinkedAccount> findLinkedAccounts(String userKey) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPALinkedAccount.class.getSimpleName() + " e WHERE e.owner.id=:userKey", LinkedAccount.class);
        query.setParameter("userKey", (Object)userKey);
        return query.getResultList();
    }

    public List<LinkedAccount> findLinkedAccountsByPrivilege(Privilege privilege) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPALinkedAccount.class.getSimpleName() + " e WHERE :privilege MEMBER OF e.privileges", LinkedAccount.class);
        query.setParameter("privilege", (Object)privilege);
        return query.getResultList();
    }

    public List<LinkedAccount> findLinkedAccountsByResource(ExternalResource resource) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPALinkedAccount.class.getSimpleName() + " e WHERE e.resource=:resource", LinkedAccount.class);
        query.setParameter("resource", (Object)resource);
        return query.getResultList();
    }
}

