/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.status;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.status.ResourceStatusDirectoryPanel;
import org.apache.syncope.client.console.status.StatusModal;
import org.apache.syncope.client.ui.commons.DirectoryDataProvider;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.status.StatusBean;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.Model;

public class ResourceStatusModal
extends StatusModal<ResourceTO> {
    private static final long serialVersionUID = 1066124171682570080L;
    private Model<String> typeModel = new Model();

    public ResourceStatusModal(PageReference pageRef, ResourceTO resource) {
        super(pageRef, resource, null, false);
        List availableAnyTypes = resource.getProvisions().stream().map(Provision::getAnyType).sorted(AnyTypeRestClient.KEY_COMPARATOR).collect(Collectors.toList());
        AjaxDropDownChoicePanel anyTypes = new AjaxDropDownChoicePanel("anyTypes", "anyTypes", this.typeModel, false);
        anyTypes.setChoices(availableAnyTypes);
        anyTypes.hideLabel();
        this.add(new Component[]{anyTypes});
        anyTypes.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                ((ResourceStatusDirectoryPanel)((Object)ResourceStatusDirectoryPanel.class.cast(ResourceStatusModal.this.directoryPanel))).updateResultTable((String)((Object)ResourceStatusModal.this.typeModel.getObject()), target);
            }
        }});
    }

    @Override
    protected DirectoryPanel<StatusBean, StatusBean, DirectoryDataProvider<StatusBean>, AbstractAnyRestClient<?>> getStatusDirectoryPanel(MultilevelPanel mlp, PageReference pageReference, ResourceTO entity, String itemKeyFieldName, boolean statusOnly) {
        return new ResourceStatusDirectoryPanel(mlp, pageReference, null, entity);
    }
}

