/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.enhance.AttributeTranslator;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.ManagedInstanceProvider;
import org.apache.openjpa.enhance.PCEnhancer;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.Reflection;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.meta.AccessCode;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.ApplicationIds;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.ObjectId;

public class ReflectingPersistenceCapable
implements PersistenceCapable,
ManagedInstanceProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    private Object o;
    private StateManager sm;
    private transient PersistenceCapable pcSubclassInstance;
    private transient ClassMetaData meta;
    private boolean serializationUserVisible = true;

    public ReflectingPersistenceCapable(Object o, OpenJPAConfiguration conf) {
        this.o = o;
        Class<?> type = o.getClass();
        this.pcSubclassInstance = PCRegistry.newInstance(type, null, false);
        this.meta = conf.getMetaDataRepositoryInstance().getMetaData(type, null, true);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return PCEnhancer.ENHANCER_VERSION;
    }

    @Override
    public Object pcGetGenericContext() {
        if (this.sm == null) {
            return null;
        }
        return this.sm.getGenericContext();
    }

    @Override
    public StateManager pcGetStateManager() {
        return this.sm;
    }

    @Override
    public void pcReplaceStateManager(StateManager sm) {
        this.sm = sm;
        if (this.meta == null && sm instanceof OpenJPAStateManager) {
            this.meta = ((OpenJPAStateManager)sm).getMetaData();
        }
    }

    @Override
    public void pcProvideField(int i) {
        Object value = this.getValue(i, this.o);
        switch (this.meta.getField(i).getDeclaredTypeCode()) {
            case 0: {
                this.sm.providedBooleanField(this, i, value == null ? false : (Boolean)value);
                break;
            }
            case 1: {
                this.sm.providedByteField(this, i, value == null ? (byte)0 : (Byte)value);
                break;
            }
            case 2: {
                this.sm.providedCharField(this, i, value == null ? (char)'\u0000' : ((Character)value).charValue());
                break;
            }
            case 3: {
                this.sm.providedDoubleField(this, i, value == null ? 0.0 : (Double)value);
                break;
            }
            case 4: {
                this.sm.providedFloatField(this, i, value == null ? 0.0f : ((Float)value).floatValue());
                break;
            }
            case 5: {
                this.sm.providedIntField(this, i, value == null ? 0 : (Integer)value);
                break;
            }
            case 6: {
                this.sm.providedLongField(this, i, value == null ? 0L : (Long)value);
                break;
            }
            case 7: {
                this.sm.providedShortField(this, i, value == null ? (short)0 : (Short)value);
                break;
            }
            case 9: {
                this.sm.providedStringField(this, i, (String)value);
                break;
            }
            default: {
                this.sm.providedObjectField(this, i, value);
            }
        }
    }

    @Override
    public void pcProvideFields(int[] fieldIndices) {
        for (int fieldIndex : fieldIndices) {
            this.pcProvideField(fieldIndex);
        }
    }

    @Override
    public void pcReplaceField(int i) {
        switch (this.meta.getField(i).getDeclaredTypeCode()) {
            case 0: {
                this.setValue(i, this.o, this.sm.replaceBooleanField(this, i));
                break;
            }
            case 1: {
                this.setValue(i, this.o, this.sm.replaceByteField(this, i));
                break;
            }
            case 2: {
                this.setValue(i, this.o, Character.valueOf(this.sm.replaceCharField(this, i)));
                break;
            }
            case 3: {
                this.setValue(i, this.o, this.sm.replaceDoubleField(this, i));
                break;
            }
            case 4: {
                this.setValue(i, this.o, Float.valueOf(this.sm.replaceFloatField(this, i)));
                break;
            }
            case 5: {
                this.setValue(i, this.o, this.sm.replaceIntField(this, i));
                break;
            }
            case 6: {
                this.setValue(i, this.o, this.sm.replaceLongField(this, i));
                break;
            }
            case 7: {
                this.setValue(i, this.o, this.sm.replaceShortField(this, i));
                break;
            }
            case 9: {
                this.setValue(i, this.o, this.sm.replaceStringField(this, i));
                break;
            }
            default: {
                this.setValue(i, this.o, this.sm.replaceObjectField(this, i));
            }
        }
    }

    @Override
    public void pcReplaceFields(int[] fieldIndices) {
        for (int fieldIndex : fieldIndices) {
            this.pcReplaceField(fieldIndex);
        }
    }

    public void pcCopyField(Object fromObject, int i) {
        this.setValue(i, this.o, this.getValue(i, fromObject));
    }

    @Override
    public void pcCopyFields(Object fromObject, int[] fieldIndices) {
        if (fromObject instanceof ReflectingPersistenceCapable) {
            fromObject = ((ReflectingPersistenceCapable)fromObject).getManagedInstance();
        }
        for (int fieldIndex : fieldIndices) {
            this.pcCopyField(fromObject, fieldIndex);
        }
    }

    @Override
    public void pcDirty(String fieldName) {
        if (this.sm != null) {
            this.sm.dirty(fieldName);
        }
    }

    @Override
    public Object pcFetchObjectId() {
        if (this.sm != null) {
            return this.sm.fetchObjectId();
        }
        return null;
    }

    @Override
    public Object pcGetVersion() {
        if (this.sm == null) {
            return null;
        }
        return this.sm.getVersion();
    }

    @Override
    public boolean pcIsDirty() {
        if (this.sm == null) {
            return false;
        }
        if (this.sm instanceof StateManagerImpl) {
            ((StateManagerImpl)this.sm).dirtyCheck();
        }
        return this.sm.isDirty();
    }

    @Override
    public boolean pcIsTransactional() {
        if (this.sm == null) {
            return false;
        }
        return this.sm.isTransactional();
    }

    @Override
    public boolean pcIsPersistent() {
        if (this.sm == null) {
            return false;
        }
        return this.sm.isPersistent();
    }

    @Override
    public boolean pcIsNew() {
        if (this.sm == null) {
            return false;
        }
        return this.sm.isNew();
    }

    @Override
    public boolean pcIsDeleted() {
        if (this.sm == null) {
            return false;
        }
        return this.sm.isDeleted();
    }

    @Override
    public Boolean pcIsDetached() {
        if (this.sm != null) {
            return this.sm.isDetached();
        }
        return null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager sm, boolean clear) {
        return this.pcSubclassInstance.pcNewInstance(sm, clear);
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager sm, Object oid, boolean clear) {
        return this.pcSubclassInstance.pcNewInstance(sm, oid, clear);
    }

    @Override
    public Object pcNewObjectIdInstance() {
        FieldMetaData[] pkFields = this.meta.getPrimaryKeyFields();
        Object[] pks = new Object[pkFields.length];
        for (int i = 0; i < pkFields.length; ++i) {
            pks[i] = this.getValue(pkFields[i].getIndex(), this.o);
        }
        return ApplicationIds.fromPKValues(pks, this.meta);
    }

    @Override
    public Object pcNewObjectIdInstance(Object oid) {
        return this.pcSubclassInstance.pcNewObjectIdInstance(oid);
    }

    @Override
    public void pcCopyKeyFieldsToObjectId(Object oid) {
        FieldMetaData[] pks;
        Object target = oid instanceof ObjectId ? ((ObjectId)oid).getId() : oid;
        for (FieldMetaData pk : pks = this.meta.getPrimaryKeyFields()) {
            Object val = this.getValue(pk.getIndex(), this.o);
            Field f = Reflection.findField(target.getClass(), pk.getName(), true);
            Reflection.set(target, f, val);
        }
    }

    @Override
    public void pcCopyKeyFieldsToObjectId(FieldSupplier supplier, Object obj) {
        throw new InternalException();
    }

    @Override
    public void pcCopyKeyFieldsFromObjectId(FieldConsumer consumer, Object obj) {
        throw new InternalException();
    }

    @Override
    public Object pcGetDetachedState() {
        return null;
    }

    @Override
    public void pcSetDetachedState(Object state) {
        if (state != null) {
            throw new UnsupportedOperationException();
        }
    }

    public void pcSetSerializationUserVisible(boolean userVisible) {
        this.serializationUserVisible = userVisible;
    }

    public boolean pcIsSerializationUserVisible() {
        return this.serializationUserVisible;
    }

    @Override
    public Object getManagedInstance() {
        return this.o;
    }

    private Object getValue(int i, Object o) {
        FieldMetaData fmd = this.meta.getField(i);
        if (AccessCode.isProperty(fmd.getAccessType())) {
            Field field = Reflection.findField(this.meta.getDescribedType(), this.toFieldName(i), true);
            return Reflection.get(o, field);
        }
        Field field = (Field)this.meta.getField(i).getBackingMember();
        return Reflection.get(o, field);
    }

    private String toFieldName(int i) {
        if (this.pcSubclassInstance instanceof AttributeTranslator) {
            return ((AttributeTranslator)((Object)this.pcSubclassInstance)).pcAttributeIndexToFieldName(i);
        }
        return this.meta.getField(i).getName();
    }

    private void setValue(int i, Object o, Object val) {
        FieldMetaData fmd = this.meta.getField(i);
        if (AccessCode.isProperty(fmd.getAccessType())) {
            if (!this.meta.isIntercepting()) {
                Method meth = Reflection.findSetter(this.meta.getDescribedType(), this.meta.getField(i).getName(), true);
                Reflection.set(o, meth, val);
            } else {
                Field field = Reflection.findField(this.meta.getDescribedType(), this.toFieldName(i), true);
                Reflection.set(o, field, val);
            }
        } else {
            Field field = (Field)this.meta.getField(i).getBackingMember();
            Reflection.set(o, field, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.meta.getDescribedType());
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        Class type = (Class)in.readObject();
        this.pcSubclassInstance = PCRegistry.newInstance(type, null, false);
        ImplHelper.registerPersistenceCapable(this);
    }
}

