/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons;

import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.syncope.client.lib.SyncopeAnonymousClient;
import org.apache.syncope.client.ui.commons.DateOps;

public interface BaseSession {
    public void setDomain(String var1);

    public String getDomain();

    public String getJWT();

    public SyncopeAnonymousClient getAnonymousClient();

    public <T> T getAnonymousService(Class<T> var1);

    public <T> T getService(Class<T> var1);

    public <T> T getService(String var1, Class<T> var2);

    public <T> void resetClient(Class<T> var1);

    public DateOps.Format getDateFormat();

    public void onException(Exception var1);

    public <T> Future<T> execute(Callable<T> var1);

    default public List<Locale> getSupportedLocales() {
        return List.of(Locale.ENGLISH, Locale.CANADA_FRENCH, Locale.ITALIAN, Locale.JAPANESE, new Locale("pt", "BR"), new Locale("ru"));
    }

    public static enum Error {
        SESSION_EXPIRED("error.session.expired", "Session expired: please login again"),
        AUTHORIZATION("error.authorization", "Insufficient access rights when performing the requested operation"),
        REST("error.rest", "There was an error while contacting the Core server");

        private final String key;
        private final String fallback;

        private Error(String key, String fallback) {
            this.key = key;
            this.fallback = fallback;
        }

        public String key() {
            return this.key;
        }

        public String fallback() {
            return this.fallback;
        }
    }
}

