/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.BaseBean;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.UserRequestFormProperty;
import org.apache.syncope.common.lib.to.UserTO;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="_class")
@JsonPropertyOrder(value={"_class", "bpmnProcess"})
public class UserRequestForm
implements BaseBean {
    private static final long serialVersionUID = -7044543391316529128L;
    @JacksonXmlProperty(localName="_class", isAttribute=true)
    @JsonProperty(value="_class")
    private final String clazz = "org.apache.syncope.common.lib.to.UserRequestForm";
    private String bpmnProcess;
    private String username;
    private String executionId;
    private String taskId;
    private String formKey;
    private Date createTime;
    private Date dueDate;
    private String assignee;
    private UserTO userTO;
    private UserUR userUR;
    private final List<UserRequestFormProperty> properties = new ArrayList<UserRequestFormProperty>();

    public String getBpmnProcess() {
        return this.bpmnProcess;
    }

    public void setBpmnProcess(String bpmnProcess) {
        this.bpmnProcess = bpmnProcess;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    public Date getCreateTime() {
        return Optional.ofNullable(this.createTime).map(date -> new Date(date.getTime())).orElse(null);
    }

    public void setCreateTime(Date createTime) {
        this.createTime = Optional.ofNullable(createTime).map(date -> new Date(date.getTime())).orElse(null);
    }

    public Date getDueDate() {
        return Optional.ofNullable(this.dueDate).map(date -> new Date(date.getTime())).orElse(null);
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = Optional.ofNullable(dueDate).map(date -> new Date(date.getTime())).orElse(null);
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public UserTO getUserTO() {
        return this.userTO;
    }

    public void setUserTO(UserTO userTO) {
        this.userTO = userTO;
    }

    public UserUR getUserUR() {
        return this.userUR;
    }

    public void setUserUR(UserUR userUR) {
        this.userUR = userUR;
    }

    @JsonIgnore
    public Optional<UserRequestFormProperty> getProperty(String id) {
        return this.properties.stream().filter(property -> id.equals(property.getId())).findFirst();
    }

    @JacksonXmlElementWrapper(localName="properties")
    @JacksonXmlProperty(localName="property")
    public List<UserRequestFormProperty> getProperties() {
        return this.properties;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.bpmnProcess).append((Object)this.username).append((Object)this.executionId).append((Object)this.taskId).append((Object)this.formKey).append((Object)this.createTime).append((Object)this.dueDate).append((Object)this.assignee).append((Object)this.userTO).append((Object)this.userUR).append(this.properties).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserRequestForm other = (UserRequestForm)obj;
        return new EqualsBuilder().append((Object)this.bpmnProcess, (Object)other.bpmnProcess).append((Object)this.username, (Object)other.username).append((Object)this.executionId, (Object)other.executionId).append((Object)this.taskId, (Object)other.taskId).append((Object)this.formKey, (Object)other.formKey).append((Object)this.createTime, (Object)other.createTime).append((Object)this.dueDate, (Object)other.dueDate).append((Object)this.assignee, (Object)other.assignee).append((Object)this.userTO, (Object)other.userTO).append((Object)this.userUR, (Object)other.userUR).append(this.properties, other.properties).build();
    }
}

