/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public final class URIUtils {
    private URIUtils() {
    }

    public static URI buildForConnId(String location) throws MalformedURLException, URISyntaxException {
        String candidate = location.trim();
        if (!(candidate.startsWith("file:") || candidate.startsWith("connid:") || candidate.startsWith("connids:"))) {
            throw new IllegalArgumentException(candidate + " is not a valid URI for file or connid(s) schemes");
        }
        URI uri = candidate.startsWith("file:") ? new File(new URL(candidate).getFile()).getAbsoluteFile().toURI() : new URI(candidate);
        return uri;
    }
}

