/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.MacroTaskTO;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.to.TaskTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.lib.types.JobType;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.rest.api.batch.BatchResponseItem;
import org.apache.syncope.core.logic.AbstractExecutableLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.JobStatusDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.TaskExecDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Notification;
import org.apache.syncope.core.persistence.api.entity.task.MacroTask;
import org.apache.syncope.core.persistence.api.entity.task.NotificationTask;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtils;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.provisioning.api.data.TaskDataBinder;
import org.apache.syncope.core.provisioning.api.job.JobManager;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.apache.syncope.core.provisioning.api.notification.NotificationJobDelegate;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.provisioning.api.utils.ExceptionUtils2;
import org.apache.syncope.core.provisioning.java.propagation.DefaultPropagationReporter;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.quartz.JobDataMap;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class TaskLogic
extends AbstractExecutableLogic<TaskTO> {
    protected final TaskDAO taskDAO;
    protected final TaskExecDAO taskExecDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final NotificationDAO notificationDAO;
    protected final TaskDataBinder binder;
    protected final PropagationTaskExecutor taskExecutor;
    protected final NotificationJobDelegate notificationJobDelegate;
    protected final TaskUtilsFactory taskUtilsFactory;

    public TaskLogic(JobManager jobManager, SchedulerFactoryBean scheduler, JobStatusDAO jobStatusDAO, TaskDAO taskDAO, TaskExecDAO taskExecDAO, ExternalResourceDAO resourceDAO, NotificationDAO notificationDAO, TaskDataBinder binder, PropagationTaskExecutor taskExecutor, NotificationJobDelegate notificationJobDelegate, TaskUtilsFactory taskUtilsFactory) {
        super(jobManager, scheduler, jobStatusDAO);
        this.taskDAO = taskDAO;
        this.taskExecDAO = taskExecDAO;
        this.resourceDAO = resourceDAO;
        this.notificationDAO = notificationDAO;
        this.binder = binder;
        this.taskExecutor = taskExecutor;
        this.notificationJobDelegate = notificationJobDelegate;
        this.taskUtilsFactory = taskUtilsFactory;
    }

    protected void securityChecks(String entitlement, String realm) {
        Set authRealms = (Set)AuthContextUtils.getAuthorizations().get(entitlement);
        if (authRealms.stream().noneMatch(r -> realm.startsWith((String)r))) {
            throw new DelegatedAdministrationException(realm, MacroTask.class.getSimpleName(), null);
        }
    }

    @PreAuthorize(value="hasRole('TASK_CREATE')")
    public <T extends SchedTaskTO> T createSchedTask(TaskType type, T taskTO) {
        TaskUtils taskUtils = this.taskUtilsFactory.getInstance(taskTO);
        if (taskUtils.getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + type + ", expected " + taskUtils.getType());
            throw sce;
        }
        if (taskUtils.getType() == TaskType.MACRO) {
            this.securityChecks("TASK_CREATE", ((MacroTaskTO)taskTO).getRealm());
        }
        SchedTask task = this.binder.createSchedTask(taskTO, taskUtils);
        task = (SchedTask)this.taskDAO.save((Task)task);
        try {
            this.jobManager.register(task, task.getStartAt(), AuthContextUtils.getUsername());
        }
        catch (Exception e) {
            LOG.error("While registering quartz job for task " + task.getKey(), (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return (T)((SchedTaskTO)this.binder.getTaskTO((Task)task, taskUtils, false));
    }

    @PreAuthorize(value="hasRole('TASK_UPDATE')")
    public <T extends SchedTaskTO> T updateSchedTask(TaskType type, SchedTaskTO taskTO) {
        SchedTask task = (SchedTask)this.taskDAO.find(type, taskTO.getKey());
        if (task == null) {
            throw new NotFoundException("Task " + taskTO.getKey());
        }
        TaskUtils taskUtils = this.taskUtilsFactory.getInstance((Task)task);
        if (taskUtils.getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + type + ", expected " + taskUtils.getType());
            throw sce;
        }
        if (taskUtils.getType() == TaskType.MACRO) {
            this.securityChecks("TASK_UPDATE", ((MacroTask)task).getRealm().getFullPath());
            this.securityChecks("TASK_UPDATE", ((MacroTaskTO)taskTO).getRealm());
        }
        this.binder.updateSchedTask(task, taskTO, taskUtils);
        task = (SchedTask)this.taskDAO.save((Task)task);
        try {
            this.jobManager.register(task, task.getStartAt(), AuthContextUtils.getUsername());
        }
        catch (Exception e) {
            LOG.error("While registering quartz job for task " + task.getKey(), (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return (T)((SchedTaskTO)this.binder.getTaskTO((Task)task, taskUtils, false));
    }

    @PreAuthorize(value="hasRole('TASK_LIST')")
    @Transactional(readOnly=true)
    public <T extends TaskTO> Pair<Integer, List<T>> search(TaskType type, String resource, String notification, AnyTypeKind anyTypeKind, String entityKey, int page, int size, List<OrderByClause> orderByClauses, boolean details) {
        try {
            if (type == null) {
                throw new IllegalArgumentException("type is required");
            }
            ExternalResource resourceObj = this.resourceDAO.find(resource);
            if (resource != null && resourceObj == null) {
                throw new IllegalArgumentException("Missing External Resource: " + resource);
            }
            Notification notificationObj = this.notificationDAO.find(notification);
            if (notification != null && notificationObj == null) {
                throw new IllegalArgumentException("Missing Notification: " + notification);
            }
            int count = this.taskDAO.count(type, resourceObj, notificationObj, anyTypeKind, entityKey);
            List result = this.taskDAO.findAll(type, resourceObj, notificationObj, anyTypeKind, entityKey, page, size, orderByClauses).stream().map(task -> this.binder.getTaskTO(task, this.taskUtilsFactory.getInstance(type), details)).collect(Collectors.toList());
            return Pair.of((Object)count, result);
        }
        catch (IllegalArgumentException | InvalidDataAccessApiUsageException e) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
    }

    @PreAuthorize(value="hasRole('TASK_READ')")
    @Transactional(readOnly=true)
    public <T extends TaskTO> T read(TaskType type, String key, boolean details) {
        Task task = this.taskDAO.find(type, key);
        if (task == null) {
            throw new NotFoundException("Task " + key);
        }
        TaskUtils taskUtils = this.taskUtilsFactory.getInstance(task);
        if (type != null && taskUtils.getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + type + ", expected " + taskUtils.getType());
            throw sce;
        }
        if (taskUtils.getType() == TaskType.MACRO) {
            this.securityChecks("TASK_READ", ((MacroTask)task).getRealm().getFullPath());
        }
        return (T)this.binder.getTaskTO(task, this.taskUtilsFactory.getInstance(task), details);
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    public ExecTO execute(String key, OffsetDateTime startAt, boolean dryRun) {
        Task task = (Task)this.taskDAO.find(key).orElseThrow(() -> new NotFoundException("Task " + key));
        if (startAt != null && startAt.isBefore(OffsetDateTime.now())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add("Cannot schedule in the past");
            throw sce;
        }
        TaskUtils taskUtils = this.taskUtilsFactory.getInstance(task);
        String executor = AuthContextUtils.getUsername();
        ExecTO result = null;
        switch (taskUtils.getType()) {
            case PROPAGATION: {
                PropagationTask propagationTask = (PropagationTask)task;
                PropagationTaskInfo taskInfo = new PropagationTaskInfo(propagationTask.getResource(), propagationTask.getOperation(), new ObjectClass(propagationTask.getObjectClassName()), propagationTask.getAnyTypeKind(), propagationTask.getAnyType(), propagationTask.getEntityKey(), propagationTask.getConnObjectKey(), propagationTask.getPropagationData());
                taskInfo.setKey(propagationTask.getKey());
                taskInfo.setOldConnObjectKey(propagationTask.getOldConnObjectKey());
                TaskExec propExec = this.taskExecutor.execute(taskInfo, (PropagationReporter)new DefaultPropagationReporter(), executor);
                result = this.binder.getExecTO(propExec);
                break;
            }
            case NOTIFICATION: {
                TaskExec notExec = this.notificationJobDelegate.executeSingle((NotificationTask)task, executor);
                result = this.binder.getExecTO(notExec);
                break;
            }
            case SCHEDULED: 
            case PULL: 
            case PUSH: 
            case MACRO: {
                if (taskUtils.getType() == TaskType.MACRO) {
                    this.securityChecks("TASK_EXECUTE", ((MacroTask)task).getRealm().getFullPath());
                }
                if (!((SchedTask)task).isActive()) {
                    SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
                    sce.getElements().add("Task " + key + " is not active");
                    throw sce;
                }
                try {
                    Map jobDataMap = this.jobManager.register((SchedTask)task, startAt, executor);
                    jobDataMap.put("dryRun", dryRun);
                    if (startAt == null) {
                        this.scheduler.getScheduler().triggerJob(JobNamer.getJobKey((Task)task), new JobDataMap(jobDataMap));
                    }
                }
                catch (Exception e) {
                    LOG.error("While executing task {}", (Object)task, (Object)e);
                    SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
                    sce.getElements().add(e.getMessage());
                    throw sce;
                }
                result = new ExecTO();
                result.setJobType(JobType.TASK);
                result.setRefKey(task.getKey());
                result.setRefDesc(this.binder.buildRefDesc(task));
                result.setStart(OffsetDateTime.now());
                result.setExecutor(executor);
                result.setStatus("JOB_FIRED");
                result.setMessage("Job fired; waiting for results...");
                break;
            }
        }
        return result;
    }

    @PreAuthorize(value="hasRole('TASK_DELETE')")
    public <T extends TaskTO> T delete(TaskType type, String key) {
        Task task = this.taskDAO.find(type, key);
        if (task == null) {
            throw new NotFoundException("Task " + key);
        }
        TaskUtils taskUtils = this.taskUtilsFactory.getInstance(task);
        if (type != null && taskUtils.getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + type + ", expected " + taskUtils.getType());
            throw sce;
        }
        if (taskUtils.getType() == TaskType.MACRO) {
            this.securityChecks("TASK_DELETE", ((MacroTask)task).getRealm().getFullPath());
        }
        TaskTO taskToDelete = this.binder.getTaskTO(task, taskUtils, true);
        if (TaskType.SCHEDULED == taskUtils.getType() || TaskType.PULL == taskUtils.getType() || TaskType.PUSH == taskUtils.getType()) {
            this.jobManager.unregister(task);
        }
        this.taskDAO.delete(task);
        return (T)taskToDelete;
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_READ')")
    public Pair<Integer, List<ExecTO>> listExecutions(String key, OffsetDateTime before, OffsetDateTime after, int page, int size, List<OrderByClause> orderByClauses) {
        Task task = (Task)this.taskDAO.find(key).orElseThrow(() -> new NotFoundException("Task " + key));
        if (task instanceof MacroTask) {
            this.securityChecks("TASK_READ", ((MacroTask)task).getRealm().getFullPath());
        }
        Integer count = this.taskExecDAO.count(task, before, after);
        List result = this.taskExecDAO.findAll(task, before, after, page, size, orderByClauses).stream().map(exec -> this.binder.getExecTO(exec)).collect(Collectors.toList());
        return Pair.of((Object)count, result);
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_LIST')")
    public List<ExecTO> listRecentExecutions(int max) {
        return this.taskExecDAO.findRecent(max).stream().map(exec -> {
            try {
                if (exec.getTask() instanceof MacroTask) {
                    this.securityChecks("TASK_DELETE", ((MacroTask)exec.getTask()).getRealm().getFullPath());
                }
                return this.binder.getExecTO(exec);
            }
            catch (DelegatedAdministrationException e) {
                LOG.error("Skip executions for command task", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_DELETE')")
    public ExecTO deleteExecution(String execKey) {
        TaskExec exec = (TaskExec)this.taskExecDAO.find(execKey).orElseThrow(() -> new NotFoundException("Task execution " + execKey));
        if (exec.getTask() instanceof MacroTask) {
            this.securityChecks("TASK_DELETE", ((MacroTask)exec.getTask()).getRealm().getFullPath());
        }
        ExecTO executionToDelete = this.binder.getExecTO(exec);
        this.taskExecDAO.delete(exec);
        return executionToDelete;
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_DELETE')")
    public List<BatchResponseItem> deleteExecutions(String key, OffsetDateTime before, OffsetDateTime after) {
        Task task = (Task)this.taskDAO.find(key).orElseThrow(() -> new NotFoundException("Task " + key));
        ArrayList<BatchResponseItem> batchResponseItems = new ArrayList<BatchResponseItem>();
        this.taskExecDAO.findAll(task, before, after, -1, -1, List.of()).forEach(exec -> {
            BatchResponseItem item = new BatchResponseItem();
            item.getHeaders().put("X-Syncope-Key", List.of(exec.getKey()));
            batchResponseItems.add(item);
            try {
                if (exec.getTask() instanceof MacroTask) {
                    this.securityChecks("TASK_DELETE", ((MacroTask)exec.getTask()).getRealm().getFullPath());
                }
                this.taskExecDAO.delete(exec);
                item.setStatus(Response.Status.OK.getStatusCode());
            }
            catch (Exception e) {
                LOG.error("Error deleting execution {} of task {}", new Object[]{exec.getKey(), key, e});
                item.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
                item.setContent(ExceptionUtils2.getFullStackTrace((Throwable)e));
            }
        });
        return batchResponseItems;
    }

    @Override
    protected Triple<JobType, String, String> getReference(JobKey jobKey) {
        String key = JobNamer.getTaskKeyFromJobName((String)jobKey.getName());
        Task task = this.taskDAO.find(key).orElse(null);
        return task == null || !(task instanceof SchedTask) ? null : Triple.of((Object)JobType.TASK, (Object)key, (Object)this.binder.buildRefDesc(task));
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_LIST')")
    public List<JobTO> listJobs() {
        return super.doListJobs(true);
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_READ')")
    public JobTO getJob(String key) {
        Task task = (Task)this.taskDAO.find(key).orElseThrow(() -> new NotFoundException("Task " + key));
        if (task instanceof MacroTask) {
            this.securityChecks("TASK_READ", ((MacroTask)task).getRealm().getFullPath());
        }
        JobTO jobTO = null;
        try {
            jobTO = this.getJobTO(JobNamer.getJobKey((Task)task), false);
        }
        catch (SchedulerException e) {
            LOG.error("Problems while retrieving scheduled job {}", (Object)JobNamer.getJobKey((Task)task), (Object)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        if (jobTO == null) {
            throw new NotFoundException("Job for task " + key);
        }
        return jobTO;
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    public void actionJob(String key, JobAction action) {
        Task task = (Task)this.taskDAO.find(key).orElseThrow(() -> new NotFoundException("Task " + key));
        if (task instanceof MacroTask) {
            this.securityChecks("TASK_EXECUTE", ((MacroTask)task).getRealm().getFullPath());
        }
        this.doActionJob(JobNamer.getJobKey((Task)task), action);
    }

    @PreAuthorize(value="hasRole('TASK_DELETE')")
    public List<PropagationTaskTO> purgePropagations(OffsetDateTime since, List<ExecStatus> statuses, List<String> resources) {
        return this.taskDAO.purgePropagations(since, statuses, (List)Optional.ofNullable(resources).map(r -> r.stream().map(arg_0 -> ((ExternalResourceDAO)this.resourceDAO).find(arg_0)).filter(Objects::nonNull).collect(Collectors.toList())).orElse(null));
    }

    @Override
    protected TaskTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args) && !"deleteExecution".equals(method.getName()) && !"readExecution".equals(method.getName())) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof TaskTO)) continue;
                key = ((TaskTO)args[i]).getKey();
            }
        }
        if (key != null) {
            String taskKey = key;
            try {
                Task task = (Task)this.taskDAO.find(taskKey).orElseThrow(() -> new NotFoundException("Task " + taskKey));
                return this.binder.getTaskTO(task, this.taskUtilsFactory.getInstance(task), false);
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

