/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.starter.actuate;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.lib.info.JavaImplInfo;
import org.apache.syncope.common.lib.info.NumbersInfo;
import org.apache.syncope.common.lib.info.PlatformInfo;
import org.apache.syncope.common.lib.info.SystemInfo;
import org.apache.syncope.common.lib.types.EntitlementsHolder;
import org.apache.syncope.common.lib.types.ImplementationTypesHolder;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.dao.PersistenceInfoDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.SecurityQuestionDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.provisioning.api.ConnIdBundleManager;
import org.apache.syncope.core.provisioning.api.ImplementationLookup;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.starter.actuate.SyncopeCoreInfoContributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.transaction.annotation.Transactional;

public class DefaultSyncopeCoreInfoContributor
implements SyncopeCoreInfoContributor,
InfoContributor {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultSyncopeCoreInfoContributor.class);
    protected static final Object MONITOR = new Object();
    protected static PlatformInfo PLATFORM_INFO;
    protected static SystemInfo SYSTEM_INFO;
    protected static final Pattern THREADPOOLTASKEXECUTOR_PATTERN;
    protected final AnyTypeDAO anyTypeDAO;
    protected final AnyTypeClassDAO anyTypeClassDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final AnyObjectDAO anyObjectDAO;
    protected final RoleDAO roleDAO;
    protected final PolicyDAO policyDAO;
    protected final TaskDAO taskDAO;
    protected final VirSchemaDAO virSchemaDAO;
    protected final SecurityQuestionDAO securityQuestionDAO;
    protected final NotificationDAO notificationDAO;
    protected final ConfParamOps confParamOps;
    protected final ConnIdBundleManager bundleManager;
    protected final ImplementationLookup implLookup;
    protected final Map<String, ThreadPoolTaskExecutor> taskExecutors;
    protected final PersistenceInfoDAO persistenceInfoDAO;

    protected static NumbersInfo.TaskExecutorInfo getTaskExecutorInfo(String toString) {
        NumbersInfo.TaskExecutorInfo info = new NumbersInfo.TaskExecutorInfo();
        Matcher matcher = THREADPOOLTASKEXECUTOR_PATTERN.matcher(toString);
        if (matcher.matches() && matcher.groupCount() == 4) {
            try {
                info.setSize(Integer.parseInt(matcher.group(1)));
            }
            catch (NumberFormatException e) {
                LOG.error("While parsing thread pool size", (Throwable)e);
            }
            try {
                info.setActive(Integer.parseInt(matcher.group(2)));
            }
            catch (NumberFormatException e) {
                LOG.error("While parsing active threads #", (Throwable)e);
            }
            try {
                info.setQueued(Integer.parseInt(matcher.group(3)));
            }
            catch (NumberFormatException e) {
                LOG.error("While parsing queued threads #", (Throwable)e);
            }
            try {
                info.setCompleted(Integer.parseInt(matcher.group(4)));
            }
            catch (NumberFormatException e) {
                LOG.error("While parsing completed threads #", (Throwable)e);
            }
        }
        return info;
    }

    protected static void initSystemInfo() {
        if (SYSTEM_INFO == null) {
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            SYSTEM_INFO = new SystemInfo();
            try {
                SYSTEM_INFO.setHostname(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                LOG.error("Could not get host name", (Throwable)e);
            }
            SYSTEM_INFO.setOs(operatingSystemMXBean.getName() + " " + operatingSystemMXBean.getVersion() + " " + operatingSystemMXBean.getArch());
            SYSTEM_INFO.setAvailableProcessors(operatingSystemMXBean.getAvailableProcessors());
            SYSTEM_INFO.setJvm(runtimeMXBean.getVmName() + " " + System.getProperty("java.version") + " " + runtimeMXBean.getVmVendor());
            SYSTEM_INFO.setStartTime(runtimeMXBean.getStartTime());
        }
    }

    public DefaultSyncopeCoreInfoContributor(AnyTypeDAO anyTypeDAO, AnyTypeClassDAO anyTypeClassDAO, ExternalResourceDAO resourceDAO, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, RoleDAO roleDAO, PolicyDAO policyDAO, NotificationDAO notificationDAO, TaskDAO taskDAO, VirSchemaDAO virSchemaDAO, SecurityQuestionDAO securityQuestionDAO, ConfParamOps confParamOps, ConnIdBundleManager bundleManager, ImplementationLookup implLookup, Map<String, ThreadPoolTaskExecutor> taskExecutors, PersistenceInfoDAO persistenceInfoDAO) {
        this.anyTypeDAO = anyTypeDAO;
        this.anyTypeClassDAO = anyTypeClassDAO;
        this.resourceDAO = resourceDAO;
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.roleDAO = roleDAO;
        this.policyDAO = policyDAO;
        this.notificationDAO = notificationDAO;
        this.taskDAO = taskDAO;
        this.virSchemaDAO = virSchemaDAO;
        this.securityQuestionDAO = securityQuestionDAO;
        this.confParamOps = confParamOps;
        this.bundleManager = bundleManager;
        this.implLookup = implLookup;
        this.taskExecutors = taskExecutors;
        this.persistenceInfoDAO = persistenceInfoDAO;
    }

    protected boolean isSelfRegAllowed() {
        return (Boolean)this.confParamOps.get(AuthContextUtils.getDomain(), "selfRegistration.allowed", (Object)false, Boolean.class);
    }

    protected boolean isPwdResetAllowed() {
        return (Boolean)this.confParamOps.get(AuthContextUtils.getDomain(), "passwordReset.allowed", (Object)false, Boolean.class);
    }

    protected boolean isPwdResetRequiringSecurityQuestions() {
        return (Boolean)this.confParamOps.get(AuthContextUtils.getDomain(), "passwordReset.securityQuestion", (Object)true, Boolean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildPlatform() {
        DefaultSyncopeCoreInfoContributor defaultSyncopeCoreInfoContributor = this;
        synchronized (defaultSyncopeCoreInfoContributor) {
            if (PLATFORM_INFO == null) {
                PLATFORM_INFO = new PlatformInfo();
                PLATFORM_INFO.getConnIdLocations().addAll(this.bundleManager.getLocations().stream().map(URI::toASCIIString).collect(Collectors.toList()));
                ImplementationTypesHolder.getInstance().getValues().forEach((typeName, typeInterface) -> {
                    Set classNames = this.implLookup.getClassNames(typeName);
                    if (classNames != null) {
                        JavaImplInfo javaImplInfo = new JavaImplInfo();
                        javaImplInfo.setType(typeName);
                        javaImplInfo.getClasses().addAll(classNames);
                        PLATFORM_INFO.getJavaImplInfos().add(javaImplInfo);
                    }
                });
            }
            PLATFORM_INFO.setSelfRegAllowed(this.isSelfRegAllowed());
            PLATFORM_INFO.setPwdResetAllowed(this.isPwdResetAllowed());
            PLATFORM_INFO.setPwdResetRequiringSecurityQuestions(this.isPwdResetRequiringSecurityQuestions());
            PLATFORM_INFO.getEntitlements().clear();
            PLATFORM_INFO.getEntitlements().addAll(EntitlementsHolder.getInstance().getValues());
            PLATFORM_INFO.getImplementationTypes().clear();
            PLATFORM_INFO.getImplementationTypes().addAll(ImplementationTypesHolder.getInstance().getValues().keySet());
            AuthContextUtils.callAsAdmin((String)AuthContextUtils.getDomain(), () -> {
                PLATFORM_INFO.getAnyTypes().clear();
                PLATFORM_INFO.getAnyTypes().addAll(this.anyTypeDAO.findAll().stream().map(Entity::getKey).collect(Collectors.toList()));
                PLATFORM_INFO.getUserClasses().clear();
                PLATFORM_INFO.getUserClasses().addAll(this.anyTypeDAO.findUser().getClasses().stream().map(Entity::getKey).collect(Collectors.toList()));
                PLATFORM_INFO.getAnyTypeClasses().clear();
                PLATFORM_INFO.getAnyTypeClasses().addAll(this.anyTypeClassDAO.findAll().stream().map(Entity::getKey).collect(Collectors.toList()));
                PLATFORM_INFO.getResources().clear();
                PLATFORM_INFO.getResources().addAll(this.resourceDAO.findAll().stream().map(Entity::getKey).collect(Collectors.toList()));
                return null;
            });
        }
    }

    protected NumbersInfo buildNumbers() {
        NumbersInfo numbersInfo = new NumbersInfo();
        numbersInfo.setTotalUsers(this.userDAO.count());
        numbersInfo.getUsersByRealm().putAll(this.userDAO.countByRealm());
        numbersInfo.getUsersByStatus().putAll(this.userDAO.countByStatus());
        numbersInfo.setTotalGroups(this.groupDAO.count());
        numbersInfo.getGroupsByRealm().putAll(this.groupDAO.countByRealm());
        Map anyObjectNumbers = this.anyObjectDAO.countByType();
        Iterator itor = anyObjectNumbers.entrySet().iterator();
        for (int i = 0; i < 2 && itor.hasNext(); ++i) {
            Map.Entry entry = itor.next();
            if (i == 0) {
                numbersInfo.setAnyType1(((AnyType)entry.getKey()).getKey());
                numbersInfo.setTotalAny1((Integer)entry.getValue());
                numbersInfo.getAny1ByRealm().putAll(this.anyObjectDAO.countByRealm((AnyType)entry.getKey()));
                continue;
            }
            numbersInfo.setAnyType2(((AnyType)entry.getKey()).getKey());
            numbersInfo.setTotalAny2((Integer)entry.getValue());
            numbersInfo.getAny2ByRealm().putAll(this.anyObjectDAO.countByRealm((AnyType)entry.getKey()));
        }
        numbersInfo.setTotalResources(this.resourceDAO.count());
        numbersInfo.setTotalRoles(this.roleDAO.count());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.RESOURCE.name(), numbersInfo.getTotalResources() > 0);
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.ACCOUNT_POLICY.name(), !this.policyDAO.find(AccountPolicy.class).isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.PASSWORD_POLICY.name(), !this.policyDAO.find(PasswordPolicy.class).isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.NOTIFICATION.name(), !this.notificationDAO.findAll().isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.PULL_TASK.name(), !this.taskDAO.findAll(TaskType.PULL).isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.VIR_SCHEMA.name(), !this.virSchemaDAO.findAll().isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.ANY_TYPE.name(), !anyObjectNumbers.isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.SECURITY_QUESTION.name(), !this.securityQuestionDAO.findAll().isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.ROLE.name(), numbersInfo.getTotalRoles() > 0);
        this.taskExecutors.forEach((name, bean) -> numbersInfo.getTaskExecutorInfos().put(name, DefaultSyncopeCoreInfoContributor.getTaskExecutorInfo(bean.getThreadPoolExecutor().toString())));
        return numbersInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildSystem() {
        Object object = MONITOR;
        synchronized (object) {
            DefaultSyncopeCoreInfoContributor.initSystemInfo();
        }
    }

    @Transactional(readOnly=true)
    public void contribute(Info.Builder builder) {
        this.buildPlatform();
        builder.withDetail("platform", (Object)PLATFORM_INFO);
        builder.withDetail("persistence", (Object)this.persistenceInfoDAO.info());
        builder.withDetail("numbers", (Object)this.buildNumbers());
        this.buildSystem();
        builder.withDetail("system", (Object)SYSTEM_INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLoadInstant(PayloadApplicationEvent<SystemInfo.LoadInstant> event) {
        Object object = MONITOR;
        synchronized (object) {
            DefaultSyncopeCoreInfoContributor.initSystemInfo();
            SYSTEM_INFO.getLoad().add((SystemInfo.LoadInstant)event.getPayload());
        }
    }

    static {
        THREADPOOLTASKEXECUTOR_PATTERN = Pattern.compile(".*, pool size = ([0-9]+), active threads = ([0-9]+), queued tasks = ([0-9]+), completed tasks = ([0-9]+).*");
    }
}

