/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.response;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPSamlRegisteredServiceCriterion;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileBuilderContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.encoder.sso.SamlResponseArtifactEncoder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.encoder.sso.SamlResponsePostEncoder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.encoder.sso.SamlResponsePostSimpleSignEncoder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.BaseSamlProfileSamlResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.SamlProfileSamlResponseBuilderConfigurationContext;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicket;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.CookieUtils;
import org.jooq.lambda.Unchecked;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.metadata.criteria.entity.impl.EvaluableEntityRoleEntityDescriptorCriterion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlProfileSaml2ResponseBuilder
extends BaseSamlProfileSamlResponseBuilder<Response> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSaml2ResponseBuilder.class);
    private static final long serialVersionUID = 1488837627964481272L;

    public SamlProfileSaml2ResponseBuilder(SamlProfileSamlResponseBuilderConfigurationContext configurationContext) {
        super(configurationContext);
    }

    @Override
    public Response buildResponse(Assertion assertion, SamlProfileBuilderContext context) throws Exception {
        SAMLObject finalAssertion;
        String id = "_" + String.valueOf(RandomUtils.nextLong());
        Response samlResponse = this.newResponse(id, ZonedDateTime.now(ZoneOffset.UTC), context.getSamlRequest().getID(), null);
        samlResponse.setVersion(SAMLVersion.VERSION_20);
        String issuerId = (String)FunctionUtils.doIf((boolean)StringUtils.isNotBlank((CharSequence)context.getRegisteredService().getIssuerEntityId()), () -> ((SamlRegisteredService)context.getRegisteredService()).getIssuerEntityId(), (Supplier)Unchecked.supplier(() -> {
            CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EvaluableEntityRoleEntityDescriptorCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME), new SamlIdPSamlRegisteredServiceCriterion(context.getRegisteredService())});
            LOGGER.trace("Resolving entity id from SAML2 IdP metadata to determine issuer for [{}]", (Object)context.getRegisteredService().getName());
            EntityDescriptor entityDescriptor = Objects.requireNonNull((EntityDescriptor)this.getConfigurationContext().getSamlIdPMetadataResolver().resolveSingle((Object)criteriaSet));
            return entityDescriptor.getEntityID();
        })).get();
        samlResponse.setIssuer(this.buildSamlResponseIssuer(issuerId));
        Endpoint acs = SamlIdPUtils.determineEndpointForRequest((Pair)Pair.of((Object)context.getSamlRequest(), (Object)context.getMessageContext()), (SamlRegisteredServiceServiceProviderMetadataFacade)context.getAdaptor(), (String)context.getBinding());
        String location = StringUtils.isBlank((CharSequence)acs.getResponseLocation()) ? acs.getLocation() : acs.getResponseLocation();
        samlResponse.setDestination(location);
        if (this.getConfigurationContext().getCasProperties().getAuthn().getSamlIdp().getCore().isAttributeQueryProfileEnabled()) {
            this.storeAttributeQueryTicketInRegistry(assertion, context);
        }
        if ((finalAssertion = this.encryptAssertion(assertion, context)) instanceof EncryptedAssertion) {
            LOGGER.trace("Built assertion is encrypted, so the response will add it to the encrypted assertions collection");
            samlResponse.getEncryptedAssertions().add((EncryptedAssertion)EncryptedAssertion.class.cast(finalAssertion));
        } else {
            LOGGER.trace("Built assertion is not encrypted, so the response will add it to the assertions collection");
            samlResponse.getAssertions().add((Assertion)Assertion.class.cast(finalAssertion));
        }
        Status status = this.newStatus("urn:oasis:names:tc:SAML:2.0:status:Success", null);
        samlResponse.setStatus(status);
        this.openSamlConfigBean.logObject((XMLObject)samlResponse);
        if (context.getRegisteredService().getSignResponses().isTrue()) {
            LOGGER.debug("SAML entity id [{}] indicates that SAML responses should be signed", (Object)context.getAdaptor().getEntityId());
            Response samlResponseSigned = this.getConfigurationContext().getSamlObjectSigner().encode(samlResponse, context.getRegisteredService(), context.getAdaptor(), context.getHttpResponse(), context.getHttpRequest(), context.getBinding(), context.getSamlRequest(), context.getMessageContext());
            this.openSamlConfigBean.logObject((XMLObject)samlResponseSigned);
            return samlResponseSigned;
        }
        return samlResponse;
    }

    @Override
    protected Response encode(SamlProfileBuilderContext context, Response samlResponse, String relayState) throws Exception {
        LOGGER.trace("Constructing encoder based on binding [{}] for [{}]", (Object)context.getBinding(), (Object)context.getAdaptor().getEntityId());
        if (context.getBinding().equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact")) {
            SamlResponseArtifactEncoder encoder = new SamlResponseArtifactEncoder(this.getConfigurationContext().getVelocityEngineFactory(), context.getAdaptor(), context.getHttpRequest(), context.getHttpResponse(), this.getConfigurationContext().getSamlArtifactMap());
            return encoder.encode(context.getSamlRequest(), samlResponse, relayState, context.getMessageContext());
        }
        if (context.getBinding().equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign")) {
            SamlResponsePostSimpleSignEncoder encoder = new SamlResponsePostSimpleSignEncoder(this.getConfigurationContext().getVelocityEngineFactory(), context.getAdaptor(), context.getHttpResponse(), context.getHttpRequest());
            return encoder.encode(context.getSamlRequest(), samlResponse, relayState, context.getMessageContext());
        }
        SamlResponsePostEncoder encoder = new SamlResponsePostEncoder(this.getConfigurationContext().getVelocityEngineFactory(), context.getAdaptor(), context.getHttpResponse(), context.getHttpRequest());
        return encoder.encode(context.getSamlRequest(), samlResponse, relayState, context.getMessageContext());
    }

    private void storeAttributeQueryTicketInRegistry(Assertion assertion, SamlProfileBuilderContext context) throws Exception {
        Object existingQuery = context.getHttpRequest().getAttribute(AttributeQuery.class.getSimpleName());
        if (existingQuery == null) {
            String nameId = (String)context.getHttpRequest().getAttribute(NameID.class.getName());
            TicketGrantingTicket ticketGrantingTicket = CookieUtils.getTicketGrantingTicketFromRequest((CasCookieBuilder)this.getConfigurationContext().getTicketGrantingTicketCookieGenerator(), (TicketRegistry)this.getConfigurationContext().getTicketRegistry(), (HttpServletRequest)context.getHttpRequest());
            if (ticketGrantingTicket != null) {
                SamlAttributeQueryTicketFactory samlAttributeQueryTicketFactory = (SamlAttributeQueryTicketFactory)this.getConfigurationContext().getTicketFactory().get(SamlAttributeQueryTicket.class);
                SamlAttributeQueryTicket ticket = samlAttributeQueryTicketFactory.create(nameId, (SAMLObject)assertion, context.getAdaptor().getEntityId(), ticketGrantingTicket);
                this.getConfigurationContext().getTicketRegistry().addTicket((Ticket)ticket);
                context.getHttpRequest().setAttribute(SamlAttributeQueryTicket.class.getName(), (Object)ticket);
            }
        }
    }
}

