/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.user;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.SecurityQuestion;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.URelationship;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.jpa.entity.AbstractAny;
import org.apache.syncope.core.persistence.jpa.entity.AbstractGroupableRelatable;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyTypeClass;
import org.apache.syncope.core.persistence.jpa.entity.JPAExternalResource;
import org.apache.syncope.core.persistence.jpa.entity.JPARole;
import org.apache.syncope.core.persistence.jpa.entity.user.JPALinkedAccount;
import org.apache.syncope.core.persistence.jpa.entity.user.JPASecurityQuestion;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUMembership;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUPlainAttr;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAURelationship;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.Encryptor;
import org.apache.syncope.core.spring.security.SecureRandomUtils;

@Entity
@Table(name="SyncopeUser")
@Cacheable
public class JPAUser
extends AbstractGroupableRelatable<User, UMembership, UPlainAttr, AnyObject, URelationship>
implements User {
    private static final long serialVersionUID = -3905046855521446823L;
    public static final String TABLE = "SyncopeUser";
    protected static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    protected static final TypeReference<List<String>> TYPEREF = new TypeReference<List<String>>(){};
    @Column(nullable=true)
    protected String password;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="role_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"user_id", "role_id"})})
    protected List<JPARole> roles = new ArrayList<JPARole>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="owner")
    @Valid
    protected List<JPAUPlainAttr> plainAttrs = new ArrayList<JPAUPlainAttr>();
    @Column(nullable=true)
    protected String status;
    @Lob
    protected String token;
    protected OffsetDateTime tokenExpireTime;
    @Column(nullable=true)
    @Enumerated(value=EnumType.STRING)
    protected CipherAlgorithm cipherAlgorithm;
    @Lob
    protected String passwordHistory;
    @Column(nullable=true)
    protected Integer failedLogins;
    @Column(unique=true)
    @NotNull(message="Blank username")
    protected @NotNull(message="Blank username") String username;
    protected OffsetDateTime lastLoginDate;
    protected OffsetDateTime changePwdDate;
    protected Boolean suspended = false;
    protected Boolean mustChangePassword = false;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="resource_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"user_id", "resource_id"})})
    protected List<JPAExternalResource> resources = new ArrayList<JPAExternalResource>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="anyTypeClass_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"user_id", "anyTypeClass_id"})})
    protected List<JPAAnyTypeClass> auxClasses = new ArrayList<JPAAnyTypeClass>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="leftEnd")
    @Valid
    protected List<JPAURelationship> relationships = new ArrayList<JPAURelationship>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="leftEnd")
    @Valid
    protected List<JPAUMembership> memberships = new ArrayList<JPAUMembership>();
    @ManyToOne(fetch=FetchType.EAGER)
    protected JPASecurityQuestion securityQuestion;
    @Column(nullable=true)
    protected String securityAnswer;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="owner")
    @Valid
    protected List<JPALinkedAccount> linkedAccounts = new ArrayList<JPALinkedAccount>();
    private static int pcInheritedFieldCount = AbstractAny.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractAny;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Ljava$time$OffsetDateTime;
    static /* synthetic */ Class class$Lorg$apache$syncope$common$lib$types$CipherAlgorithm;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Ljava$lang$Boolean;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPASecurityQuestion;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPAUser;

    public AnyType getType() {
        return ((AnyTypeDAO)ApplicationContextProvider.getBeanFactory().getBean(AnyTypeDAO.class)).findUser();
    }

    public void setType(AnyType type) {
    }

    public boolean add(ExternalResource resource) {
        this.checkType(resource, JPAExternalResource.class);
        return JPAUser.pcGetresources(this).contains((JPAExternalResource)resource) || JPAUser.pcGetresources(this).add((JPAExternalResource)resource);
    }

    public List<? extends ExternalResource> getResources() {
        return JPAUser.pcGetresources(this);
    }

    public boolean add(Role role) {
        this.checkType(role, JPARole.class);
        return JPAUser.pcGetroles(this).contains((JPARole)role) || JPAUser.pcGetroles(this).add((JPARole)role);
    }

    public List<? extends Role> getRoles() {
        return JPAUser.pcGetroles(this);
    }

    public String getPassword() {
        return JPAUser.pcGetpassword(this);
    }

    public void setEncodedPassword(String password, CipherAlgorithm cipherAlgorithm) {
        JPAUser.pcSetpassword(this, password);
        JPAUser.pcSetcipherAlgorithm(this, cipherAlgorithm);
        this.setMustChangePassword(false);
    }

    public void setPassword(String password) {
        try {
            JPAUser.pcSetpassword(this, ENCRYPTOR.encode(password, JPAUser.pcGetcipherAlgorithm(this) == null ? CipherAlgorithm.valueOf((String)((String)((ConfParamOps)ApplicationContextProvider.getBeanFactory().getBean(ConfParamOps.class)).get(AuthContextUtils.getDomain(), "password.cipher.algorithm", (Object)CipherAlgorithm.AES.name(), String.class))) : JPAUser.pcGetcipherAlgorithm(this)));
            this.setMustChangePassword(false);
        }
        catch (Exception e) {
            LOG.error("Could not encode password", (Throwable)e);
            JPAUser.pcSetpassword(this, null);
        }
    }

    public CipherAlgorithm getCipherAlgorithm() {
        return JPAUser.pcGetcipherAlgorithm(this);
    }

    public void setCipherAlgorithm(CipherAlgorithm cipherAlgorithm) {
        if (JPAUser.pcGetcipherAlgorithm(this) != null && cipherAlgorithm != null) {
            throw new IllegalArgumentException("Cannot override existing cipher algorithm");
        }
        JPAUser.pcSetcipherAlgorithm(this, cipherAlgorithm);
    }

    public boolean canDecodeSecrets() {
        return JPAUser.pcGetcipherAlgorithm(this) != null && JPAUser.pcGetcipherAlgorithm(this).isInvertible();
    }

    public boolean add(UPlainAttr attr) {
        this.checkType(attr, JPAUPlainAttr.class);
        return JPAUser.pcGetplainAttrs(this).add((JPAUPlainAttr)attr);
    }

    @Override
    protected List<? extends UPlainAttr> internalGetPlainAttrs() {
        return JPAUser.pcGetplainAttrs(this);
    }

    @Override
    public String getStatus() {
        return JPAUser.pcGetstatus(this);
    }

    @Override
    public void setStatus(String status) {
        JPAUser.pcSetstatus(this, status);
    }

    public void generateToken(int tokenLength, int tokenExpireTime) {
        JPAUser.pcSettoken(this, SecureRandomUtils.generateRandomPassword((int)tokenLength));
        JPAUser.pcSettokenExpireTime(this, OffsetDateTime.now().plusMinutes(tokenExpireTime));
    }

    public void removeToken() {
        JPAUser.pcSettoken(this, null);
        JPAUser.pcSettokenExpireTime(this, null);
    }

    public String getToken() {
        return JPAUser.pcGettoken(this);
    }

    public OffsetDateTime getTokenExpireTime() {
        return JPAUser.pcGettokenExpireTime(this);
    }

    public boolean checkToken(String token) {
        return Optional.ofNullable(JPAUser.pcGettoken(this)).map(s -> s.equals(token) && !this.hasTokenExpired()).orElseGet(() -> token == null);
    }

    public boolean hasTokenExpired() {
        return Optional.ofNullable(JPAUser.pcGettokenExpireTime(this)).filter(expireTime -> expireTime.isBefore(OffsetDateTime.now())).isPresent();
    }

    public void addToPasswordHistory(String password) {
        List<String> ph = this.getPasswordHistory();
        ph.add(password);
        JPAUser.pcSetpasswordHistory(this, POJOHelper.serialize(ph));
    }

    public void removeOldestEntriesFromPasswordHistory(int n) {
        List<String> ph = this.getPasswordHistory();
        ph.subList(n, ph.size());
        JPAUser.pcSetpasswordHistory(this, POJOHelper.serialize(ph));
    }

    public List<String> getPasswordHistory() {
        return JPAUser.pcGetpasswordHistory(this) == null ? new ArrayList(0) : (List)POJOHelper.deserialize((String)JPAUser.pcGetpasswordHistory(this), TYPEREF);
    }

    public OffsetDateTime getChangePwdDate() {
        return JPAUser.pcGetchangePwdDate(this);
    }

    public void setChangePwdDate(OffsetDateTime changePwdDate) {
        JPAUser.pcSetchangePwdDate(this, changePwdDate);
    }

    public Integer getFailedLogins() {
        return JPAUser.pcGetfailedLogins(this) == null ? 0 : JPAUser.pcGetfailedLogins(this);
    }

    public void setFailedLogins(Integer failedLogins) {
        JPAUser.pcSetfailedLogins(this, failedLogins);
    }

    public OffsetDateTime getLastLoginDate() {
        return JPAUser.pcGetlastLoginDate(this);
    }

    public void setLastLoginDate(OffsetDateTime lastLoginDate) {
        JPAUser.pcSetlastLoginDate(this, lastLoginDate);
    }

    public String getUsername() {
        return JPAUser.pcGetusername(this);
    }

    public void setUsername(String username) {
        JPAUser.pcSetusername(this, username);
    }

    public void setSuspended(Boolean suspended) {
        JPAUser.pcSetsuspended(this, suspended);
    }

    public Boolean isSuspended() {
        return JPAUser.pcGetsuspended(this);
    }

    public void setMustChangePassword(boolean mustChangePassword) {
        JPAUser.pcSetmustChangePassword(this, mustChangePassword);
    }

    public boolean isMustChangePassword() {
        return JPAUser.pcGetmustChangePassword(this);
    }

    public SecurityQuestion getSecurityQuestion() {
        return JPAUser.pcGetsecurityQuestion(this);
    }

    public void setSecurityQuestion(SecurityQuestion securityQuestion) {
        this.checkType(securityQuestion, JPASecurityQuestion.class);
        JPAUser.pcSetsecurityQuestion(this, (JPASecurityQuestion)securityQuestion);
    }

    public String getSecurityAnswer() {
        return JPAUser.pcGetsecurityAnswer(this);
    }

    public void setSecurityAnswer(String securityAnswer) {
        try {
            JPAUser.pcSetsecurityAnswer(this, ENCRYPTOR.encode(securityAnswer, JPAUser.pcGetcipherAlgorithm(this) == null ? CipherAlgorithm.valueOf((String)((String)((ConfParamOps)ApplicationContextProvider.getBeanFactory().getBean(ConfParamOps.class)).get(AuthContextUtils.getDomain(), "password.cipher.algorithm", (Object)CipherAlgorithm.AES.name(), String.class))) : JPAUser.pcGetcipherAlgorithm(this)));
        }
        catch (Exception e) {
            LOG.error("Could not encode security answer", (Throwable)e);
            JPAUser.pcSetsecurityAnswer(this, null);
        }
    }

    public boolean add(AnyTypeClass auxClass) {
        this.checkType(auxClass, JPAAnyTypeClass.class);
        return JPAUser.pcGetauxClasses(this).contains((JPAAnyTypeClass)auxClass) || JPAUser.pcGetauxClasses(this).add((JPAAnyTypeClass)auxClass);
    }

    public List<? extends AnyTypeClass> getAuxClasses() {
        return JPAUser.pcGetauxClasses(this);
    }

    public boolean add(URelationship relationship) {
        this.checkType(relationship, JPAURelationship.class);
        return JPAUser.pcGetrelationships(this).add((JPAURelationship)relationship);
    }

    public Optional<? extends URelationship> getRelationship(RelationshipType relationshipType, String otherEndKey) {
        return this.getRelationships().stream().filter(relationship -> relationshipType.equals(relationship.getType()) && otherEndKey != null && otherEndKey.equals(((AnyObject)relationship.getRightEnd()).getKey())).findFirst();
    }

    public List<? extends URelationship> getRelationships() {
        return JPAUser.pcGetrelationships(this);
    }

    public boolean add(UMembership membership) {
        this.checkType(membership, JPAUMembership.class);
        return JPAUser.pcGetmemberships(this).add((JPAUMembership)membership);
    }

    @Override
    public boolean remove(UMembership membership) {
        this.checkType(membership, JPAUMembership.class);
        return JPAUser.pcGetmemberships(this).remove((JPAUMembership)membership);
    }

    public List<? extends UMembership> getMemberships() {
        return JPAUser.pcGetmemberships(this);
    }

    public boolean add(LinkedAccount account) {
        this.checkType(account, JPALinkedAccount.class);
        return JPAUser.pcGetlinkedAccounts(this).contains((JPALinkedAccount)account) || JPAUser.pcGetlinkedAccounts(this).add((JPALinkedAccount)account);
    }

    public Optional<? extends LinkedAccount> getLinkedAccount(String resource, String connObjectKeyValue) {
        return JPAUser.pcGetlinkedAccounts(this).stream().filter(account -> account.getResource().getKey().equals(resource) && account.getConnObjectKeyValue().equals(connObjectKeyValue)).findFirst();
    }

    public List<? extends LinkedAccount> getLinkedAccounts(String resource) {
        return JPAUser.pcGetlinkedAccounts(this).stream().filter(account -> account.getResource().getKey().equals(resource)).collect(Collectors.toList());
    }

    public List<? extends LinkedAccount> getLinkedAccounts() {
        return JPAUser.pcGetlinkedAccounts(this);
    }

    static {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractAny != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractAny : (class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractAny = JPAUser.class$("org.apache.syncope.core.persistence.jpa.entity.AbstractAny"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"auxClasses", "changePwdDate", "cipherAlgorithm", "failedLogins", "lastLoginDate", "linkedAccounts", "memberships", "mustChangePassword", "password", "passwordHistory", "plainAttrs", "relationships", "resources", "roles", "securityAnswer", "securityQuestion", "status", "suspended", "token", "tokenExpireTime", "username"};
        Class[] classArray = new Class[21];
        Class clazz2 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPAUser.class$("java.util.List"));
        classArray[0] = clazz2;
        Class clazz3 = class$Ljava$time$OffsetDateTime != null ? class$Ljava$time$OffsetDateTime : (class$Ljava$time$OffsetDateTime = JPAUser.class$("java.time.OffsetDateTime"));
        classArray[1] = clazz3;
        Class clazz4 = class$Lorg$apache$syncope$common$lib$types$CipherAlgorithm != null ? class$Lorg$apache$syncope$common$lib$types$CipherAlgorithm : (class$Lorg$apache$syncope$common$lib$types$CipherAlgorithm = JPAUser.class$("org.apache.syncope.common.lib.types.CipherAlgorithm"));
        classArray[2] = clazz4;
        Class clazz5 = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = JPAUser.class$("java.lang.Integer"));
        classArray[3] = clazz5;
        classArray[4] = class$Ljava$time$OffsetDateTime != null ? class$Ljava$time$OffsetDateTime : (class$Ljava$time$OffsetDateTime = JPAUser.class$("java.time.OffsetDateTime"));
        classArray[5] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPAUser.class$("java.util.List"));
        classArray[6] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPAUser.class$("java.util.List"));
        Class clazz6 = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = JPAUser.class$("java.lang.Boolean"));
        classArray[7] = clazz6;
        Class clazz7 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAUser.class$("java.lang.String"));
        classArray[8] = clazz7;
        classArray[9] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAUser.class$("java.lang.String"));
        classArray[10] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPAUser.class$("java.util.List"));
        classArray[11] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPAUser.class$("java.util.List"));
        classArray[12] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPAUser.class$("java.util.List"));
        classArray[13] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPAUser.class$("java.util.List"));
        classArray[14] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAUser.class$("java.lang.String"));
        Class clazz8 = class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPASecurityQuestion != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPASecurityQuestion : (class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPASecurityQuestion = JPAUser.class$("org.apache.syncope.core.persistence.jpa.entity.user.JPASecurityQuestion"));
        classArray[15] = clazz8;
        classArray[16] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAUser.class$("java.lang.String"));
        classArray[17] = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = JPAUser.class$("java.lang.Boolean"));
        classArray[18] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAUser.class$("java.lang.String"));
        classArray[19] = class$Ljava$time$OffsetDateTime != null ? class$Ljava$time$OffsetDateTime : (class$Ljava$time$OffsetDateTime = JPAUser.class$("java.time.OffsetDateTime"));
        classArray[20] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAUser.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{5, 26, 26, 26, 26, 5, 5, 26, 26, 26, 5, 5, 10, 10, 26, 26, 26, 26, 26, 26, 26};
        Class clazz9 = class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPAUser != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPAUser : (class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPAUser = JPAUser.class$("org.apache.syncope.core.persistence.jpa.entity.user.JPAUser"));
        PCRegistry.register((Class)clazz9, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAUser", (PersistenceCapable)new JPAUser());
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 196634845;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.auxClasses = null;
        this.changePwdDate = null;
        this.cipherAlgorithm = null;
        this.failedLogins = null;
        this.lastLoginDate = null;
        this.linkedAccounts = null;
        this.memberships = null;
        this.mustChangePassword = null;
        this.password = null;
        this.passwordHistory = null;
        this.plainAttrs = null;
        this.relationships = null;
        this.resources = null;
        this.roles = null;
        this.securityAnswer = null;
        this.securityQuestion = null;
        this.status = null;
        this.suspended = null;
        this.token = null;
        this.tokenExpireTime = null;
        this.username = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAUser jPAUser = new JPAUser();
        if (bl) {
            jPAUser.pcClearFields();
        }
        jPAUser.pcStateManager = stateManager;
        jPAUser.pcCopyKeyFieldsFromObjectId(object);
        return jPAUser;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAUser jPAUser = new JPAUser();
        if (bl) {
            jPAUser.pcClearFields();
        }
        jPAUser.pcStateManager = stateManager;
        return jPAUser;
    }

    protected static int pcGetManagedFieldCount() {
        return 21 + AbstractAny.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.auxClasses = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.changePwdDate = (OffsetDateTime)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.cipherAlgorithm = (CipherAlgorithm)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.failedLogins = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.lastLoginDate = (OffsetDateTime)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.linkedAccounts = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.memberships = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.mustChangePassword = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.password = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.passwordHistory = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.plainAttrs = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.relationships = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.resources = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.roles = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.securityAnswer = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.securityQuestion = (JPASecurityQuestion)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.status = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.suspended = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 18: {
                this.token = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 19: {
                this.tokenExpireTime = (OffsetDateTime)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 20: {
                this.username = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.auxClasses);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.changePwdDate);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.cipherAlgorithm);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.failedLogins);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastLoginDate);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.linkedAccounts);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.memberships);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.mustChangePassword);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.password);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.passwordHistory);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.plainAttrs);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.relationships);
                return;
            }
            case 12: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.resources);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.roles);
                return;
            }
            case 14: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.securityAnswer);
                return;
            }
            case 15: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.securityQuestion);
                return;
            }
            case 16: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.status);
                return;
            }
            case 17: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.suspended);
                return;
            }
            case 18: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.token);
                return;
            }
            case 19: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.tokenExpireTime);
                return;
            }
            case 20: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.username);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JPAUser jPAUser, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAUser, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.auxClasses = jPAUser.auxClasses;
                return;
            }
            case 1: {
                this.changePwdDate = jPAUser.changePwdDate;
                return;
            }
            case 2: {
                this.cipherAlgorithm = jPAUser.cipherAlgorithm;
                return;
            }
            case 3: {
                this.failedLogins = jPAUser.failedLogins;
                return;
            }
            case 4: {
                this.lastLoginDate = jPAUser.lastLoginDate;
                return;
            }
            case 5: {
                this.linkedAccounts = jPAUser.linkedAccounts;
                return;
            }
            case 6: {
                this.memberships = jPAUser.memberships;
                return;
            }
            case 7: {
                this.mustChangePassword = jPAUser.mustChangePassword;
                return;
            }
            case 8: {
                this.password = jPAUser.password;
                return;
            }
            case 9: {
                this.passwordHistory = jPAUser.passwordHistory;
                return;
            }
            case 10: {
                this.plainAttrs = jPAUser.plainAttrs;
                return;
            }
            case 11: {
                this.relationships = jPAUser.relationships;
                return;
            }
            case 12: {
                this.resources = jPAUser.resources;
                return;
            }
            case 13: {
                this.roles = jPAUser.roles;
                return;
            }
            case 14: {
                this.securityAnswer = jPAUser.securityAnswer;
                return;
            }
            case 15: {
                this.securityQuestion = jPAUser.securityQuestion;
                return;
            }
            case 16: {
                this.status = jPAUser.status;
                return;
            }
            case 17: {
                this.suspended = jPAUser.suspended;
                return;
            }
            case 18: {
                this.token = jPAUser.token;
                return;
            }
            case 19: {
                this.tokenExpireTime = jPAUser.tokenExpireTime;
                return;
            }
            case 20: {
                this.username = jPAUser.username;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAUser jPAUser = (JPAUser)object;
        if (jPAUser.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jPAUser, nArray[n]);
            ++n;
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPAUser != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPAUser : (class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPAUser = JPAUser.class$("org.apache.syncope.core.persistence.jpa.entity.user.JPAUser"));
        return clazz;
    }

    protected static final List pcGetauxClasses(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.auxClasses;
        }
        int n = pcInheritedFieldCount + 0;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.auxClasses;
    }

    protected static final void pcSetauxClasses(JPAUser jPAUser, List list) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.auxClasses = list;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 0, jPAUser.auxClasses, (Object)list, 0);
    }

    protected static final OffsetDateTime pcGetchangePwdDate(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.changePwdDate;
        }
        int n = pcInheritedFieldCount + 1;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.changePwdDate;
    }

    protected static final void pcSetchangePwdDate(JPAUser jPAUser, OffsetDateTime offsetDateTime) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.changePwdDate = offsetDateTime;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 1, (Object)jPAUser.changePwdDate, (Object)offsetDateTime, 0);
    }

    protected static final CipherAlgorithm pcGetcipherAlgorithm(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.cipherAlgorithm;
        }
        int n = pcInheritedFieldCount + 2;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.cipherAlgorithm;
    }

    protected static final void pcSetcipherAlgorithm(JPAUser jPAUser, CipherAlgorithm cipherAlgorithm) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.cipherAlgorithm = cipherAlgorithm;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 2, (Object)jPAUser.cipherAlgorithm, (Object)cipherAlgorithm, 0);
    }

    protected static final Integer pcGetfailedLogins(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.failedLogins;
        }
        int n = pcInheritedFieldCount + 3;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.failedLogins;
    }

    protected static final void pcSetfailedLogins(JPAUser jPAUser, Integer n) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.failedLogins = n;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 3, (Object)jPAUser.failedLogins, (Object)n, 0);
    }

    protected static final OffsetDateTime pcGetlastLoginDate(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.lastLoginDate;
        }
        int n = pcInheritedFieldCount + 4;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.lastLoginDate;
    }

    protected static final void pcSetlastLoginDate(JPAUser jPAUser, OffsetDateTime offsetDateTime) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.lastLoginDate = offsetDateTime;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 4, (Object)jPAUser.lastLoginDate, (Object)offsetDateTime, 0);
    }

    protected static final List pcGetlinkedAccounts(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.linkedAccounts;
        }
        int n = pcInheritedFieldCount + 5;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.linkedAccounts;
    }

    protected static final void pcSetlinkedAccounts(JPAUser jPAUser, List list) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.linkedAccounts = list;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 5, jPAUser.linkedAccounts, (Object)list, 0);
    }

    protected static final List pcGetmemberships(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.memberships;
        }
        int n = pcInheritedFieldCount + 6;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.memberships;
    }

    protected static final void pcSetmemberships(JPAUser jPAUser, List list) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.memberships = list;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 6, jPAUser.memberships, (Object)list, 0);
    }

    protected static final Boolean pcGetmustChangePassword(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.mustChangePassword;
        }
        int n = pcInheritedFieldCount + 7;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.mustChangePassword;
    }

    protected static final void pcSetmustChangePassword(JPAUser jPAUser, Boolean bl) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.mustChangePassword = bl;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 7, (Object)jPAUser.mustChangePassword, (Object)bl, 0);
    }

    protected static final String pcGetpassword(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.password;
        }
        int n = pcInheritedFieldCount + 8;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.password;
    }

    protected static final void pcSetpassword(JPAUser jPAUser, String string) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.password = string;
            return;
        }
        jPAUser.pcStateManager.settingStringField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 8, jPAUser.password, string, 0);
    }

    protected static final String pcGetpasswordHistory(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.passwordHistory;
        }
        int n = pcInheritedFieldCount + 9;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.passwordHistory;
    }

    protected static final void pcSetpasswordHistory(JPAUser jPAUser, String string) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.passwordHistory = string;
            return;
        }
        jPAUser.pcStateManager.settingStringField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 9, jPAUser.passwordHistory, string, 0);
    }

    protected static final List pcGetplainAttrs(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.plainAttrs;
        }
        int n = pcInheritedFieldCount + 10;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.plainAttrs;
    }

    protected static final void pcSetplainAttrs(JPAUser jPAUser, List list) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.plainAttrs = list;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 10, jPAUser.plainAttrs, (Object)list, 0);
    }

    protected static final List pcGetrelationships(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.relationships;
        }
        int n = pcInheritedFieldCount + 11;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.relationships;
    }

    protected static final void pcSetrelationships(JPAUser jPAUser, List list) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.relationships = list;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 11, jPAUser.relationships, (Object)list, 0);
    }

    protected static final List pcGetresources(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.resources;
        }
        int n = pcInheritedFieldCount + 12;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.resources;
    }

    protected static final void pcSetresources(JPAUser jPAUser, List list) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.resources = list;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 12, jPAUser.resources, (Object)list, 0);
    }

    protected static final List pcGetroles(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.roles;
        }
        int n = pcInheritedFieldCount + 13;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.roles;
    }

    protected static final void pcSetroles(JPAUser jPAUser, List list) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.roles = list;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 13, jPAUser.roles, (Object)list, 0);
    }

    protected static final String pcGetsecurityAnswer(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.securityAnswer;
        }
        int n = pcInheritedFieldCount + 14;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.securityAnswer;
    }

    protected static final void pcSetsecurityAnswer(JPAUser jPAUser, String string) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.securityAnswer = string;
            return;
        }
        jPAUser.pcStateManager.settingStringField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 14, jPAUser.securityAnswer, string, 0);
    }

    protected static final JPASecurityQuestion pcGetsecurityQuestion(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.securityQuestion;
        }
        int n = pcInheritedFieldCount + 15;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.securityQuestion;
    }

    protected static final void pcSetsecurityQuestion(JPAUser jPAUser, JPASecurityQuestion jPASecurityQuestion) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.securityQuestion = jPASecurityQuestion;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 15, (Object)jPAUser.securityQuestion, (Object)jPASecurityQuestion, 0);
    }

    protected static final String pcGetstatus(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.status;
        }
        int n = pcInheritedFieldCount + 16;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.status;
    }

    protected static final void pcSetstatus(JPAUser jPAUser, String string) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.status = string;
            return;
        }
        jPAUser.pcStateManager.settingStringField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 16, jPAUser.status, string, 0);
    }

    protected static final Boolean pcGetsuspended(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.suspended;
        }
        int n = pcInheritedFieldCount + 17;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.suspended;
    }

    protected static final void pcSetsuspended(JPAUser jPAUser, Boolean bl) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.suspended = bl;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 17, (Object)jPAUser.suspended, (Object)bl, 0);
    }

    protected static final String pcGettoken(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.token;
        }
        int n = pcInheritedFieldCount + 18;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.token;
    }

    protected static final void pcSettoken(JPAUser jPAUser, String string) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.token = string;
            return;
        }
        jPAUser.pcStateManager.settingStringField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 18, jPAUser.token, string, 0);
    }

    protected static final OffsetDateTime pcGettokenExpireTime(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.tokenExpireTime;
        }
        int n = pcInheritedFieldCount + 19;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.tokenExpireTime;
    }

    protected static final void pcSettokenExpireTime(JPAUser jPAUser, OffsetDateTime offsetDateTime) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.tokenExpireTime = offsetDateTime;
            return;
        }
        jPAUser.pcStateManager.settingObjectField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 19, (Object)jPAUser.tokenExpireTime, (Object)offsetDateTime, 0);
    }

    protected static final String pcGetusername(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.username;
        }
        int n = pcInheritedFieldCount + 20;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.username;
    }

    protected static final void pcSetusername(JPAUser jPAUser, String string) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.username = string;
            return;
        }
        jPAUser.pcStateManager.settingStringField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 20, jPAUser.username, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

