/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.lang.reflect.Field;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.ManyToOne;
import javax.persistence.NoResultException;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RemediationDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Notification;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.task.MacroTask;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtils;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAMacroTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPANotificationTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPullTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPushTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPASchedTask;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public class JPATaskDAO
extends AbstractDAO<Task<?>>
implements TaskDAO {
    protected final RealmDAO realmDAO;
    protected final RemediationDAO remediationDAO;
    protected final TaskUtilsFactory taskUtilsFactory;
    protected final SecurityProperties securityProperties;

    public JPATaskDAO(RealmDAO realmDAO, RemediationDAO remediationDAO, TaskUtilsFactory taskUtilsFactory, SecurityProperties securityProperties) {
        this.realmDAO = realmDAO;
        this.remediationDAO = remediationDAO;
        this.taskUtilsFactory = taskUtilsFactory;
        this.securityProperties = securityProperties;
    }

    @Transactional(readOnly=true)
    public boolean exists(TaskType type, String key) {
        Query query = this.entityManager().createNativeQuery("SELECT id FROM " + this.taskUtilsFactory.getInstance(type).getTaskTable() + " WHERE id=?");
        query.setParameter(1, (Object)key);
        return !query.getResultList().isEmpty();
    }

    @Transactional(readOnly=true)
    public <T extends Task<T>> T find(TaskType type, String key) {
        return (T)((Task)this.entityManager().find(this.taskUtilsFactory.getInstance(type).getTaskEntity(), (Object)key));
    }

    @Transactional(readOnly=true)
    public <T extends SchedTask> Optional<T> findByName(TaskType type, String name) {
        TaskUtils taskUtils = this.taskUtilsFactory.getInstance(type);
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + taskUtils.getTaskEntity().getSimpleName() + " e WHERE e.name = :name", taskUtils.getTaskEntity());
        query.setParameter("name", (Object)name);
        try {
            return Optional.of((SchedTask)query.getSingleResult());
        }
        catch (NoResultException e) {
            LOG.debug("No task found with name {}", (Object)name, (Object)e);
            return Optional.empty();
        }
    }

    public Optional<Task<?>> find(String key) {
        Object task = this.find(TaskType.SCHEDULED, key);
        if (task == null) {
            task = this.find(TaskType.PULL, key);
        }
        if (task == null) {
            task = this.find(TaskType.PUSH, key);
        }
        if (task == null) {
            task = this.find(TaskType.MACRO, key);
        }
        if (task == null) {
            task = this.find(TaskType.PROPAGATION, key);
        }
        if (task == null) {
            task = this.find(TaskType.NOTIFICATION, key);
        }
        return Optional.ofNullable(task);
    }

    public List<SchedTask> findByDelegate(Implementation delegate) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPASchedTask.class.getSimpleName() + " e WHERE e.jobDelegate=:delegate", SchedTask.class);
        query.setParameter("delegate", (Object)delegate);
        return query.getResultList();
    }

    public List<PullTask> findByReconFilterBuilder(Implementation reconFilterBuilder) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAPullTask.class.getSimpleName() + " e WHERE e.reconFilterBuilder=:reconFilterBuilder", PullTask.class);
        query.setParameter("reconFilterBuilder", (Object)reconFilterBuilder);
        return query.getResultList();
    }

    public List<PullTask> findByPullActions(Implementation pullActions) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAPullTask.class.getSimpleName() + " e WHERE :pullActions MEMBER OF e.actions", PullTask.class);
        query.setParameter("pullActions", (Object)pullActions);
        return query.getResultList();
    }

    public List<PushTask> findByPushActions(Implementation pushActions) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAPushTask.class.getSimpleName() + " e WHERE :pushActions MEMBER OF e.actions", PushTask.class);
        query.setParameter("pushActions", (Object)pushActions);
        return query.getResultList();
    }

    public List<MacroTask> findByRealm(Realm realm) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAMacroTask.class.getSimpleName() + " e WHERE e.realm=:realm", MacroTask.class);
        query.setParameter("realm", (Object)realm);
        return query.getResultList();
    }

    public List<MacroTask> findByCommand(Implementation command) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAMacroTask.class.getSimpleName() + " e WHERE :command MEMBER OF e.commands", MacroTask.class);
        query.setParameter("command", (Object)command);
        return query.getResultList();
    }

    protected final <T extends Task<T>> StringBuilder buildFindAllQueryJPA(TaskType type) {
        StringBuilder builder = new StringBuilder("SELECT t FROM ").append(this.taskUtilsFactory.getInstance(type).getTaskEntity().getSimpleName()).append(" t WHERE ");
        if (type == TaskType.SCHEDULED) {
            builder.append("t.id NOT IN (SELECT t.id FROM ").append(JPAPushTask.class.getSimpleName()).append(" t) ").append("AND ").append("t.id NOT IN (SELECT t.id FROM ").append(JPAPullTask.class.getSimpleName()).append(" t)");
        } else {
            builder.append("1=1");
        }
        return builder.append(' ');
    }

    public <T extends Task<T>> List<T> findToExec(TaskType type) {
        StringBuilder queryString = this.buildFindAllQueryJPA(type).append("AND ");
        if (type == TaskType.NOTIFICATION) {
            queryString.append("t.executed = false ");
        } else {
            queryString.append("t.executions IS EMPTY ");
        }
        queryString.append("ORDER BY t.id DESC");
        Query query = this.entityManager().createQuery(queryString.toString());
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public <T extends Task<T>> List<T> findAll(TaskType type) {
        return this.findAll(type, null, null, null, null, -1, -1, List.of());
    }

    protected int setParameter(List<Object> parameters, Object parameter) {
        parameters.add(parameter);
        return parameters.size();
    }

    protected StringBuilder buildFindAllQuery(TaskType type, ExternalResource resource, Notification notification, AnyTypeKind anyTypeKind, String entityKey, boolean orderByTaskExecInfo, List<Object> parameters) {
        if (resource != null && type != TaskType.PROPAGATION && type != TaskType.PUSH && type != TaskType.PULL) {
            throw new IllegalArgumentException(type + " is not related to " + ExternalResource.class.getSimpleName());
        }
        if ((anyTypeKind != null || entityKey != null) && type != TaskType.PROPAGATION && type != TaskType.NOTIFICATION) {
            throw new IllegalArgumentException(type + " is not related to users, groups or any objects");
        }
        if (notification != null && type != TaskType.NOTIFICATION) {
            throw new IllegalArgumentException(type + " is not related to notifications");
        }
        String taskTable = this.taskUtilsFactory.getInstance(type).getTaskTable();
        StringBuilder queryString = new StringBuilder("SELECT ").append(taskTable).append(".*");
        if (orderByTaskExecInfo) {
            String taskExecTable = this.taskUtilsFactory.getInstance(type).getTaskExecTable();
            queryString.append(',').append(taskExecTable).append(".startDate AS startDate").append(',').append(taskExecTable).append(".endDate AS endDate").append(',').append(taskExecTable).append(".status AS status").append(" FROM ").append(taskTable).append(',').append(taskExecTable).append(',').append("(SELECT ").append(taskExecTable).append(".task_id, ").append("MAX(").append(taskExecTable).append(".startDate) AS startDate").append(" FROM ").append(taskExecTable).append(" GROUP BY ").append(taskExecTable).append(".task_id) GRP").append(" WHERE ").append(taskTable).append(".id=").append(taskExecTable).append(".task_id").append(" AND ").append(taskTable).append(".id=").append("GRP.task_id").append(" AND ").append(taskExecTable).append(".startDate=").append("GRP.startDate");
        } else {
            queryString.append(", null AS startDate, null AS endDate, null AS status FROM ").append(taskTable).append(" WHERE 1=1");
        }
        queryString.append(' ');
        if (resource != null) {
            queryString.append(" AND ").append(taskTable).append(".resource_id=?").append(this.setParameter(parameters, resource.getKey()));
        }
        if (notification != null) {
            queryString.append(" AND ").append(taskTable).append(".notification_id=?").append(this.setParameter(parameters, notification.getKey()));
        }
        if (anyTypeKind != null) {
            queryString.append(" AND ").append(taskTable).append(".anyTypeKind=?").append(this.setParameter(parameters, anyTypeKind.name()));
        }
        if (entityKey != null) {
            queryString.append(" AND ").append(taskTable).append(".entityKey=?").append(this.setParameter(parameters, entityKey));
        }
        if (type == TaskType.MACRO && !AuthContextUtils.getUsername().equals(this.securityProperties.getAdminUser())) {
            String realmKeysArg = ((Set)AuthContextUtils.getAuthorizations().get("TASK_LIST")).stream().map(arg_0 -> ((RealmDAO)this.realmDAO).findByFullPath(arg_0)).filter(Objects::nonNull).flatMap(r -> this.realmDAO.findDescendants(r.getFullPath(), null, -1, -1).stream()).map(Entity::getKey).distinct().map(realmKey -> "?" + this.setParameter(parameters, realmKey)).collect(Collectors.joining(","));
            queryString.append(" AND ").append(taskTable).append(".realm_id IN (").append(realmKeysArg).append(")");
        }
        return queryString;
    }

    protected String toOrderByStatement(Class<? extends Task<?>> beanClass, List<OrderByClause> orderByClauses) {
        StringBuilder statement = new StringBuilder();
        statement.append(" ORDER BY ");
        StringBuilder subStatement = new StringBuilder();
        orderByClauses.forEach(clause -> {
            Object field = clause.getField().trim();
            switch (field) {
                case "latestExecStatus": {
                    field = "status";
                    break;
                }
                case "start": {
                    field = "startDate";
                    break;
                }
                case "end": {
                    field = "endDate";
                    break;
                }
                default: {
                    Field beanField = ReflectionUtils.findField((Class)beanClass, (String)field);
                    if (beanField == null || beanField.getAnnotation(ManyToOne.class) == null && beanField.getAnnotation(OneToMany.class) == null && beanField.getAnnotation(OneToOne.class) == null) break;
                    field = (String)field + "_id";
                }
            }
            subStatement.append((String)field).append(' ').append(clause.getDirection().name()).append(',');
        });
        if (subStatement.length() == 0) {
            statement.append("id DESC");
        } else {
            subStatement.deleteCharAt(subStatement.length() - 1);
            statement.append((CharSequence)subStatement);
        }
        return statement.toString();
    }

    public <T extends Task<T>> List<T> findAll(TaskType type, ExternalResource resource, Notification notification, AnyTypeKind anyTypeKind, String entityKey, int page, int itemsPerPage, List<OrderByClause> orderByClauses) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        boolean orderByTaskExecInfo = orderByClauses.stream().anyMatch(clause -> clause.getField().equals("start") || clause.getField().equals("end") || clause.getField().equals("latestExecStatus") || clause.getField().equals("status"));
        StringBuilder queryString = this.buildFindAllQuery(type, resource, notification, anyTypeKind, entityKey, orderByTaskExecInfo, parameters);
        if (orderByTaskExecInfo) {
            queryString.insert(0, "SELECT T.id FROM ((").append(") UNION ALL (").append((CharSequence)this.buildFindAllQuery(type, resource, notification, anyTypeKind, entityKey, false, parameters)).append(" AND id NOT IN ").append("(SELECT task_id AS id FROM ").append(this.taskUtilsFactory.getInstance(type).getTaskExecTable()).append(')').append(")) T");
        } else {
            queryString.insert(0, "SELECT T.id FROM (").append(") T");
        }
        queryString.append(this.toOrderByStatement(this.taskUtilsFactory.getInstance(type).getTaskEntity(), orderByClauses));
        Query query = this.entityManager().createNativeQuery(queryString.toString());
        for (int i = 1; i <= parameters.size(); ++i) {
            query.setParameter(i, parameters.get(i - 1));
        }
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        if (itemsPerPage > 0) {
            query.setMaxResults(itemsPerPage);
        }
        ArrayList result = new ArrayList();
        List raw = query.getResultList();
        raw.stream().map(key -> key instanceof Object[] ? (String)((Object[])key)[0] : (String)key).forEach(key -> {
            Object task = this.find(type, (String)key);
            if (task == null) {
                LOG.error("Could not find task with key {}, even if returned by native query", key);
            } else if (!result.contains(task)) {
                result.add(task);
            }
        });
        return result;
    }

    public int count(TaskType type, ExternalResource resource, Notification notification, AnyTypeKind anyTypeKind, String entityKey) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder queryString = this.buildFindAllQuery(type, resource, notification, anyTypeKind, entityKey, false, parameters);
        String table = this.taskUtilsFactory.getInstance(type).getTaskTable();
        Query query = this.entityManager().createNativeQuery(StringUtils.replaceOnce((String)queryString.toString(), (String)("SELECT " + table + ".*, null AS startDate, null AS endDate, null AS status"), (String)("SELECT COUNT(" + table + ".id)")));
        for (int i = 1; i <= parameters.size(); ++i) {
            query.setParameter(i, parameters.get(i - 1));
        }
        return ((Number)query.getSingleResult()).intValue();
    }

    @Transactional(rollbackFor={Throwable.class})
    public <T extends Task<T>> T save(T task) {
        if (task instanceof JPANotificationTask) {
            ((JPANotificationTask)task).list2json();
        } else if (task instanceof JPAPushTask) {
            ((JPAPushTask)task).map2json();
        }
        return (T)((Task)this.entityManager().merge(task));
    }

    public void delete(TaskType type, String id) {
        Object task = this.find(type, id);
        if (task == null) {
            return;
        }
        this.delete((Task<?>)task);
    }

    public void delete(Task<?> task) {
        if (task instanceof PullTask) {
            this.remediationDAO.findByPullTask((PullTask)task).forEach(remediation -> remediation.setPullTask(null));
        }
        this.entityManager().remove(task);
    }

    public void deleteAll(ExternalResource resource, TaskType type) {
        this.findAll(type, resource, null, null, null, -1, -1, List.of()).stream().map(Entity::getKey).forEach(key -> this.delete(type, (String)key));
    }

    public List<PropagationTaskTO> purgePropagations(OffsetDateTime since, List<ExecStatus> statuses, List<ExternalResource> externalResources) {
        StringBuilder queryString = new StringBuilder("SELECT t.task_id FROM PropagationTaskExec t INNER JOIN PropagationTask z ON t.task_id=z.id WHERE t.enddate=(SELECT MAX(e.enddate) FROM PropagationTaskExec e WHERE e.task_id=t.task_id) ");
        ArrayList<OffsetDateTime> queryParameters = new ArrayList<OffsetDateTime>();
        if (since != null) {
            queryParameters.add(since);
            queryString.append("AND t.enddate <= ?").append(queryParameters.size()).append(' ');
        }
        if (!CollectionUtils.isEmpty(statuses)) {
            queryString.append("AND (").append(statuses.stream().map(status -> {
                queryParameters.add((OffsetDateTime)((Object)status.name()));
                return "t.status = ?" + queryParameters.size();
            }).collect(Collectors.joining(" OR "))).append(")");
        }
        if (!CollectionUtils.isEmpty(externalResources)) {
            queryString.append("AND (").append(externalResources.stream().map(externalResource -> {
                queryParameters.add((OffsetDateTime)((Object)externalResource.getKey()));
                return "z.resource_id = ?" + queryParameters.size();
            }).collect(Collectors.joining(" OR "))).append(")");
        }
        Query query = this.entityManager().createNativeQuery(queryString.toString());
        for (int i = 1; i <= queryParameters.size(); ++i) {
            query.setParameter(i, queryParameters.get(i - 1));
        }
        List raw = query.getResultList();
        ArrayList<PropagationTaskTO> purged = new ArrayList<PropagationTaskTO>();
        raw.stream().map(Object::toString).distinct().forEach(key -> {
            PropagationTask task = (PropagationTask)this.find(TaskType.PROPAGATION, (String)key);
            if (task != null) {
                PropagationTaskTO taskTO = new PropagationTaskTO();
                taskTO.setOperation(task.getOperation());
                taskTO.setConnObjectKey(task.getConnObjectKey());
                taskTO.setOldConnObjectKey(task.getOldConnObjectKey());
                taskTO.setPropagationData(task.getSerializedPropagationData());
                taskTO.setResource(task.getResource().getKey());
                taskTO.setObjectClassName(task.getObjectClassName());
                taskTO.setAnyTypeKind(task.getAnyTypeKind());
                taskTO.setAnyType(task.getAnyType());
                taskTO.setEntityKey(task.getEntityKey());
                purged.add(taskTO);
                this.delete((Task<?>)task);
            }
        });
        return purged;
    }
}

