/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.syncope.common.lib.policy.AuthPolicyConf;
import org.apache.syncope.common.lib.policy.DefaultAuthPolicyConf;
import org.apache.syncope.core.persistence.api.dao.AuthModuleDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.entity.am.AuthModule;
import org.apache.syncope.core.persistence.api.entity.policy.AuthPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.am.JPAAuthModule;
import org.springframework.transaction.annotation.Transactional;

public class JPAAuthModuleDAO
extends AbstractDAO<AuthModule>
implements AuthModuleDAO {
    protected final PolicyDAO policyDAO;

    public JPAAuthModuleDAO(PolicyDAO policyDAO) {
        this.policyDAO = policyDAO;
    }

    @Transactional(readOnly=true)
    public AuthModule find(String key) {
        return (AuthModule)this.entityManager().find(JPAAuthModule.class, (Object)key);
    }

    @Transactional(readOnly=true)
    public List<AuthModule> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAAuthModule.class.getSimpleName() + " e", AuthModule.class);
        return query.getResultList();
    }

    public AuthModule save(AuthModule authModule) {
        ((JPAAuthModule)authModule).list2json();
        return (AuthModule)this.entityManager().merge((Object)authModule);
    }

    public void delete(String key) {
        AuthModule authModule = this.find(key);
        if (authModule == null) {
            return;
        }
        this.delete(authModule);
    }

    public void delete(AuthModule authModule) {
        this.policyDAO.find(AuthPolicy.class).stream().filter(policy -> policy.getConf() instanceof DefaultAuthPolicyConf).forEach(policy -> {
            DefaultAuthPolicyConf conf = (DefaultAuthPolicyConf)policy.getConf();
            if (conf.getAuthModules().remove(authModule.getKey())) {
                policy.setConf((AuthPolicyConf)conf);
                this.policyDAO.save((Policy)policy);
            }
        });
        this.entityManager().remove((Object)authModule);
    }
}

