/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa;

import java.util.Comparator;
import javax.sql.DataSource;
import org.apache.syncope.common.keymaster.client.api.DomainWatcher;
import org.apache.syncope.common.keymaster.client.api.model.Domain;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.api.DomainRegistry;
import org.apache.syncope.core.persistence.api.SyncopeCoreLoader;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.Ordered;

public class RuntimeDomainLoader
implements DomainWatcher {
    protected static final Logger LOG = LoggerFactory.getLogger(RuntimeDomainLoader.class);
    protected final DomainHolder domainHolder;
    protected final DomainRegistry domainRegistry;

    public RuntimeDomainLoader(DomainHolder domainHolder, DomainRegistry domainRegistry) {
        this.domainHolder = domainHolder;
        this.domainRegistry = domainRegistry;
    }

    public void added(Domain domain) {
        if (this.domainHolder.getDomains().containsKey(domain.getKey())) {
            LOG.debug("Domain {} already inited, skipping", (Object)domain.getKey());
        } else {
            LOG.info("Domain {} registration", (Object)domain.getKey());
            this.domainRegistry.register(domain);
            ApplicationContextProvider.getApplicationContext().getBeansOfType(SyncopeCoreLoader.class).values().stream().sorted(Comparator.comparing(Ordered::getOrder)).forEach(loader -> {
                String loaderName = AopUtils.getTargetClass((Object)loader).getName();
                LOG.debug("[{}] Starting on domain '{}'", (Object)loaderName, (Object)domain);
                loader.load(domain.getKey(), (DataSource)this.domainHolder.getDomains().get(domain.getKey()));
                LOG.debug("[{}] Completed on domain '{}'", (Object)loaderName, (Object)domain);
            });
            LOG.info("Domain {} successfully deployed", (Object)domain.getKey());
        }
    }

    public void removed(String domain) {
        if (this.domainHolder.getDomains().containsKey(domain)) {
            LOG.info("Domain {} unregistration", (Object)domain);
            ApplicationContextProvider.getApplicationContext().getBeansOfType(SyncopeCoreLoader.class).values().stream().sorted(Comparator.comparing(Ordered::getOrder).reversed()).forEachOrdered(loader -> {
                String loaderName = AopUtils.getTargetClass((Object)loader).getName();
                LOG.debug("[{}] Starting dispose on domain '{}'", (Object)loaderName, (Object)domain);
                loader.unload(domain);
                LOG.debug("[{}] Dispose completed on domain '{}'", (Object)loaderName, (Object)domain);
            });
            this.domainRegistry.unregister(domain);
            this.domainHolder.getDomains().remove(domain);
            LOG.info("Domain {} successfully undeployed", (Object)domain);
        } else {
            LOG.debug("Domain {} not inited, skipping", (Object)domain);
        }
    }
}

