/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.syncope.core.persistence.jpa.PersistenceProperties;
import org.apache.syncope.core.persistence.jpa.spring.CommonEntityManagerFactoryConf;
import org.apache.syncope.core.persistence.jpa.spring.DomainEntityManagerFactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.init.DataSourceInitializer;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.vendor.OpenJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;

@EnableConfigurationProperties(value={PersistenceProperties.class})
@Configuration(proxyBeanMethods=false)
public class MasterDomain {
    @ConditionalOnMissingBean(name={"MasterDataSource"})
    @Bean(name={"MasterDataSource"})
    public JndiObjectFactoryBean masterDataSource(PersistenceProperties props) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(props.getDomain().get(0).getJdbcDriver());
        hikariConfig.setJdbcUrl(props.getDomain().get(0).getJdbcURL());
        hikariConfig.setUsername(props.getDomain().get(0).getDbUsername());
        hikariConfig.setPassword(props.getDomain().get(0).getDbPassword());
        hikariConfig.setTransactionIsolation(props.getDomain().get(0).getTransactionIsolation().name());
        hikariConfig.setMaximumPoolSize(props.getDomain().get(0).getPoolMaxActive());
        hikariConfig.setMinimumIdle(props.getDomain().get(0).getPoolMinIdle());
        JndiObjectFactoryBean masterDataSource = new JndiObjectFactoryBean();
        masterDataSource.setJndiName("java:comp/env/jdbc/syncopeMasterDataSource");
        masterDataSource.setDefaultObject((Object)new HikariDataSource(hikariConfig));
        return masterDataSource;
    }

    @ConditionalOnMissingBean(name={"MasterDataSourceInitializer"})
    @Bean(name={"MasterDataSourceInitializer"})
    public DataSourceInitializer masterDataSourceInitializer(PersistenceProperties props, @Qualifier(value="MasterDataSource") JndiObjectFactoryBean masterDataSource) {
        ResourceDatabasePopulator databasePopulator = new ResourceDatabasePopulator();
        databasePopulator.setContinueOnError(true);
        databasePopulator.setIgnoreFailedDrops(true);
        databasePopulator.setSqlScriptEncoding("UTF-8");
        databasePopulator.addScript((Resource)new ClassPathResource("/audit/" + props.getDomain().get(0).getAuditSql()));
        DataSourceInitializer dataSourceInitializer = new DataSourceInitializer();
        dataSourceInitializer.setDataSource((DataSource)Objects.requireNonNull(masterDataSource.getObject()));
        dataSourceInitializer.setEnabled(true);
        dataSourceInitializer.setDatabasePopulator((DatabasePopulator)databasePopulator);
        return dataSourceInitializer;
    }

    @ConditionalOnMissingBean(name={"MasterEntityManagerFactory"})
    @DependsOn(value={"commonEMFConf"})
    @Bean(name={"MasterEntityManagerFactory"})
    public DomainEntityManagerFactoryBean masterEntityManagerFactory(PersistenceProperties props, @Qualifier(value="MasterDataSource") JndiObjectFactoryBean masterDataSource, CommonEntityManagerFactoryConf commonEMFConf) {
        OpenJpaVendorAdapter vendorAdapter = new OpenJpaVendorAdapter();
        vendorAdapter.setShowSql(false);
        vendorAdapter.setGenerateDdl(true);
        vendorAdapter.setDatabasePlatform(props.getDomain().get(0).getDatabasePlatform());
        DomainEntityManagerFactoryBean masterEntityManagerFactory = new DomainEntityManagerFactoryBean();
        masterEntityManagerFactory.setMappingResources(new String[]{props.getDomain().get(0).getOrm()});
        masterEntityManagerFactory.setPersistenceUnitName("Master");
        masterEntityManagerFactory.setDataSource(Objects.requireNonNull((DataSource)masterDataSource.getObject()));
        masterEntityManagerFactory.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        masterEntityManagerFactory.setCommonEntityManagerFactoryConf(commonEMFConf);
        if (props.getMetaDataFactory() != null) {
            masterEntityManagerFactory.setJpaPropertyMap(Map.of("openjpa.MetaDataFactory", props.getMetaDataFactory().replace("##orm##", props.getDomain().get(0).getOrm())));
        }
        return masterEntityManagerFactory;
    }

    @ConditionalOnMissingBean(name={"MasterTransactionManager"})
    @Bean(name={"MasterTransactionManager", "Master"})
    public PlatformTransactionManager transactionManager(@Qualifier(value="MasterEntityManagerFactory") DomainEntityManagerFactoryBean masterEntityManagerFactory) {
        return new JpaTransactionManager(Objects.requireNonNull(masterEntityManagerFactory.getObject()));
    }

    @Bean(name={"MasterContentXML"})
    public InputStream masterContentXML(ResourceLoader resourceLoader, PersistenceProperties props) throws IOException {
        return resourceLoader.getResource(props.getDomain().get(0).getContent()).getInputStream();
    }

    @Bean(name={"MasterKeymasterConfParamsJSON"})
    public InputStream masterKeymasterConfParamsJSON(ResourceLoader resourceLoader, PersistenceProperties props) throws IOException {
        return resourceLoader.getResource(props.getDomain().get(0).getKeymasterConfParams()).getInputStream();
    }

    @Bean(name={"MasterDatabaseSchema"})
    public String masterDatabaseSchema(PersistenceProperties props) {
        return props.getDomain().get(0).getDbSchema();
    }
}

