/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.scripting;

import groovy.lang.Binding;
import groovy.lang.Script;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apereo.cas.util.scripting.ExecutableCompiledGroovyScript;
import org.apereo.cas.util.scripting.ScriptingUtils;

public class GroovyShellScript
implements ExecutableCompiledGroovyScript {
    private final transient Script groovyScript;
    private final String script;

    public GroovyShellScript(String script) {
        this.script = script;
        this.groovyScript = ScriptingUtils.parseGroovyShellScript(script);
    }

    @Override
    public <T> T execute(Object[] args, Class<T> clazz) {
        return this.execute(args, clazz, true);
    }

    @Override
    public void execute(Object[] args) {
        this.execute(args, Void.class, true);
    }

    @Override
    public <T> T execute(Object[] args, Class<T> clazz, boolean failOnError) {
        if (this.groovyScript != null) {
            return ScriptingUtils.executeGroovyShellScript(this.groovyScript, clazz);
        }
        return null;
    }

    @Override
    public <T> T execute(String methodName, Class<T> clazz, Object ... args) {
        return this.execute(args, clazz);
    }

    @Override
    public void setBinding(Map<String, Object> variables) {
        if (variables != null && !variables.isEmpty()) {
            Binding binding = this.groovyScript.getBinding();
            variables.forEach((arg_0, arg_1) -> ((Binding)binding).setVariable(arg_0, arg_1));
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("script", (Object)this.script).toString();
    }

    @Generated
    public Script getGroovyScript() {
        return this.groovyScript;
    }

    @Generated
    public String getScript() {
        return this.script;
    }
}

