/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.resources;

import javax.ws.rs.NotFoundException;
import org.apache.syncope.client.console.rest.BpmnProcessRestClient;
import org.apache.syncope.common.lib.to.BpmnProcess;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.string.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractBpmnProcessResource
extends AbstractResource {
    private static final long serialVersionUID = 5163553843196539019L;
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractBpmnProcessResource.class);
    protected final BpmnProcessRestClient bpmnProcessRestClient;

    protected AbstractBpmnProcessResource(BpmnProcessRestClient bpmnProcessRestClient) {
        this.bpmnProcessRestClient = bpmnProcessRestClient;
    }

    protected BpmnProcess getBpmnProcess(IResource.Attributes attributes) {
        BpmnProcess bpmnProcess;
        StringValue modelId = attributes.getRequest().getQueryParameters().getParameterValue("modelId");
        BpmnProcess bpmnProcess2 = bpmnProcess = modelId == null || modelId.isNull() ? null : (BpmnProcess)this.bpmnProcessRestClient.getDefinitions().stream().filter(object -> modelId.toString().equals(object.getModelId())).findAny().orElse(null);
        if (bpmnProcess == null) {
            throw new NotFoundException("BPMN process with modelId " + modelId);
        }
        return bpmnProcess;
    }
}

