/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.layout.AnyLayoutUtils;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.UserRequestFormModal;
import org.apache.syncope.client.console.panels.UserRequestsPanel;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.RoleRestClient;
import org.apache.syncope.client.console.rest.UserRequestRestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLinksTogglePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.widgets.UserRequestFormsWidget;
import org.apache.syncope.client.ui.commons.DirectoryDataProvider;
import org.apache.syncope.client.ui.commons.layout.AbstractAnyFormLayout;
import org.apache.syncope.client.ui.commons.layout.UserForm;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.UserRequestForm;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class UserRequestFormDirectoryPanel
extends DirectoryPanel<UserRequestForm, UserRequestForm, UserRequestFormProvider, UserRequestRestClient> {
    private static final long serialVersionUID = -7122136682275797903L;
    protected static final String PREF_USER_REQUEST_FORM_PAGINATOR_ROWS = "userrequestform.paginator.rows";
    @SpringBean
    protected AnyTypeRestClient anyTypeRestClient;
    @SpringBean
    protected RoleRestClient roleRestClient;
    @SpringBean
    protected UserRestClient userRestClient;
    protected final BaseModal<UserRequestForm> manageFormModal = new BaseModal<UserRequestForm>("outer"){
        private static final long serialVersionUID = 389935548143327858L;

        protected void onConfigure() {
            super.onConfigure();
            this.addSubmitButton();
            this.size(Modal.Size.Large);
        }
    };
    protected String keyword;

    public UserRequestFormDirectoryPanel(String id, UserRequestRestClient restClient, PageReference pageRef) {
        super(id, (RestClient)restClient, pageRef, true);
        this.disableCheckBoxes();
        this.setFooterVisibility(false);
        this.modal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.manageFormModal});
        this.manageFormModal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
            this.updateResultTable(target);
            Serializable widget = SyncopeConsoleSession.get().getAttribute(UserRequestFormsWidget.class.getName());
            if (widget instanceof UserRequestFormsWidget) {
                ((UserRequestFormsWidget)((Object)((Object)((Object)widget)))).refreshLatestAlerts(target);
            }
            this.manageFormModal.show(false);
        });
        this.initResultTable();
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"USER_REQUEST_FORM_SUBMIT");
    }

    protected List<IColumn<UserRequestForm, String>> getColumns() {
        ArrayList<IColumn<UserRequestForm, String>> columns = new ArrayList<IColumn<UserRequestForm, String>>();
        columns.add((IColumn<UserRequestForm, String>)new PropertyColumn((IModel)new ResourceModel("bpmnProcess"), (Object)"bpmnProcess", "bpmnProcess"));
        columns.add((IColumn<UserRequestForm, String>)new PropertyColumn((IModel)new ResourceModel("key"), (Object)"formKey", "formKey"));
        columns.add((IColumn<UserRequestForm, String>)new PropertyColumn((IModel)new ResourceModel("username"), "username"));
        columns.add((IColumn<UserRequestForm, String>)new DatePropertyColumn((IModel)new ResourceModel("createTime"), "createTime", "createTime"));
        columns.add((IColumn<UserRequestForm, String>)new DatePropertyColumn((IModel)new ResourceModel("dueDate"), "dueDate", "dueDate"));
        columns.add((IColumn<UserRequestForm, String>)new PropertyColumn((IModel)new ResourceModel("assignee"), (Object)"assignee", "assignee"));
        return columns;
    }

    protected ActionLinksTogglePanel<UserRequestForm> actionTogglePanel() {
        return new ActionLinksTogglePanel<UserRequestForm>("outer", this.pageRef){
            private static final long serialVersionUID = -7688359318035249200L;

            public void updateHeader(AjaxRequestTarget target, Serializable object) {
                if (object instanceof UserRequestForm) {
                    this.setHeader(target, StringUtils.abbreviate((String)((UserRequestForm)object).getUsername(), (int)25));
                } else {
                    super.updateHeader(target, object);
                }
            }
        };
    }

    public ActionsPanel<UserRequestForm> getActions(final IModel<UserRequestForm> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add((ActionLink)new ActionLink<UserRequestForm>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, UserRequestForm ignore) {
                try {
                    ((UserRequestRestClient)UserRequestFormDirectoryPanel.this.restClient).claimForm(((UserRequestForm)model.getObject()).getTaskId());
                    SyncopeConsoleSession.get().success((Serializable)((Object)UserRequestFormDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{UserRequestFormDirectoryPanel.this.container});
                }
                catch (Exception e) {
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BasePage)UserRequestFormDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.CLAIM, "USER_REQUEST_FORM_CLAIM");
        panel.add((ActionLink)new ActionLink<UserRequestForm>(){
            private static final long serialVersionUID = -4496313424398213416L;

            public void onClick(AjaxRequestTarget target, UserRequestForm ignore) {
                try {
                    ((UserRequestRestClient)UserRequestFormDirectoryPanel.this.restClient).unclaimForm(((UserRequestForm)model.getObject()).getTaskId());
                    SyncopeConsoleSession.get().success((Serializable)((Object)UserRequestFormDirectoryPanel.this.getString("operation_succeeded")));
                    UserRequestFormDirectoryPanel.this.getTogglePanel().close(target);
                    target.add(new Component[]{UserRequestFormDirectoryPanel.this.container});
                }
                catch (Exception e) {
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BasePage)UserRequestFormDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }

            protected boolean statusCondition(UserRequestForm modelObject) {
                return SyncopeConsoleSession.get().getSelfTO().getUsername().equals(((UserRequestForm)model.getObject()).getAssignee());
            }
        }, ActionLink.ActionType.UNCLAIM, "USER_REQUEST_FORM_UNCLAIM");
        panel.add((ActionLink)new ActionLink<UserRequestForm>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, UserRequestForm ignore) {
                UserRequestFormDirectoryPanel.this.manageFormModal.setFormModel((IModel)new CompoundPropertyModel((Object)((UserRequestForm)model.getObject())));
                target.add(new Component[]{UserRequestFormDirectoryPanel.this.manageFormModal.setContent((ModalPanel)new UserRequestFormModal(UserRequestFormDirectoryPanel.this.manageFormModal, UserRequestFormDirectoryPanel.this.pageRef, (UserRequestForm)model.getObject()){
                    private static final long serialVersionUID = 5546519445061007248L;

                    @Override
                    public void onSubmit(AjaxRequestTarget target) {
                        try {
                            super.onSubmit(target);
                            UserRequestFormDirectoryPanel.this.getTogglePanel().close(target);
                        }
                        catch (SyncopeClientException e) {
                            SyncopeConsoleSession.get().onException((Exception)((Object)e));
                        }
                        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                })});
                UserRequestFormDirectoryPanel.this.manageFormModal.header((IModel)new Model((Serializable)((Object)UserRequestFormDirectoryPanel.this.getString("form.manage", (IModel)new Model((Serializable)((UserRequestForm)model.getObject()))))));
                UserRequestFormDirectoryPanel.this.manageFormModal.show(true);
            }

            protected boolean statusCondition(UserRequestForm modelObject) {
                return SyncopeConsoleSession.get().getSelfTO().getUsername().equals(((UserRequestForm)model.getObject()).getAssignee());
            }
        }, ActionLink.ActionType.MANAGE_APPROVAL, "USER_REQUEST_FORM_SUBMIT");
        panel.add((ActionLink)new ActionLink<UserRequestForm>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, UserRequestForm ignore) {
                UserTO newUserTO;
                UserRequestFormDirectoryPanel.this.modal.setFormModel((IModel)new CompoundPropertyModel((Object)((UserRequestForm)model.getObject())));
                UserRequestForm formTO = (UserRequestForm)model.getObject();
                if (formTO.getUserUR() == null) {
                    newUserTO = formTO.getUserTO();
                    if (newUserTO != null) {
                        newUserTO.setPassword(null);
                    }
                } else if (formTO.getUserTO() == null) {
                    UserTO previousUserTO = new UserTO();
                    previousUserTO.setKey(formTO.getUserUR().getKey());
                    newUserTO = AnyOperations.patch((UserTO)previousUserTO, (UserUR)formTO.getUserUR());
                } else {
                    formTO.getUserTO().setKey(formTO.getUserUR().getKey());
                    formTO.getUserTO().setPassword(null);
                    newUserTO = AnyOperations.patch((UserTO)formTO.getUserTO(), (UserUR)formTO.getUserUR());
                }
                AjaxWizard.EditItemActionEvent editItemActionEvent = new AjaxWizard.EditItemActionEvent((Serializable)newUserTO, target);
                editItemActionEvent.forceModalPanel(((UserForm)AnyLayoutUtils.newLayoutInfo((AnyTO)newUserTO, (List)UserRequestFormDirectoryPanel.this.anyTypeRestClient.read(AnyTypeKind.USER.name()).getClasses(), (AbstractAnyFormLayout)AnyLayoutUtils.fetch((RoleRestClient)UserRequestFormDirectoryPanel.this.roleRestClient, List.of(AnyTypeKind.USER.name())).getUser(), (AbstractAnyRestClient)UserRequestFormDirectoryPanel.this.userRestClient, (PageReference)UserRequestFormDirectoryPanel.this.pageRef)).build("content", 0, AjaxWizard.Mode.EDIT_APPROVAL));
                UserRequestFormDirectoryPanel.this.send((IEventSink)UserRequestFormDirectoryPanel.this, Broadcast.EXACT, editItemActionEvent);
            }

            protected boolean statusCondition(UserRequestForm modelObject) {
                return SyncopeConsoleSession.get().getSelfTO().getUsername().equals(((UserRequestForm)model.getObject()).getAssignee());
            }
        }, ActionLink.ActionType.EDIT_APPROVAL, "USER_REQUEST_FORM_SUBMIT");
        return panel;
    }

    protected UserRequestFormProvider dataProvider() {
        return new UserRequestFormProvider(this.rows);
    }

    protected String paginatorRowsKey() {
        return PREF_USER_REQUEST_FORM_PAGINATOR_ROWS;
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof UserRequestsPanel.UserRequestSearchEvent) {
            UserRequestsPanel.UserRequestSearchEvent payload = (UserRequestsPanel.UserRequestSearchEvent)UserRequestsPanel.UserRequestSearchEvent.class.cast(event.getPayload());
            this.keyword = payload.getKeyword();
            this.updateResultTable(payload.getTarget());
        } else {
            super.onEvent(event);
        }
    }

    protected final class UserRequestFormProvider
    extends DirectoryDataProvider<UserRequestForm> {
        private static final long serialVersionUID = -2311716167583335852L;

        public UserRequestFormProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("createTime", SortOrder.ASCENDING);
        }

        public Iterator<UserRequestForm> iterator(long first, long count) {
            int page = (int)first / this.paginatorRows;
            return ((UserRequestRestClient)UserRequestFormDirectoryPanel.this.restClient).listForms(UserRequestFormDirectoryPanel.this.keyword, (page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)this.getSort()).iterator();
        }

        public long size() {
            return ((UserRequestRestClient)UserRequestFormDirectoryPanel.this.restClient).countForms(UserRequestFormDirectoryPanel.this.keyword);
        }

        public IModel<UserRequestForm> model(UserRequestForm form) {
            return Model.of((Serializable)form);
        }
    }
}

