/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import java.util.regex.Pattern;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.RawMarkup;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.util.lang.Args;

public final class StyleAndScriptIdentifier
extends AbstractMarkupFilter {
    private static final Pattern HTML_START_COMMENT = Pattern.compile("^\\s*<!--\\s*.*", 32);
    private static final Pattern CDATA_START_COMMENT = Pattern.compile("^\\s*<!\\[CDATA\\[\\s*.*", 32);
    private static final Pattern JS_CDATA_START_COMMENT = Pattern.compile("^\\s*\\/\\*\\s*<!\\[CDATA\\[\\s*\\*\\/\\s*.*", 32);

    @Override
    protected final MarkupElement onComponentTag(ComponentTag tag) throws ParseException {
        if (tag.getNamespace() != null) {
            return tag;
        }
        String tagName = tag.getName();
        boolean isScript = "script".equalsIgnoreCase(tagName);
        boolean isStyle = "style".equalsIgnoreCase(tagName);
        if (isScript || isStyle) {
            if (tag.isOpen() && tag.getId() == null && (isScript && tag.getAttribute("src") == null || isStyle)) {
                tag.setId("_ScriptStyle");
                tag.setModified(true);
                tag.setAutoComponentTag(true);
                tag.setFlag(32, true);
            }
            tag.setUserData("STYLE_OR_SCRIPT", Boolean.TRUE);
        }
        return tag;
    }

    @Override
    public void postProcess(Markup markup) {
        for (int i = 0; i < markup.size(); ++i) {
            Object text;
            ComponentTag close;
            ComponentTag open;
            MarkupElement elem = markup.get(i);
            if (!(elem instanceof ComponentTag) || !this.shouldProcess(open = (ComponentTag)elem) || !open.isOpen() || i + 2 >= markup.size()) continue;
            MarkupElement body = markup.get(i + 1);
            MarkupElement tag2 = markup.get(i + 2);
            if (!(body instanceof RawMarkup) || !(tag2 instanceof ComponentTag) || !(close = (ComponentTag)tag2).closes(open) || !this.shouldWrapInCdata((String)(text = body.toString().trim()))) continue;
            text = "\n/*<![CDATA[*/\n" + body.toString() + "\n/*]]>*/\n";
            markup.replace(i + 1, new RawMarkup((CharSequence)text));
        }
    }

    boolean shouldWrapInCdata(String elementBody) {
        Args.notNull((Object)elementBody, (String)"elementBody");
        boolean shouldWrap = true;
        if (HTML_START_COMMENT.matcher(elementBody).matches() || CDATA_START_COMMENT.matcher(elementBody).matches() || JS_CDATA_START_COMMENT.matcher(elementBody).matches()) {
            shouldWrap = false;
        }
        return shouldWrap;
    }

    private boolean shouldProcess(ComponentTag openTag) {
        String typeAttribute = openTag.getAttribute("type");
        boolean shouldProcess = "style".equals(openTag.getName()) || typeAttribute == null || "text/javascript".equalsIgnoreCase(typeAttribute) || "module".equalsIgnoreCase(typeAttribute) || "importmap".equalsIgnoreCase(typeAttribute);
        return shouldProcess && openTag.getUserData("STYLE_OR_SCRIPT") != null;
    }
}

