/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy.optimization.predictive;

import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.proxy.AsyncCommandExecutor;
import io.github.bucket4j.distributed.proxy.CommandExecutor;
import io.github.bucket4j.distributed.proxy.optimization.DelayParameters;
import io.github.bucket4j.distributed.proxy.optimization.Optimization;
import io.github.bucket4j.distributed.proxy.optimization.OptimizationListener;
import io.github.bucket4j.distributed.proxy.optimization.PredictionParameters;
import io.github.bucket4j.distributed.proxy.optimization.batch.AsyncBatchingExecutor;
import io.github.bucket4j.distributed.proxy.optimization.batch.BatchingExecutor;
import io.github.bucket4j.distributed.proxy.optimization.predictive.PredictiveCommandExecutor;

public class PredictiveOptimization
implements Optimization {
    private final DelayParameters delayParameters;
    private final PredictionParameters predictionParameters;
    private final OptimizationListener listener;
    private final TimeMeter timeMeter;

    public PredictiveOptimization(PredictionParameters predictionParameters, DelayParameters delayParameters, OptimizationListener listener, TimeMeter timeMeter) {
        this.delayParameters = delayParameters;
        this.predictionParameters = predictionParameters;
        this.listener = listener;
        this.timeMeter = timeMeter;
    }

    @Override
    public Optimization withListener(OptimizationListener listener) {
        return new PredictiveOptimization(this.predictionParameters, this.delayParameters, listener, this.timeMeter);
    }

    @Override
    public CommandExecutor apply(CommandExecutor originalExecutor) {
        PredictiveCommandExecutor predictiveCommandExecutor = new PredictiveCommandExecutor(originalExecutor, this.delayParameters, this.predictionParameters, this.listener, this.timeMeter);
        return new BatchingExecutor(predictiveCommandExecutor, this.listener);
    }

    @Override
    public AsyncCommandExecutor apply(AsyncCommandExecutor originalExecutor) {
        PredictiveCommandExecutor predictiveCommandExecutor = new PredictiveCommandExecutor(originalExecutor, this.delayParameters, this.predictionParameters, this.listener, this.timeMeter);
        return new AsyncBatchingExecutor(predictiveCommandExecutor, this.listener);
    }
}

