/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.Date;
import org.apache.syncope.core.spring.security.AuthDataAccessor;
import org.apache.syncope.core.spring.security.JWTAuthentication;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class JWTAuthenticationProvider
implements AuthenticationProvider {
    protected final AuthDataAccessor dataAccessor;

    public JWTAuthenticationProvider(AuthDataAccessor dataAccessor) {
        this.dataAccessor = dataAccessor;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        JWTAuthentication jwtAuthentication = (JWTAuthentication)authentication;
        JWTClaimsSet claims = jwtAuthentication.getClaims();
        long referenceTime = System.currentTimeMillis();
        Date expirationTime = claims.getExpirationTime();
        if (expirationTime != null && expirationTime.getTime() < referenceTime) {
            this.dataAccessor.removeExpired(claims.getJWTID());
            throw new CredentialsExpiredException("JWT is expired");
        }
        Date notBefore = claims.getNotBeforeTime();
        if (notBefore != null && notBefore.getTime() > referenceTime) {
            throw new CredentialsExpiredException("JWT not valid yet");
        }
        jwtAuthentication.setAuthenticated(true);
        return jwtAuthentication;
    }

    public boolean supports(Class<?> authentication) {
        return JWTAuthentication.class.isAssignableFrom(authentication);
    }
}

