/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service.wa;

import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.wa.GoogleMfaAuthAccount;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="WA")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="wa/gauth")
public interface GoogleMfaAuthAccountService
extends JAXRSService {
    @DELETE
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Path(value="accts/{owner}")
    public void delete(@NotNull @PathParam(value="owner") String var1);

    @DELETE
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Path(value="accts/devices/{id}")
    public void delete(@NotNull @PathParam(value="id") long var1);

    @DELETE
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Path(value="accts")
    public void deleteAll();

    @POST
    @Path(value="accts/{owner}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void create(@NotNull @PathParam(value="owner") String var1, @NotNull GoogleMfaAuthAccount var2);

    @PUT
    @Path(value="accts/{owner}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void update(@NotNull @PathParam(value="owner") String var1, @NotNull GoogleMfaAuthAccount var2);

    @GET
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Path(value="accts/{owner}")
    public PagedResult<GoogleMfaAuthAccount> read(@NotNull @PathParam(value="owner") String var1);

    @GET
    @Path(value="accts/id/{id}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public GoogleMfaAuthAccount read(@NotNull @PathParam(value="id") long var1);

    @GET
    @Path(value="accts")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public PagedResult<GoogleMfaAuthAccount> list();
}

