/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.impl.history.async.transformer.HistoryJsonTransformer;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;

public abstract class AbstractHistoryJsonTransformer
implements HistoryJsonTransformer {
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public AbstractHistoryJsonTransformer(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    protected void dispatchEvent(CommandContext commandContext, FlowableEvent event) {
        FlowableEventDispatcher eventDispatcher = this.processEngineConfiguration.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent(event, this.processEngineConfiguration.getEngineCfgKey());
        }
    }

    public boolean historicActivityInstanceExistsForData(ObjectNode historicalData, CommandContext commandContext) {
        String activityId;
        String runtimeActivityInstanceId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"runtimeActivityInstanceId");
        if (runtimeActivityInstanceId != null) {
            return this.processEngineConfiguration.getHistoricActivityInstanceEntityManager().findById(runtimeActivityInstanceId) != null;
        }
        String executionId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"executionId");
        if (StringUtils.isNotEmpty((CharSequence)executionId) && StringUtils.isNotEmpty((CharSequence)(activityId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"activityId")))) {
            HistoricActivityInstanceEntity historicActivityInstanceEntity = this.findUnfinishedHistoricActivityInstance(commandContext, executionId, activityId);
            return historicActivityInstanceEntity != null;
        }
        return false;
    }

    public boolean historicActivityInstanceExistsForDataIncludingFinished(ObjectNode historicalData, CommandContext commandContext) {
        String activityId;
        String runtimeActivityInstanceId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"runtimeActivityInstanceId");
        if (StringUtils.isNotEmpty((CharSequence)runtimeActivityInstanceId)) {
            HistoricActivityInstanceEntity historicActivityInstanceEntity = (HistoricActivityInstanceEntity)CommandContextUtil.getHistoricActivityInstanceEntityManager(commandContext).findById(runtimeActivityInstanceId);
            return historicActivityInstanceEntity != null;
        }
        String executionId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"executionId");
        if (StringUtils.isNotEmpty((CharSequence)executionId) && StringUtils.isNotEmpty((CharSequence)(activityId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"activityId")))) {
            HistoricActivityInstanceEntity historicActivityInstanceEntity = this.findHistoricActivityInstance(commandContext, executionId, activityId);
            return historicActivityInstanceEntity != null;
        }
        return false;
    }

    protected HistoricActivityInstanceEntity findUnfinishedHistoricActivityInstance(CommandContext commandContext, String executionId, String activityId) {
        List<HistoricActivityInstanceEntity> historicActivityInstances;
        if (executionId == null || activityId == null) {
            return null;
        }
        HistoricActivityInstanceEntity historicActivityInstanceEntity = this.getUnfinishedHistoricActivityInstanceFromCache(commandContext, executionId, activityId);
        if (historicActivityInstanceEntity == null && !(historicActivityInstances = this.processEngineConfiguration.getHistoricActivityInstanceEntityManager().findUnfinishedHistoricActivityInstancesByExecutionAndActivityId(executionId, activityId)).isEmpty()) {
            historicActivityInstanceEntity = historicActivityInstances.get(0);
        }
        return historicActivityInstanceEntity;
    }

    protected HistoricActivityInstanceEntity getUnfinishedHistoricActivityInstanceFromCache(CommandContext commandContext, String executionId, String activityId) {
        List cachedHistoricActivityInstances = CommandContextUtil.getEntityCache(commandContext).findInCache(HistoricActivityInstanceEntity.class);
        for (HistoricActivityInstanceEntity cachedHistoricActivityInstance : cachedHistoricActivityInstances) {
            if (activityId == null || !activityId.equals(cachedHistoricActivityInstance.getActivityId()) || cachedHistoricActivityInstance.getEndTime() != null || !executionId.equals(cachedHistoricActivityInstance.getExecutionId())) continue;
            return cachedHistoricActivityInstance;
        }
        return null;
    }

    protected HistoricActivityInstanceEntity findHistoricActivityInstance(CommandContext commandContext, String executionId, String activityId) {
        List<HistoricActivityInstanceEntity> historicActivityInstances;
        if (executionId == null || activityId == null) {
            return null;
        }
        HistoricActivityInstanceEntity historicActivityInstanceEntity = this.getHistoricActivityInstanceFromCache(commandContext, executionId, activityId);
        if (historicActivityInstanceEntity == null && !(historicActivityInstances = this.processEngineConfiguration.getHistoricActivityInstanceEntityManager().findHistoricActivityInstancesByExecutionAndActivityId(executionId, activityId)).isEmpty()) {
            historicActivityInstanceEntity = historicActivityInstances.get(0);
        }
        return historicActivityInstanceEntity;
    }

    protected HistoricActivityInstanceEntity getHistoricActivityInstanceFromCache(CommandContext commandContext, String executionId, String activityId) {
        List cachedHistoricActivityInstances = CommandContextUtil.getEntityCache(commandContext).findInCache(HistoricActivityInstanceEntity.class);
        for (HistoricActivityInstanceEntity cachedHistoricActivityInstance : cachedHistoricActivityInstances) {
            if (activityId == null || !activityId.equals(cachedHistoricActivityInstance.getActivityId()) || !executionId.equals(cachedHistoricActivityInstance.getExecutionId())) continue;
            return cachedHistoricActivityInstance;
        }
        return null;
    }

    protected HistoricActivityInstanceEntity createHistoricActivityInstanceEntity(ObjectNode historicalData, CommandContext commandContext, HistoricActivityInstanceEntityManager historicActivityInstanceEntityManager) {
        String runtimeActivityId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"runtimeActivityInstanceId");
        HistoricActivityInstanceEntity historicActivityInstanceEntity = (HistoricActivityInstanceEntity)historicActivityInstanceEntityManager.create();
        if (StringUtils.isEmpty((CharSequence)runtimeActivityId)) {
            if (this.processEngineConfiguration.isUsePrefixId()) {
                historicActivityInstanceEntity.setId(historicActivityInstanceEntity.getIdPrefix() + this.processEngineConfiguration.getIdGenerator().getNextId());
            } else {
                historicActivityInstanceEntity.setId(this.processEngineConfiguration.getIdGenerator().getNextId());
            }
        } else {
            historicActivityInstanceEntity.setId(runtimeActivityId);
        }
        return historicActivityInstanceEntity;
    }
}

